package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAddAuditCallBackReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAddAuditCallBackRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:AgrAgrAddAuditCallBackServiceImpl
 * 说明:TODO
 * 时间:2022/9/20 12:49
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrAddAuditCallBackServiceImpl implements AgrAgrAddAuditCallBackService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrAgrAddAuditCallBackRspBO dealAgrAddAuditCallBack(AgrAgrAddAuditCallBackReqBO reqBO) {
        // 1 修改协议信息
        this.updateAgrMain(reqBO.getAgrId());
        // 新增协议版本记录
        this.saveAgrVersion(reqBO);

        return AgrRu.success(AgrAgrAddAuditCallBackRspBO.class);


    }
    /**
     * 修改协议信息
     */
    private void updateAgrMain(Long agrId){
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        // 查询协议详情
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrId);
        AgrAgrDo agrAgrDoDetail = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
        //新增待生效状态，审批通过后判断该协议是否到达生效时间，如果没有，为待生效状态；若有，为启用状态；
        Date effDate = agrAgrDoDetail.getEffDate();
        if(ObjectUtil.isNull(effDate)){
            agrAgrDo.setEffDate(new Date());
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        }else {
            Date date = new Date();
            int i = date.compareTo(effDate);
            if (i < 0) {
                //当前时间小于生效时间，为待生效状态
                agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.WAIT_ENABLE);
            } else {
                //为启用状态
                agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
            }
        }

        agrAgrDo.setAgrId(agrId);
        agrAgrDo.setAgrVersion("V1");
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
    }
    /**
     * 新增协议版本记录
     */
    private void saveAgrVersion(AgrAgrAddAuditCallBackReqBO reqBO){
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(reqBO.getAgrId());
        AgrAgrDo agrAgrDoDetail = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);

        AgrAgrDo agrAgrDo = new AgrAgrDo();
        List<AgrAgrVersion> agrAgrVersions = new ArrayList<>();
        AgrAgrVersion AgrAgrVersion = new AgrAgrVersion();
        AgrAgrVersion.setAgrId(agrAgrDoDetail.getAgrId());
        AgrAgrVersion.setAgrCode(agrAgrDoDetail.getAgrCode());
        AgrAgrVersion.setCreateTime(new Date());
        AgrAgrVersion.setChngType(AgrCommConstant.AgreementChangeType.ORGINAL);
        AgrAgrVersion.setVersionStatus(AgrCommConstant.AgrVersionStatus.VALID);
        AgrAgrVersion.setAgrVersion("V1");
        AgrAgrVersion.setChngApplyCreateTime(agrAgrDoDetail.getCreateTime());
        AgrAgrVersion.setRelCode(agrAgrDoDetail.getRelCode());
        agrAgrVersions.add(AgrAgrVersion);
        agrAgrDo.setAgrAgrVersion(agrAgrVersions);
        agrAgrDo.setAgrId(agrAgrDoDetail.getAgrId());

        this.iAgrAgrModel.saveAgrVersion(agrAgrDo);
    }
}
