package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.service.agr.bo.AgrChangeSynReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrChangeSynRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;

/**
 * @Description: AgrChangeSynServiceImpl
 * @Author: the_xhl
 * @Date: 2023-07-28
 */
@HTServiceImpl
public class AgrChangeSynServiceImpl implements AgrChangeSynService {

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrChangeSynRspBO dealChangeSyn(AgrChangeSynReqBO agrChangeSynReqBO) {
        this.check(agrChangeSynReqBO);
        AgrChangeSynRspBO rspBO = AgrRu.success(AgrChangeSynRspBO.class);
        AgrAgrDo agrAgrDo = AgrRu.js(agrChangeSynReqBO, AgrAgrDo.class);
        AgrAgrVersion agrAgrVersion = new AgrAgrVersion();
        agrAgrVersion.setChngApplyCreateTime(agrChangeSynReqBO.getChngApplyCreateTime());
        agrAgrVersion.setChngType(agrChangeSynReqBO.getChngType());
        agrAgrDo.setAgrAgrVersion(Collections.singletonList(agrAgrVersion));
        this.iAgrAgrModel.dealChangeSyn(agrAgrDo);
        return rspBO;
    }

    private void check(AgrChangeSynReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isNull(reqBO.getChngType())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[变更类型]不能为空");
        }
    }
}
