package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateReferenceAgrReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateReferenceAgrRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:AgrCreateReferenceAgrServiceImpl
 * 说明:TODO
 * 时间:2023/7/28 11:05
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrCreateReferenceAgrServiceImpl implements AgrCreateReferenceAgrService{
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrCreateReferenceAgrRspBO createReferenceAgr(AgrCreateReferenceAgrReqBO agrCreateReferenceAgrReqBO) {
        // 1 入参校验
        this.validateParam(agrCreateReferenceAgrReqBO);
        // 2 根据入参中的协议ID查询协议详情
        AgrAgrDo agrAgrDetailDo = this.getAgrDetail(agrCreateReferenceAgrReqBO.getAgrId());
        // 3 调用协议新增方法
        this.createAgr(agrAgrDetailDo,agrCreateReferenceAgrReqBO);
        // 4 复制协议明细
        this.copyAgrItem(agrCreateReferenceAgrReqBO.getAgrId(),agrAgrDetailDo.getAgrId());

        AgrCreateReferenceAgrRspBO rspBO = AgrRu.success(AgrCreateReferenceAgrRspBO.class);
        rspBO.setAgrId(agrAgrDetailDo.getAgrId());
        return rspBO;
    }
    /**
     * 复制协议
     */
    private void createAgr(AgrAgrDo agrAgrDetailDo, AgrCreateReferenceAgrReqBO agrCreateReferenceAgrReqBO){
        agrAgrDetailDo.setOperTime(new Date());
        agrAgrDetailDo.setAgrOperatorId(agrCreateReferenceAgrReqBO.getUserId());
        agrAgrDetailDo.setAgrOperatorName(agrCreateReferenceAgrReqBO.getUsername());
        agrAgrDetailDo.setOrgPath(agrCreateReferenceAgrReqBO.getOrgPath());
        agrAgrDetailDo.setAgrCode(agrCreateReferenceAgrReqBO.getAgrCode());
        agrAgrDetailDo.setAgrId(IdUtil.nextId());
        agrAgrDetailDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
        agrAgrDetailDo.setParentAgrId(agrCreateReferenceAgrReqBO.getAgrId());
        agrAgrDetailDo.setAgrType(AgrCommConstant.AgrType.REFERENCE_AGR);
        agrAgrDetailDo.setOrgId(agrCreateReferenceAgrReqBO.getOrgId());
        agrAgrDetailDo.setOrgName(agrCreateReferenceAgrReqBO.getOrgName());
        agrAgrDetailDo.setAgrVersion("V1");
        // 适用范围
        List<AgrAppScope> agrAppScope = new ArrayList<>();
        AgrAppScope bo = new AgrAppScope();
        bo.setScopeCode(agrCreateReferenceAgrReqBO.getCompanyId()+"");
        bo.setScopeName(agrCreateReferenceAgrReqBO.getCompanyName());
        bo.setScopeType(AgrCommConstant.ScopeType.DESINGATE_UNIT);
        agrAppScope.add(bo);
        agrAgrDetailDo.setAgrAppScope(agrAppScope);
        agrAgrDetailDo.setScopeType(AgrCommConstant.ScopeType.DESINGATE_UNIT);
        // 铺货单位
        agrAgrDetailDo.setManagementOrgId(agrCreateReferenceAgrReqBO.getCompanyId().toString());
        agrAgrDetailDo.setManagementOrgName(agrCreateReferenceAgrReqBO.getCompanyName());
        // 协议失效日期
        agrAgrDetailDo.setExpDate(null);
        agrAgrDetailDo.setEffDate(null);
        agrAgrDetailDo.setCreateTime(new Date());
        agrAgrDetailDo.setAgrSignTime(new Date());
        this.iAgrAgrModel.createAgr(agrAgrDetailDo);
    }
    /**
     * 复制明细数据
     */
    private void copyAgrItem(Long agrIdOld, Long agrIdNew){
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrId(agrIdOld);
        // 1 先按每次1000条复制，先查有多少页
        agrItemListQryReqPageBo.setOrderBy("agr_item_id");
        agrItemListQryReqPageBo.setPageNo(1);
        agrItemListQryReqPageBo.setPageSize(1000);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        if(!CollectionUtils.isEmpty(agrItemListQryRspPageBo.getRows())){
            this.saveAgrItem(agrIdNew,agrItemListQryRspPageBo.getRows());
            // 如果明细数据不止一页
            if(agrItemListQryRspPageBo.getTotal()>1){
                int total = agrItemListQryRspPageBo.getTotal();
                for (int i=2;i<=total;i++){
                    agrItemListQryReqPageBo.setPageNo(i);
                    agrItemListQryReqPageBo.setPageSize(1000);
                    AgrItemListQryRspPageBo agrItemListQryRspPageBo1 = iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
                    this.saveAgrItem(agrIdNew,agrItemListQryRspPageBo1.getRows());
                }
            }
        }

    }
    /**
     * 新增协议明细
     */
    private void saveAgrItem(Long agrIdNew, List<AgrItem> agrItems){
        agrItems.forEach(agrItem -> {
            agrItem.setAgrItemId(null);
        });
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrIdNew);
        agrAgrDo.setAgrItem(agrItems);
        this.iAgrAgrModel.saveAgrItem(agrAgrDo);
    }

    /**
     * 协议详情查询
     */
    private AgrAgrDo getAgrDetail(Long agrId){
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo() ;
        agrAgrQryBo.setAgrId(agrId);
        return this.iAgrAgrModel.getAgrDetail(agrAgrQryBo);

    }
    /**
     * 入参校验
     */
    private void validateParam(AgrCreateReferenceAgrReqBO agrCreateReferenceAgrReqBO){
        if (agrCreateReferenceAgrReqBO == null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (agrCreateReferenceAgrReqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrId]不能为空");
        }
        if(StringUtils.isEmpty(agrCreateReferenceAgrReqBO.getAgrCode())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrCode]不能为空");
        }
    }
}
