package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListByAgrInfoReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListByAgrInfoRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * 标题:AgrGetAgrItemListByAgrInfoServiceImpl
 * 说明:TODO
 * 时间:2022/9/15 17:31
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetAgrItemListByAgrInfoServiceImpl implements AgrGetAgrItemListByAgrInfoService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrGetAgrItemListByAgrInfoRspBO getAgrItemListByAgrInfo(AgrGetAgrItemListByAgrInfoReqBO reqBO) {
        // 1 必填校验
        this.validParam(reqBO);
        // 2.调用协议信息
        if(reqBO.getAgrId()==null){
            reqBO.setAgrId(this.getAgrId(reqBO));
        }
        // 3.查询协议明细信息
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = JSON.parseObject(JSON.toJSONString(reqBO),AgrItemListQryReqPageBo.class) ;
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        AgrGetAgrItemListByAgrInfoRspBO rspBO = JSON.parseObject(JSON.toJSONString(agrItemListQryRspPageBo),AgrGetAgrItemListByAgrInfoRspBO.class);
        rspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(AgrRspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }
    /**
     * 查询协议信息
     */
    private Long getAgrId(AgrGetAgrItemListByAgrInfoReqBO reqBO){
        AgrAgrQryBo agrAgrQryBo = new  AgrAgrQryBo();
        agrAgrQryBo.setAgrCode(reqBO.getAgrCode());
        AgrAgrDo agrAgrDo = iAgrAgrModel.getAgrMain(agrAgrQryBo);
        if(null== agrAgrDo ){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR,"协议信息不存在");
        }
        return agrAgrDo.getAgrId();
    }
    /**
     * 必填校验
     */
    private void validParam(AgrGetAgrItemListByAgrInfoReqBO reqBO){
        if(reqBO==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_OBJ_EMPTY_ERROR,"入参对象不能为空");
        }
        if(reqBO.getAgrId()==null && StringUtils.isEmpty(reqBO.getAgrCode())){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参agrId和agrCode不能同时为空！");
        }
        if(reqBO.getPageNo()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参pageNo不能为空！");
        }
        if(reqBO.getPageSize()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参pageSize不能为空！");
        }
    }
}
