package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListReqBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListRspBo;
import com.tydic.dyc.agr.model.sysDicDictionary.IAgrDictionaryModel;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrVersionBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrVersionReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrVersionRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题:AgrGetAgrVersionServiceImpl
 * 说明:TODO
 * 时间:2022/10/18 14:47
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetAgrVersionServiceImpl implements AgrGetAgrVersionService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Autowired
    private IAgrDictionaryModel iAgrDictionaryModel;
    @Override
    public AgrGetAgrVersionRspBO getAgrVersionList(AgrGetAgrVersionReqBO reqBO) {
        // 1 入参校验
        this.validateParam(reqBO);
        // 2 调用版本列表查询方法
        AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo = AgrRu.js(reqBO,AgrGetAgrVersionListReqBo.class);
        AgrGetAgrVersionListRspBo agrGetAgrVersionListRspBo = this.iAgrAgrModel.getAgrVersionList(agrGetAgrVersionListReqBo);
        AgrGetAgrVersionRspBO rspBO = AgrRu.js(agrGetAgrVersionListRspBo,AgrGetAgrVersionRspBO.class);
        this.translation(rspBO);
        rspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);
        return rspBO;
    }
    /**
     * 入参校验
     */
    private void validateParam(AgrGetAgrVersionReqBO reqBO){
        if (ObjectUtil.isEmpty(reqBO)){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象不能为空");
        }
        if (reqBO.getAgrId()==null){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[agrId]不能为空");
        }
    }

    private void translation(AgrGetAgrVersionRspBO rspBo) {
        List<AgrAgrVersionBo> agrAgrVersionList = rspBo.getRows();
        if (CollectionUtil.isNotEmpty(agrAgrVersionList)) {
            AgrAgrVersionBo agrAgrVersion = agrAgrVersionList.get(0);
            List<String> pCodeList = new ArrayList<>();
            if (ObjectUtil.isNotNull(agrAgrVersion.getVersionStatus())) {
                pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.VERSION_STATUS_PCODE);
            }
            if (ObjectUtil.isNotNull(agrAgrVersion.getChngType())) {
                pCodeList.add(AgrCommConstant.SysDicDictionaryPCode.CHNG_TYPE_PCODE);
            }
            Map<String, Map<String, DicDictionaryBo>> dicMap = this.iAgrDictionaryModel.selectByPCodeListToMap(pCodeList);
            if (MapUtil.isNotEmpty(dicMap)) {
                for (AgrAgrVersionBo agrVersion : agrAgrVersionList) {
                    agrVersion.setVersionStatusStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.VERSION_STATUS_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.VERSION_STATUS_PCODE).get(agrVersion.getVersionStatus().toString()).getTitle());
                    agrVersion.setChngTypeStr(MapUtil.isEmpty(dicMap.get(AgrCommConstant.SysDicDictionaryPCode.CHNG_TYPE_PCODE)) ? null : dicMap.get(AgrCommConstant.SysDicDictionaryPCode.CHNG_TYPE_PCODE).get(agrVersion.getChngType().toString()).getTitle());
                }
            }
        }
    }
}
