package com.tydic.dyc.agr.service.procinst;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrProcQryBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetProcInstListReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetProcInstListRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetProcInstRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: AgrGetProcInstListServiceImpl
 * @Author: the_xhl
 * @Date: 2023-08-14
 */
@HTServiceImpl
public class AgrGetProcInstListServiceImpl implements AgrGetProcInstListService {

    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Override
    public AgrGetProcInstListRspBO getProcInstList(AgrGetProcInstListReqBO reqBO) {
        this.check(reqBO);
        AgrGetProcInstListRspBO rspBO = AgrRu.success(AgrGetProcInstListRspBO.class);
        AgrProcInstDo procInstList = this.iAgrProcInstModel.getProcInstList(AgrRu.js(reqBO, AgrProcQryBo.class));
        rspBO.setProcInstList(AgrRu.jsl(procInstList.getAgrUocOrderProcInst(), AgrGetProcInstRspBO.class));
        return rspBO;
    }

    private void check(AgrGetProcInstListReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getOrderId())) {
            throw new BaseBusinessException("", "入参对象属性[订单ID]不能为空");
        }
    }
}
