/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.model.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrAllocateRecordListRspBO;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrItemCountByCommodityTypeReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrItemCountByCommodityTypeRspPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListReqBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListRspBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAllAgrListRspBO;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.repository.AgrAgrRepository;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IAgrAgrModelImpl
implements IAgrAgrModel {
    @Autowired
    private AgrAgrRepository agrAgrRepository;

    @Override
    public void updateAgrMain(AgrAgrDo agrAgrDo) {
        this.validation(agrAgrDo);
        this.agrAgrRepository.updateAgrMain(agrAgrDo);
    }

    private void validation(AgrAgrDo agrAgrDo) {
        if (agrAgrDo == null || agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void createAgr(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            agrAgrDo.setAgrId(IdUtil.nextId());
        }
        if (ObjectUtil.isEmpty((Object)agrAgrDo.getAgrVersion())) {
            agrAgrDo.setAgrVersion("V1");
        }
        if (ObjectUtil.isEmpty((Object)agrAgrDo.getAgrStatus())) {
            agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
        }
        this.agrAgrRepository.saveAgrMain(agrAgrDo);
        this.agrAgrRepository.saveAgrSub(agrAgrDo);
    }

    @Override
    public void updateAgr(AgrAgrDo agrAgrDo) {
        this.validateAgrMain(agrAgrDo);
        this.agrAgrRepository.updateAgrMain(agrAgrDo);
        this.agrAgrRepository.deleteAgrSub(agrAgrDo);
        this.agrAgrRepository.saveAgrSub(agrAgrDo);
    }

    @Override
    public AgrAgrDo getAgrMain(AgrAgrQryBo agrAgrQryBo) {
        return this.agrAgrRepository.getAgrMain(agrAgrQryBo);
    }

    @Override
    public void deleteAgr(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.agrAgrRepository.deleteAgrMain(agrAgrDo);
    }

    @Override
    public AgrAgrDo getAgrDetail(AgrAgrQryBo agrAgrQryBo) {
        return this.agrAgrRepository.getAgrDetail(agrAgrQryBo);
    }

    @Override
    public AgrItemListQryRspPageBo getAgrItemList(AgrItemListQryReqPageBo agrItemListQryReqPageBo) {
        return this.agrAgrRepository.getAgrItemtList(agrItemListQryReqPageBo);
    }

    @Override
    public void saveAgrItem(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null && ObjectUtil.isEmpty((Object)agrAgrDo.getAgrId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.agrAgrRepository.saveAgrItem(agrAgrDo);
    }

    @Override
    public void updateAgrItem(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null || CollectionUtils.isEmpty(agrAgrDo.getAgrItem())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.agrAgrRepository.deleteAgrItemByBatch(agrAgrDo);
        this.agrAgrRepository.saveAgrItem(agrAgrDo);
    }

    @Override
    public void deleteAgrItemByBatch(AgrAgrDo agrAgrDo) {
        if (agrAgrDo.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.agrAgrRepository.deleteAgrItemByBatch(agrAgrDo);
    }

    @Override
    public void updateAgrItemByBatch(AgrAgrDo param0) {
        if (param0.getAgrId() == null || CollectionUtils.isEmpty(param0.getAgrItem())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.agrAgrRepository.updateAgrItemByBatch(param0);
    }

    @Override
    public AgrGetAllAgrListRspBO getAllAgrList() {
        return this.agrAgrRepository.getAllAgrList();
    }

    @Override
    public void saveAgrAllocateRecord(AgrAgrDo agrAgrDo) {
        this.validateAllocatrRecord(agrAgrDo);
        this.agrAgrRepository.saveAgrAllocateRecord(agrAgrDo);
    }

    @Override
    public AgrAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrAgrQryBo agrAgrQryBo) {
        return this.agrAgrRepository.getAgrAllocateRecordList(agrAgrQryBo);
    }

    @Override
    public AgrGetAgrMainListRspQryBo getAgrMainList(AgrAgrQryBo agrAgrQryBo) {
        return this.agrAgrRepository.getAgrMainList(agrAgrQryBo);
    }

    @Override
    public AgrGetAgrItemCountByCommodityTypeRspPageBo getAgrItemCount(AgrGetAgrItemCountByCommodityTypeReqPageBo reqPageBo) {
        return this.agrAgrRepository.getAgrItemCountByCommodityType(reqPageBo);
    }

    @Override
    public void saveAgrVersion(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.saveAgrVersion(agrAgrDo);
    }

    @Override
    public AgrGetAgrVersionListRspBo getAgrVersionList(AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo) {
        return this.agrAgrRepository.getAgrVersionList(agrGetAgrVersionListReqBo);
    }

    @Override
    public void saveAgrHis(AgrAgrDo agrAgrDo) {
        this.agrAgrRepository.saveAgrHis(agrAgrDo);
    }

    private void validateAgrMain(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isEmpty((Object)agrAgrDo)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)agrAgrDo.getAgrId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateAllocatrRecord(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isEmpty(agrAgrDo.getAgrAllocateRecord())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        agrAgrDo.getAgrAllocateRecord().forEach(agrAllocateRecord -> {
            if (ObjectUtil.isEmpty((Object)agrAllocateRecord.getAgrOperatorIdOld())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u539f\u534f\u8bae\u7ecf\u529e\u4ebaID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)agrAllocateRecord.getAgrOperatorNameOld())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u539f\u534f\u8bae\u7ecf\u529e\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)agrAllocateRecord.getAgrOperatorUsernameOld())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u539f\u534f\u8bae\u7ecf\u529e\u4eba\u7528\u6237\u540d]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)agrAllocateRecord.getAgrOperatorId())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u7ecf\u529e\u4ebaID]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)agrAllocateRecord.getAgrOperatorName())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u7ecf\u529e\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)agrAllocateRecord.getAgrOperatorUsername())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u7ecf\u529e\u4eba\u7528\u6237\u540d]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

