/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.service.agr.AgrCopyService;
import com.tydic.dyc.agr.service.agr.bo.AgrCopyReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCopyRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrCopyService"})
public class AgrCopyServiceImpl
implements AgrCopyService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"dealAgrCopy"})
    public AgrCopyRspBO dealAgrCopy(@RequestBody AgrCopyReqBO agrCopyReqBO) {
        this.validateParam(agrCopyReqBO);
        AgrAgrDo agrAgrDetailDo = this.getAgrDetail(agrCopyReqBO.getAgrId());
        this.createAgr(agrAgrDetailDo, agrCopyReqBO);
        this.copyAgrItem(agrCopyReqBO.getAgrId(), agrAgrDetailDo.getAgrId());
        AgrCopyRspBO rspBO = AgrRu.success(AgrCopyRspBO.class);
        rspBO.setAgrId(agrAgrDetailDo.getAgrId());
        return rspBO;
    }

    private void createAgr(AgrAgrDo agrAgrDetailDo, AgrCopyReqBO agrCopyReqBO) {
        agrAgrDetailDo.setOperTime(new Date());
        agrAgrDetailDo.setUserId(agrCopyReqBO.getUserId());
        agrAgrDetailDo.setUsername(agrCopyReqBO.getUsername());
        agrAgrDetailDo.setName(agrCopyReqBO.getName());
        agrAgrDetailDo.setOrgId(agrCopyReqBO.getOrgId());
        agrAgrDetailDo.setOrgName(agrCopyReqBO.getOrgName());
        agrAgrDetailDo.setAgrCode(agrCopyReqBO.getAgrCode());
        agrAgrDetailDo.setAgrId(IdUtil.nextId());
        agrAgrDetailDo.setAgrStatus(AgrCommConstant.AgreementStatus.DRAFT);
        this.iAgrAgrModel.createAgr(agrAgrDetailDo);
    }

    private void copyAgrItem(Long agrIdOld, Long agrIdNew) {
        AgrItemListQryReqPageBo agrItemListQryReqPageBo = new AgrItemListQryReqPageBo();
        agrItemListQryReqPageBo.setAgrId(agrIdOld);
        agrItemListQryReqPageBo.setPageNo(1);
        agrItemListQryReqPageBo.setPageSize(1000);
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
        if (!CollectionUtils.isEmpty(agrItemListQryRspPageBo.getRows())) {
            this.saveAgrItem(agrIdNew, agrItemListQryRspPageBo.getRows());
            if (agrItemListQryRspPageBo.getTotal() > 1) {
                int total = agrItemListQryRspPageBo.getTotal();
                for (int i = 2; i <= total; ++i) {
                    agrItemListQryReqPageBo.setPageNo(i);
                    agrItemListQryReqPageBo.setPageSize(1000);
                    AgrItemListQryRspPageBo agrItemListQryRspPageBo1 = this.iAgrAgrModel.getAgrItemList(agrItemListQryReqPageBo);
                    this.saveAgrItem(agrIdNew, agrItemListQryRspPageBo1.getRows());
                }
            }
        }
    }

    private void saveAgrItem(Long agrIdNew, List<AgrItem> agrItems) {
        agrItems.forEach(agrItem -> agrItem.setAgrItemId(null));
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(agrIdNew);
        agrAgrDo.setAgrItem(agrItems);
        this.iAgrAgrModel.saveAgrItem(agrAgrDo);
    }

    private AgrAgrDo getAgrDetail(Long agrId) {
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(agrId);
        return this.iAgrAgrModel.getAgrDetail(agrAgrQryBo);
    }

    private void validateParam(AgrCopyReqBO agrCopyReqBO) {
        if (ObjectUtil.isEmpty((Object)agrCopyReqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (agrCopyReqBO.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)agrCopyReqBO.getAgrCode())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

