/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agrchange;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrChngAccessory;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrChngAccessoryBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService"})
public class AgrGetAgrChngApplyDetailServiceImpl
implements AgrGetAgrChngApplyDetailService {
    private static final Logger log = LoggerFactory.getLogger(AgrGetAgrChngApplyDetailServiceImpl.class);
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @PostMapping(value={"getAgrChngApplyDetail"})
    public AgrGetAgrChngApplyDetailRspBO getAgrChngApplyDetail(@RequestBody AgrGetAgrChngApplyDetailReqBO reqBO) {
        this.validationParam(reqBO);
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrChngApplyDetail(AgrRu.js(reqBO, AgrAgrChngApplyQryBo.class));
        return this.typeEscape(agrChngApplyDo);
    }

    private AgrGetAgrChngApplyDetailRspBO typeEscape(AgrChngApplyDo agrChngApplyDo) {
        AgrGetAgrChngApplyDetailRspBO rspBO = AgrRu.js(agrChngApplyDo, AgrGetAgrChngApplyDetailRspBO.class);
        if (agrChngApplyDo.getChngApplyId() != null) {
            rspBO.setChngTypeStr(AgrCommConstant.AgrChngTypeEnum.getValueByCode((Integer)rspBO.getChngType()));
            rspBO.setChngApplyStatusStr(AgrCommConstant.ChngApplyStatusEnum.getNameByValue((Integer)AgrRu.parseInteger(rspBO.getChngApplyStatus())));
            List<AgrChngAccessory> agrChngAccessory = agrChngApplyDo.getAgrChngAccessory();
            rspBO.setAgrChngAccessory(AgrRu.jsl(agrChngAccessory, AgrChngAccessoryBo.class));
        }
        return rspBO;
    }

    private void validationParam(AgrGetAgrChngApplyDetailReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAgrId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61[\u534f\u8baeID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61[\u534f\u8bae\u53d8\u66f4\u7533\u8bf7ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

