/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrAgrAddChngAuditCallBackService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAddChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAddChngAuditCallBackRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrAgrAddChngAuditCallBackService"})
public class AgrAgrAddChngAuditCallBackServiceImpl
implements AgrAgrAddChngAuditCallBackService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"dealAddChngAuditCallBack"})
    public AgrAgrAddChngAuditCallBackRspBO dealAddChngAuditCallBack(@RequestBody AgrAgrAddChngAuditCallBackReqBO reqBO) {
        this.invokeUpdateAgrChngApplyMain(reqBO);
        this.syncAgrItem(reqBO);
        return AgrRu.success(AgrAgrAddChngAuditCallBackRspBO.class);
    }

    private void syncAgrItem(AgrAgrAddChngAuditCallBackReqBO reqBO) {
        AgrItemChngListQryReqPageBo reqPageBo = new AgrItemChngListQryReqPageBo();
        reqPageBo.setAgrId(reqBO.getAgrId());
        reqPageBo.setChngApplyId(reqBO.getChngApplyId());
        reqPageBo.setPageNo(1);
        reqPageBo.setPageSize(1000);
        AgrItemChngListQryRspPageBo rspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
        if (rspPageBo.getTotal() > 0) {
            int total = rspPageBo.getTotal();
            for (int i = 1; i <= total; ++i) {
                reqPageBo.setPageNo(i);
                reqPageBo.setPageSize(1000);
                AgrItemChngListQryRspPageBo rspPageBo1 = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
                ArrayList<AgrItemChng> addAgrItemChngs = new ArrayList<AgrItemChng>();
                ArrayList<AgrItemChng> deleteAgrItemChngs = new ArrayList<AgrItemChng>();
                rspPageBo1.getRows().forEach(agrItemChng -> {
                    if (agrItemChng.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.ADD)) {
                        addAgrItemChngs.add((AgrItemChng)agrItemChng);
                    }
                    if (agrItemChng.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.DELETE)) {
                        deleteAgrItemChngs.add((AgrItemChng)agrItemChng);
                    }
                });
                this.insertAgrItem(addAgrItemChngs, reqBO.getAgrId());
                this.deleteAgrItem(deleteAgrItemChngs, reqBO.getAgrId());
            }
        }
    }

    private void insertAgrItem(List<AgrItemChng> agrItemChngs, Long agrId) {
        if (!CollectionUtils.isEmpty(agrItemChngs)) {
            AgrAgrDo agrAgrDo = new AgrAgrDo();
            agrAgrDo.setAgrId(agrId);
            List agrItem = JSON.parseArray((String)JSON.toJSONString(agrItemChngs), AgrItem.class);
            agrAgrDo.setAgrItem(agrItem);
            this.iAgrAgrModel.saveAgrItem(agrAgrDo);
        }
    }

    private void deleteAgrItem(List<AgrItemChng> agrItemChngs, Long agrId) {
        if (!CollectionUtils.isEmpty(agrItemChngs)) {
            AgrAgrDo agrAgrDo = new AgrAgrDo();
            agrAgrDo.setAgrId(agrId);
            ArrayList<AgrItem> agrItems = new ArrayList<AgrItem>();
            ArrayList<Long> agrItemIds = new ArrayList<Long>();
            agrItemChngs.forEach(agrItemChng -> agrItemIds.add(agrItemChng.getAgrItemId()));
            AgrItem agrItem = new AgrItem();
            agrItem.setAgrId(agrId);
            agrItem.setAgrItemIds(agrItemIds);
            agrItems.add(agrItem);
            agrAgrDo.setAgrItem(agrItems);
            this.iAgrAgrModel.deleteAgrItemByBatch(agrAgrDo);
        }
    }

    private void invokeUpdateAgrChngApplyMain(AgrAgrAddChngAuditCallBackReqBO reqBO) {
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }
}

