/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.procinst;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListReqBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListRspBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAgrVersion;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.IAgrAuditOrderModel;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskDeal;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.procinst.AgrTaskDealService;
import com.tydic.dyc.agr.service.procinst.bo.AgrCandidatesBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskDealRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrTaskInfoBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.procinst.AgrTaskDealService"})
public class AgrTaskDealServiceImpl
implements AgrTaskDealService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrAuditOrderModel iAgrAuditOrderModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;

    @PostMapping(value={"dealTask"})
    public AgrTaskDealRspBO dealTask(@RequestBody AgrTaskDealReqBO reqBO) {
        AgrTaskDealRspBO rspBO = new AgrTaskDealRspBO();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNextTaskInfos())) {
            uocOrderTaskInst = this.dealToDo(reqBO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCompleteTaskInfos())) {
            uocOrderTaskInst = this.dealDone(reqBO);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getPreTaskId())) {
            uocOrderTaskInst = this.dealPreTask(reqBO.getPreTaskId(), reqBO.getOrderId());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getReturnTaskId())) {
            uocOrderTaskInst = this.dealReturnTask(reqBO.getPreTaskId(), reqBO.getOrderId());
        }
        if (reqBO.getUpdateTaskCandidate() != null && StringUtils.hasText((String)reqBO.getUpdateTaskCandidate().getTaskId())) {
            uocOrderTaskInst = this.dealTaskDealUpdate(reqBO.getUpdateTaskCandidate(), reqBO.getOrderId());
        }
        this.dealRsp(rspBO, uocOrderTaskInst);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4efb\u52a1\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void dealRsp(AgrTaskDealRspBO rspBO, UocOrderTaskInst uocOrderTaskInst) {
        if (uocOrderTaskInst != null) {
            String pickerConfigNo = uocOrderTaskInst.getObjType().toString();
            rspBO.setMainObjId(uocOrderTaskInst.getObjId() + "");
            if (uocOrderTaskInst.getObjType().equals(AgrCommConstant.ObjType.APPROVE)) {
                AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
                agrAuditOrderQryBo.setAuditOrderId(uocOrderTaskInst.getObjId());
                AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
                pickerConfigNo = agrAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
                rspBO.setMainObjId(agrAuditOrderDo.getUocApprovalObj().get(0).getObjId());
            }
            rspBO.setPickerConfigNo(pickerConfigNo + "_" + uocOrderTaskInst.getObjType());
            rspBO.setObjId(uocOrderTaskInst.getObjId());
            rspBO.setOrderId(uocOrderTaskInst.getOrderId());
        }
    }

    private UocOrderTaskInst dealReturnTask(String taskId, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(taskId, orderId);
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setTaskInstId(taskId);
        agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        agrTaskQryBo.setOrderId(orderId);
        agrTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
        this.deleteTask(agrTaskQryBo);
        return uocOrderTaskInst;
    }

    private UocOrderTaskInst dealPreTask(String taskId, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(taskId, orderId);
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setOrderId(orderId);
        agrTaskQryBo.setTaskInstId(taskId);
        agrTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
        agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        this.deleteTask(agrTaskQryBo);
        return uocOrderTaskInst;
    }

    private UocOrderTaskInst dealTaskDealUpdate(AgrTaskInfoBO completeTaskBo, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = this.checkTaskIsToDo(completeTaskBo.getTaskId(), orderId);
        ArrayList<UocOrderTaskDeal> agrUocOrderTaskDeal = new ArrayList<UocOrderTaskDeal>();
        UocOrderTaskDeal uocOrderTaskDeal = new UocOrderTaskDeal();
        uocOrderTaskDeal.setOrderId(orderId);
        uocOrderTaskDeal.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        uocOrderTaskDeal.setObjId(uocOrderTaskInst.getObjId());
        uocOrderTaskDeal.setObjType(uocOrderTaskInst.getObjType());
        AgrCandidatesBO uecCandidatesBO = (AgrCandidatesBO)completeTaskBo.getCandidates().get(0);
        uocOrderTaskDeal.setDealId(uecCandidatesBO.getCandidateId());
        uocOrderTaskDeal.setDealName(uecCandidatesBO.getCandidateName());
        agrUocOrderTaskDeal.add(uocOrderTaskDeal);
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setAgrUocOrderTaskDeal(agrUocOrderTaskDeal);
        this.iAgrProcInstModel.updateTaskDeal(agrProcInstDo);
        AgrProcInstDo agrProcInstDo1 = new AgrProcInstDo();
        ArrayList<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst1 = new UocOrderTaskInst();
        uocOrderTaskInst1.setObjId(uocOrderTaskInst.getObjId());
        uocOrderTaskInst1.setOrderId(uocOrderTaskInst.getOrderId());
        uocOrderTaskInst1.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        String remarkOld = uocOrderTaskInst.getRemark();
        String objBusiType = remarkOld.split("_")[1];
        String remarkNew = uecCandidatesBO.getCandidateId() + "_" + objBusiType;
        uocOrderTaskInst1.setRemark(remarkNew);
        agrUocOrderTaskInst.add(uocOrderTaskInst1);
        agrProcInstDo1.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
        this.iAgrProcInstModel.updateTask(agrProcInstDo1);
        return uocOrderTaskInst;
    }

    private UocOrderTaskInst checkTaskIsToDo(String taskId, Long orderId) {
        AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
        agrTaskQryBo.setOrderId(orderId);
        agrTaskQryBo.setTaskInstId(taskId);
        AgrProcInstDo agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
        if (agrProcInstDo == null || CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())) {
            throw new BaseBusinessException("8888", "\u4efb\u52a1\u5b9e\u4f8bid(" + taskId + ")\u4e0d\u5b58\u5728");
        }
        if (AgrCommConstant.PROC_TASK_FINISHED.FINISHED.equals(agrProcInstDo.getAgrUocOrderTaskInst().get(0).getFinishTag())) {
            throw new BaseBusinessException("8888", "\u4efb\u52a1\u5b9e\u4f8bid(" + taskId + ")\u5df2\u5b8c\u7ed3");
        }
        return agrProcInstDo.getAgrUocOrderTaskInst().get(0);
    }

    private void updateTaskDone(AgrTaskInfoBO completeTaskBo, AgrTaskDealReqBO reqBO) {
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        ArrayList<UocOrderTaskInst> agrUocOrderTaskInsts = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        uocOrderTaskInst.setDealOperId(reqBO.getUserId());
        uocOrderTaskInst.setDealOperName(reqBO.getUsername());
        uocOrderTaskInst.setDealResult(completeTaskBo.getDealResult());
        uocOrderTaskInst.setDealRemark(completeTaskBo.getDealRemark());
        uocOrderTaskInst.setOrderId(reqBO.getOrderId());
        uocOrderTaskInst.setTaskInstId(completeTaskBo.getTaskId());
        uocOrderTaskInst.setObjId(completeTaskBo.getBusiObjId());
        uocOrderTaskInst.setObjType(completeTaskBo.getBusiObjType());
        if (uocOrderTaskInst.getObjType().equals(AgrCommConstant.ObjType.APPROVE)) {
            AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
            agrAuditOrderQryBo.setAuditOrderId(uocOrderTaskInst.getObjId());
            AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
            String objBusiType = agrAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
            String remark = reqBO.getUserId() + "_" + objBusiType + "_" + completeTaskBo.getDealResult();
            uocOrderTaskInst.setRemark(remark);
        }
        agrUocOrderTaskInsts.add(uocOrderTaskInst);
        agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInsts);
        this.iAgrProcInstModel.updateTask(agrProcInstDo);
    }

    private UocOrderTaskInst dealDone(AgrTaskDealReqBO reqBO) {
        UocOrderTaskInst uocOrderTaskInst = null;
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCompleteTaskInfos())) {
            for (AgrTaskInfoBO completeTaskBo : reqBO.getCompleteTaskInfos()) {
                uocOrderTaskInst = this.checkTaskIsToDo(completeTaskBo.getTaskId(), reqBO.getOrderId());
                completeTaskBo.setBusiObjType(uocOrderTaskInst.getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInst.getObjId());
                this.updateTaskDone(completeTaskBo, reqBO);
                if (completeTaskBo.getAuditStepFinish() == null || !completeTaskBo.getAuditStepFinish().booleanValue()) continue;
                AgrTaskQryBo agrTaskQryBo = new AgrTaskQryBo();
                agrTaskQryBo.setOrderId(reqBO.getOrderId());
                agrTaskQryBo.setProcState(uocOrderTaskInst.getProcState());
                agrTaskQryBo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
                agrTaskQryBo.setObjId(uocOrderTaskInst.getObjId());
                this.deleteTask(agrTaskQryBo);
            }
        }
        return uocOrderTaskInst;
    }

    private void deleteTask(AgrTaskQryBo agrTaskQryBo) {
        AgrProcInstDo agrProcInstDo = this.iAgrProcInstModel.getTaskList(agrTaskQryBo);
        if (!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())) {
            ArrayList<String> taskInstIds = new ArrayList<String>();
            agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> taskInstIds.add(uocOrderTaskInst.getTaskInstId()));
            AgrProcInstDo agrProcInstDo1 = new AgrProcInstDo();
            ArrayList<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<UocOrderTaskInst>();
            UocOrderTaskInst uocOrderTaskInst2 = new UocOrderTaskInst();
            uocOrderTaskInst2.setObjId(agrTaskQryBo.getObjId());
            uocOrderTaskInst2.setOrderId(agrTaskQryBo.getOrderId());
            uocOrderTaskInst2.setTaskInstIds(taskInstIds);
            agrUocOrderTaskInst.add(uocOrderTaskInst2);
            agrProcInstDo1.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
            this.iAgrProcInstModel.deleteTask(agrProcInstDo1);
        }
    }

    private void dealProInst(AgrTaskInfoBO agrTaskInfoBO, Long orderId) {
        AgrProcInstDo agrProcInstDoReq = new AgrProcInstDo();
        agrProcInstDoReq.setProcInstId(agrTaskInfoBO.getProcInstId());
        AgrProcInstDo agrProcInstDoRsp = this.iAgrProcInstModel.getProcInst(agrProcInstDoReq);
        if (agrProcInstDoRsp == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)agrProcInstDoRsp.getProcInstId())) {
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setProcInstId(agrTaskInfoBO.getProcInstId());
            agrProcInstDo.setObjId(agrTaskInfoBO.getBusiObjId());
            agrProcInstDo.setObjType(agrTaskInfoBO.getBusiObjType());
            agrProcInstDo.setOrderId(orderId);
            agrProcInstDo.setProcDefId(agrTaskInfoBO.getProcDefId());
            this.iAgrProcInstModel.saveProcInst(agrProcInstDo);
        }
    }

    private UocOrderTaskInst dealTask(AgrTaskInfoBO nextTaskInfo, Long orderId) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(orderId);
        uocOrderTaskInst.setTaskInstId(nextTaskInfo.getTaskId());
        uocOrderTaskInst.setObjId(nextTaskInfo.getBusiObjId());
        uocOrderTaskInst.setObjType(nextTaskInfo.getBusiObjType());
        uocOrderTaskInst.setProcState(nextTaskInfo.getStepId());
        uocOrderTaskInst.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        uocOrderTaskInst.setFormUrl(nextTaskInfo.getFormUrl());
        uocOrderTaskInst.setProcDefId(nextTaskInfo.getProcDefId());
        uocOrderTaskInst.setProcInstId(nextTaskInfo.getProcInstId());
        uocOrderTaskInst.setTaskSignTag(nextTaskInfo.getTaskSignTag());
        uocOrderTaskInst.setDealResult(AgrCommConstant.TASK_DEAL_RESULT.APPROVING);
        if (uocOrderTaskInst.getTaskSignTag() == null) {
            uocOrderTaskInst.setTaskSignTag(AgrCommConstant.TASK_SING_TAG.TACHE_TASK);
        }
        if (nextTaskInfo.getBusiObjType().equals(AgrCommConstant.ObjType.APPROVE)) {
            AgrAuditOrderQryBo agrAuditOrderQryBo = new AgrAuditOrderQryBo();
            agrAuditOrderQryBo.setAuditOrderId(nextTaskInfo.getBusiObjId());
            AgrAuditOrderDo agrAuditOrderDo = this.iAgrAuditOrderModel.getAuditObj(agrAuditOrderQryBo);
            String objBusiType = agrAuditOrderDo.getUocApprovalObj().get(0).getObjType().toString();
            if (!CollectionUtils.isEmpty((Collection)nextTaskInfo.getCandidates())) {
                String remark = ((AgrCandidatesBO)nextTaskInfo.getCandidates().get(0)).getCandidateId();
                if (objBusiType != null) {
                    remark = remark + "_" + objBusiType;
                }
                uocOrderTaskInst.setRemark(remark);
            }
        }
        return uocOrderTaskInst;
    }

    private List<UocOrderTaskDeal> dealTaskDeal(AgrTaskInfoBO nextTaskInfo, Long orderId) {
        ArrayList<UocOrderTaskDeal> uocOrderTaskDeals = new ArrayList<UocOrderTaskDeal>();
        if (!CollectionUtils.isEmpty((Collection)nextTaskInfo.getCandidates())) {
            nextTaskInfo.getCandidates().forEach(agrCandidatesBO -> {
                UocOrderTaskDeal deal = new UocOrderTaskDeal();
                deal.setTaskInstId(nextTaskInfo.getTaskId());
                deal.setOrderId(orderId);
                deal.setObjId(nextTaskInfo.getBusiObjId());
                deal.setObjType(nextTaskInfo.getBusiObjType());
                deal.setDealId(agrCandidatesBO.getCandidateId());
                deal.setDealName(agrCandidatesBO.getCandidateName());
                deal.setDealClass("2");
                uocOrderTaskDeals.add(deal);
            });
        }
        return uocOrderTaskDeals;
    }

    private UocOrderTaskInst dealToDo(AgrTaskDealReqBO reqBO) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNextTaskInfos())) {
            ArrayList<UocOrderTaskInst> agrUocOrderTaskInst = new ArrayList<UocOrderTaskInst>();
            ArrayList<UocOrderTaskDeal> agrUocOrderTaskDeal = new ArrayList<UocOrderTaskDeal>();
            reqBO.getNextTaskInfos().forEach(agrTaskInfoBO -> {
                this.dealProInst((AgrTaskInfoBO)agrTaskInfoBO, reqBO.getOrderId());
                agrUocOrderTaskInst.add(this.dealTask((AgrTaskInfoBO)agrTaskInfoBO, reqBO.getOrderId()));
                agrUocOrderTaskDeal.addAll(this.dealTaskDeal((AgrTaskInfoBO)agrTaskInfoBO, reqBO.getOrderId()));
                this.updateStatus((AgrTaskInfoBO)agrTaskInfoBO, reqBO.getOrderId());
            });
            AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
            agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInst);
            agrProcInstDo.setAgrUocOrderTaskDeal(agrUocOrderTaskDeal);
            this.iAgrProcInstModel.saveTask(agrProcInstDo);
            uocOrderTaskInst = (UocOrderTaskInst)agrUocOrderTaskInst.get(0);
        }
        return uocOrderTaskInst;
    }

    private void updateStatus(AgrTaskInfoBO agrTaskInfoBO, Long orderId) {
        if (agrTaskInfoBO.getBusiObjType().equals(AgrCommConstant.ObjType.AGREEMENT)) {
            AgrAgrDo agrAgrDo = new AgrAgrDo();
            agrAgrDo.setAgrId(agrTaskInfoBO.getBusiObjId());
            if (agrTaskInfoBO.getStepId().equals("AGR0001")) {
                agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.TO_CONFIRM);
            } else if (agrTaskInfoBO.getStepId().equals("AGR0002")) {
                agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.IN_AUDIT);
            } else if (agrTaskInfoBO.getStepId().equals("AGR0003")) {
                AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
                agrAgrQryBo.setAgrId(orderId);
                AgrAgrDo agrAgrDo1 = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
                if (agrAgrDo1.getAgrStatus().equals(AgrCommConstant.AgreementStatus.TO_CONFIRM)) {
                    agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.NO_CONFIRM);
                } else {
                    agrAgrDo.setAgrStatus(AgrCommConstant.AgreementStatus.REJECT);
                }
            }
            if (agrAgrDo.getAgrStatus() != null) {
                this.iAgrAgrModel.updateAgrMain(agrAgrDo);
            }
        }
        if (agrTaskInfoBO.getBusiObjType().equals(AgrCommConstant.ObjType.CHANGE)) {
            AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
            agrAgrChngApplyQryBo.setAgrId(orderId);
            agrAgrChngApplyQryBo.setChngApplyId(agrTaskInfoBO.getBusiObjId());
            AgrChngApplyDo agrChngApplyDoDetail = this.iAgrChngApplyModel.getAgrChngApplyDetail(agrAgrChngApplyQryBo);
            AgrChngApplyDo agrChngApplyDoUpdate = new AgrChngApplyDo();
            agrChngApplyDoUpdate.setAgrId(orderId);
            agrChngApplyDoUpdate.setChngApplyId(agrTaskInfoBO.getBusiObjId());
            if (agrTaskInfoBO.getStepId().equals("AGR0001")) {
                agrChngApplyDoUpdate.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.TO_CONFIRM);
            } else if (agrTaskInfoBO.getStepId().equals("AGR0002")) {
                agrChngApplyDoUpdate.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.IN_AUDIT);
            } else if (agrTaskInfoBO.getStepId().equals("AGR0003")) {
                if (agrChngApplyDoDetail.getChngApplyStatus().equals(AgrCommConstant.ChangeApplyStatus.TO_CONFIRM)) {
                    agrChngApplyDoUpdate.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.NO_CONFIRM);
                } else {
                    agrChngApplyDoUpdate.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.NO_PASS);
                }
            }
            if (agrChngApplyDoUpdate.getChngApplyStatus() != null) {
                this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDoUpdate);
            }
            this.saveAgrVersion(agrChngApplyDoDetail);
        }
    }

    private void saveAgrVersion(AgrChngApplyDo agrChngApplyDoDetail) {
        if (!(agrChngApplyDoDetail.getChngType().equals(AgrCommConstant.AgreementChangeType.STOP) || agrChngApplyDoDetail.getChngType().equals(AgrCommConstant.AgreementChangeType.START) || agrChngApplyDoDetail.getChngType().equals(AgrCommConstant.AgreementChangeType.TERMINATION))) {
            AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo = new AgrGetAgrVersionListReqBo();
            agrGetAgrVersionListReqBo.setAgrId(agrChngApplyDoDetail.getAgrId());
            agrGetAgrVersionListReqBo.setChngApplyId(agrChngApplyDoDetail.getChngApplyId());
            AgrGetAgrVersionListRspBo agrGetAgrVersionListRspBo = this.iAgrAgrModel.getAgrVersionList(agrGetAgrVersionListReqBo);
            if (CollectionUtils.isEmpty(agrGetAgrVersionListRspBo.getRows())) {
                AgrAgrDo agrAgrDo = new AgrAgrDo();
                ArrayList<AgrAgrVersion> agrAgrVersions = new ArrayList<AgrAgrVersion>();
                AgrAgrVersion AgrAgrVersion2 = new AgrAgrVersion();
                AgrAgrVersion2.setAgrId(agrChngApplyDoDetail.getAgrId());
                AgrAgrVersion2.setAgrCode(agrChngApplyDoDetail.getAgrCode());
                AgrAgrVersion2.setCreateTime(new Date());
                AgrAgrVersion2.setChngType(agrChngApplyDoDetail.getChngType());
                AgrAgrVersion2.setVersionStatus(AgrCommConstant.AgrVersionStatus.TO_VALID);
                AgrAgrVersion2.setChngApplyCreateTime(agrChngApplyDoDetail.getCreateTime());
                AgrAgrVersion2.setChngApplyNo(agrChngApplyDoDetail.getChngApplyNo());
                AgrAgrVersion2.setChngApplyId(agrChngApplyDoDetail.getChngApplyId());
                agrAgrVersions.add(AgrAgrVersion2);
                agrAgrDo.setAgrAgrVersion(agrAgrVersions);
                agrAgrDo.setAgrId(agrChngApplyDoDetail.getAgrId());
                this.iAgrAgrModel.saveAgrVersion(agrAgrDo);
            }
        }
    }
}

