/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.service.agr.AgrCheckAgrAppScopeService;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckAgrAppScopeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckAgrAppScopeRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCheckScopeBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrCheckAgrAppScopeService"})
public class AgrCheckAgrAppScopeServiceImpl
implements AgrCheckAgrAppScopeService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"checkAgrAppScope"})
    public AgrCheckAgrAppScopeRspBO checkAgrAppScope(@RequestBody AgrCheckAgrAppScopeReqBO reqBO) {
        this.validParam(reqBO);
        ArrayList agrCheckScopeBOS = new ArrayList();
        Map<Object, Object> agrMap = new HashMap();
        AgrAgrQryBo qryAgrMainList = new AgrAgrQryBo();
        qryAgrMainList.setAgrIds(reqBO.getAgrIds());
        qryAgrMainList.setPageNo(-1);
        qryAgrMainList.setPageSize(-1);
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = this.iAgrAgrModel.getAgrMainList(qryAgrMainList);
        if (!CollectionUtils.isEmpty(agrGetAgrMainListRspQryBo.getRows())) {
            agrMap = agrGetAgrMainListRspQryBo.getRows().stream().collect(Collectors.toMap(AgrAgrDo::getAgrId, AgrAgrDo::getAgrName));
        }
        List<Object> otherAgrIds = new ArrayList();
        List<Object> lastAgrIds = new ArrayList();
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrIds(reqBO.getAgrIds());
        agrAgrQryBo.setScopeType(AgrCommConstant.ScopeType.ALL);
        List<AgrAppScope> agrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
        if (!CollectionUtils.isEmpty(agrAppScopes)) {
            agrAppScopes.forEach(bo -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(bo.getAgrId());
                agrCheckScopeBO.setCheckFlag(Boolean.valueOf(true));
                agrCheckScopeBOS.add(agrCheckScopeBO);
            });
            otherAgrIds = reqBO.getAgrIds().stream().filter(agrId -> agrAppScopes.stream().noneMatch(a -> a.getAgrId().equals(agrId))).collect(Collectors.toList());
        } else {
            otherAgrIds = reqBO.getAgrIds();
        }
        if (!CollectionUtils.isEmpty(otherAgrIds)) {
            agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrIds(otherAgrIds);
            agrAgrQryBo.setScopeCode(reqBO.getScopeId().toString());
            List<AgrAppScope> otherAgrAppScopes = this.iAgrAgrModel.getAgrAppScopeList(agrAgrQryBo);
            if (!CollectionUtils.isEmpty((Collection)otherAgrAppScopes)) {
                otherAgrAppScopes.forEach(bo -> {
                    AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                    agrCheckScopeBO.setAgrId(bo.getAgrId());
                    agrCheckScopeBO.setCheckFlag(Boolean.valueOf(true));
                    agrCheckScopeBOS.add(agrCheckScopeBO);
                });
                lastAgrIds = otherAgrIds.stream().filter(agrId -> otherAgrAppScopes.stream().noneMatch(a -> a.getAgrId().equals(agrId))).collect(Collectors.toList());
            } else {
                lastAgrIds = otherAgrIds;
            }
        }
        if (!CollectionUtils.isEmpty(lastAgrIds)) {
            lastAgrIds.forEach(agrId -> {
                AgrCheckScopeBO agrCheckScopeBO = new AgrCheckScopeBO();
                agrCheckScopeBO.setAgrId(agrId);
                agrCheckScopeBO.setCheckFlag(Boolean.valueOf(false));
                agrCheckScopeBOS.add(agrCheckScopeBO);
            });
        }
        for (AgrCheckScopeBO bo2 : agrCheckScopeBOS) {
            if (agrMap == null || !agrMap.containsKey(bo2.getAgrId())) continue;
            bo2.setAgrName((String)agrMap.get(bo2.getAgrId()));
        }
        AgrCheckAgrAppScopeRspBO rspBO = new AgrCheckAgrAppScopeRspBO();
        rspBO.setRows(agrCheckScopeBOS);
        return rspBO;
    }

    private void validParam(AgrCheckAgrAppScopeReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("22000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAgrIds())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u534f\u8baeID\u96c6\u5408\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getScopeId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u8303\u56f4ID\u4e3a\u7a7a\uff01");
        }
    }
}

