/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryReqPageBo;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrItemChngListQryRspPageBo;
import com.tydic.dyc.agr.model.agrchange.sub.AgrItemChng;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrAgrAdjustChngAuditCallBackService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAdjustChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAdjustChngAuditCallBackRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrAgrAdjustChngAuditCallBackService"})
public class AgrAgrAdjustChngAuditCallBackServiceImpl
implements AgrAgrAdjustChngAuditCallBackService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"dealAdjustChngAuditCallBack"})
    public AgrAgrAdjustChngAuditCallBackRspBO dealAdjustChngAuditCallBack(@RequestBody AgrAgrAdjustChngAuditCallBackReqBO reqBO) {
        this.invokeUpdateAgrChngApplyMain(reqBO);
        this.syncAgrItem(reqBO);
        return AgrRu.success(AgrAgrAdjustChngAuditCallBackRspBO.class);
    }

    private void syncAgrItem(AgrAgrAdjustChngAuditCallBackReqBO reqBO) {
        AgrItemChngListQryReqPageBo reqPageBo = new AgrItemChngListQryReqPageBo();
        reqPageBo.setAgrId(reqBO.getAgrId());
        reqPageBo.setChngApplyId(reqBO.getChngApplyId());
        reqPageBo.setPageNo(1);
        reqPageBo.setPageSize(1000);
        reqPageBo.setItemChngType(AgrCommConstant.AgreementSkuChangeType.UPDATE);
        AgrItemChngListQryRspPageBo rspPageBo = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
        if (rspPageBo.getTotal() > 0) {
            int total = rspPageBo.getTotal();
            for (int i = 1; i <= total; ++i) {
                reqPageBo.setPageNo(i);
                reqPageBo.setPageSize(1000);
                AgrItemChngListQryRspPageBo rspPageBo1 = this.iAgrChngApplyModel.getAgrItemChngList(reqPageBo);
                ArrayList<AgrItemChng> updateAgrItemChngs = new ArrayList<AgrItemChng>();
                rspPageBo1.getRows().forEach(agrItemChng -> {
                    if (agrItemChng.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.UPDATE)) {
                        updateAgrItemChngs.add((AgrItemChng)agrItemChng);
                    }
                });
                this.updateAgrItem(updateAgrItemChngs, reqBO.getAgrId());
            }
        }
    }

    private void updateAgrItem(List<AgrItemChng> agrItemChngs, Long agrId) {
        if (!CollectionUtils.isEmpty(agrItemChngs)) {
            agrItemChngs.forEach(agrItemChng -> {
                ArrayList<AgrItem> agrItems = new ArrayList<AgrItem>();
                AgrItem agrItem = new AgrItem();
                agrItem.setAgrItemId(agrItemChng.getAgrItemId());
                agrItem.setBuyPrice(agrItemChng.getBuyPrice());
                agrItem.setBuyNumber(agrItemChng.getBuyNumber());
                agrItem.setBuyPriceSum(agrItemChng.getBuyPriceSum());
                agrItem.setSalePrice(agrItemChng.getSalePrice());
                agrItem.setSalePriceSum(agrItemChng.getSalePriceSum());
                agrItem.setMarkupRate(agrItemChng.getMarkupRate());
                agrItems.add(agrItem);
                AgrAgrDo agrAgrDo = new AgrAgrDo();
                agrAgrDo.setAgrId(agrId);
                agrAgrDo.setAgrItem(agrItems);
                this.iAgrAgrModel.updateAgrItemByBatch(agrAgrDo);
            });
        }
    }

    private void invokeUpdateAgrChngApplyMain(AgrAgrAdjustChngAuditCallBackReqBO reqBO) {
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }
}

