/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.procinst;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderProcInst;
import com.tydic.dyc.agr.service.procinst.AgrUpdateProcInstService;
import com.tydic.dyc.agr.service.procinst.bo.AgrUpdateProcInstReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUpdateProcInstRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.procinst.AgrUpdateProcInstService"})
public class AgrUpdateProcInstServiceImpl
implements AgrUpdateProcInstService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @PostMapping(value={"updateProcInst"})
    public AgrUpdateProcInstRspBO updateProcInst(@RequestBody AgrUpdateProcInstReqBO reqBO) {
        this.check(reqBO);
        AgrUpdateProcInstRspBO rspBO = AgrRu.success(AgrUpdateProcInstRspBO.class);
        List<UocOrderProcInst> uocOrderProcInstList = reqBO.getProcInstIdList().stream().map(e -> {
            UocOrderProcInst uocOrderProcInst = new UocOrderProcInst();
            uocOrderProcInst.setProcInstId((String)e);
            return uocOrderProcInst;
        }).collect(Collectors.toList());
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        agrProcInstDo.setFinishTag(reqBO.getFinishTag());
        agrProcInstDo.setAgrUocOrderProcInst(uocOrderProcInstList);
        this.iAgrProcInstModel.updateProcInst(agrProcInstDo);
        return rspBO;
    }

    private void check(AgrUpdateProcInstReqBO reqBO) {
        if (CollectionUtil.isEmpty((Collection)reqBO.getProcInstIdList())) {
            throw new BaseBusinessException("", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6d41\u7a0b\u5b9e\u4f8bID\u96c6\u5408]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getFinishTag())) {
            throw new BaseBusinessException("", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[finishTag]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

