/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrAllocateRecordListRspBO;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAllAgrListRspBO;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAccessory;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrAllocateRecord;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrCataScope;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agr.sub.AgrItemExt;
import com.tydic.dyc.agr.model.agr.sub.AgrItemLadderPrice;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agr.sub.AgrRel;
import com.tydic.dyc.agr.repository.AgrAgrRepository;
import com.tydic.dyc.agr.repository.dao.AgrAccessoryMapper;
import com.tydic.dyc.agr.repository.dao.AgrAdjustCfgMapper;
import com.tydic.dyc.agr.repository.dao.AgrAllocateRecordMapper;
import com.tydic.dyc.agr.repository.dao.AgrAppScopeMapper;
import com.tydic.dyc.agr.repository.dao.AgrCataScopeMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemExtMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemLadderPriceMapper;
import com.tydic.dyc.agr.repository.dao.AgrItemMapper;
import com.tydic.dyc.agr.repository.dao.AgrMainExtMapper;
import com.tydic.dyc.agr.repository.dao.AgrMainMapper;
import com.tydic.dyc.agr.repository.dao.AgrPayConfigMapper;
import com.tydic.dyc.agr.repository.dao.AgrRelMapper;
import com.tydic.dyc.agr.repository.po.AgrAccessoryPO;
import com.tydic.dyc.agr.repository.po.AgrAdjustCfgPO;
import com.tydic.dyc.agr.repository.po.AgrAllocateRecordPO;
import com.tydic.dyc.agr.repository.po.AgrAppScopePO;
import com.tydic.dyc.agr.repository.po.AgrCataScopePO;
import com.tydic.dyc.agr.repository.po.AgrItemExtPO;
import com.tydic.dyc.agr.repository.po.AgrItemLadderPricePO;
import com.tydic.dyc.agr.repository.po.AgrItemPO;
import com.tydic.dyc.agr.repository.po.AgrMainExtPO;
import com.tydic.dyc.agr.repository.po.AgrMainPO;
import com.tydic.dyc.agr.repository.po.AgrPayConfigPO;
import com.tydic.dyc.agr.repository.po.AgrRelPO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrAgrRepositoryImpl
implements AgrAgrRepository {
    private static final Logger log = LoggerFactory.getLogger(AgrAgrRepositoryImpl.class);
    @Autowired
    private AgrMainMapper agrMainMapper;
    @Autowired
    private AgrItemMapper agrItemMapper;
    @Autowired
    private AgrAppScopeMapper agrAppScopeMapper;
    @Autowired
    private AgrPayConfigMapper agrPayConfigMapper;
    @Autowired
    private AgrAdjustCfgMapper agrAdjustCfgMapper;
    @Autowired
    private AgrCataScopeMapper agrCataScopeMapper;
    @Autowired
    private AgrRelMapper agrRelMapper;
    @Autowired
    private AgrMainExtMapper agrMainExtMapper;
    @Autowired
    private AgrAccessoryMapper agrAccessoryMapper;
    @Autowired
    private AgrItemLadderPriceMapper agrItemLadderPriceMapper;
    @Autowired
    private AgrItemExtMapper agrItemExtMapper;
    @Autowired
    private AgrAllocateRecordMapper agrAllocateRecordMapper;

    public void saveAgrSub(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrAppScope())) {
            ArrayList<AgrAppScopePO> agrAppScopePOs = new ArrayList<AgrAppScopePO>();
            agrAgrDo.getAgrAppScope().forEach(agrAppScope -> {
                AgrAppScopePO po = (AgrAppScopePO)AgrRu.js((Object)agrAppScope, AgrAppScopePO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setAppScopeId(IdUtil.nextId());
                po.setScopeType(agrAgrDo.getScopeType());
                agrAppScopePOs.add(po);
            });
            this.agrAppScopeMapper.insertBatch(agrAppScopePOs);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrPayConfig())) {
            ArrayList<AgrPayConfigPO> agrPayConfigPOs = new ArrayList<AgrPayConfigPO>();
            agrAgrDo.getAgrPayConfig().forEach(agrPayConfig -> {
                AgrPayConfigPO po = (AgrPayConfigPO)AgrRu.js((Object)agrPayConfig, AgrPayConfigPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setPayCfgId(IdUtil.nextId());
                agrPayConfigPOs.add(po);
            });
            this.agrPayConfigMapper.insertBatch(agrPayConfigPOs);
        }
        if (agrAgrDo.getAgrAdjustCfg() != null) {
            AgrAdjustCfgPO agrAdjustCfgPO = (AgrAdjustCfgPO)AgrRu.js((Object)agrAgrDo.getAgrAdjustCfg(), AgrAdjustCfgPO.class);
            agrAdjustCfgPO.setAgrId(agrAgrDo.getAgrId());
            agrAdjustCfgPO.setAdjustCfgId(IdUtil.nextId());
            this.agrAdjustCfgMapper.insert(agrAdjustCfgPO);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrCataScope())) {
            ArrayList<AgrCataScopePO> agrCataScopePOs = new ArrayList<AgrCataScopePO>();
            agrAgrDo.getAgrCataScope().forEach(agrCataScope -> {
                AgrCataScopePO po = (AgrCataScopePO)AgrRu.js((Object)agrCataScope, AgrCataScopePO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setCataScopeId(IdUtil.nextId());
                agrCataScopePOs.add(po);
            });
            this.agrCataScopeMapper.insertBatch(agrCataScopePOs);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrRel())) {
            ArrayList<AgrRelPO> agrRelPOs = new ArrayList<AgrRelPO>();
            agrAgrDo.getAgrRel().forEach(agrRelPO -> {
                AgrRelPO po = (AgrRelPO)AgrRu.js((Object)agrRelPO, AgrRelPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setRelId(IdUtil.nextId());
                agrRelPOs.add(po);
            });
            this.agrRelMapper.insertBatch(agrRelPOs);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrMainExt())) {
            ArrayList<AgrMainExtPO> agrMainExtPOs = new ArrayList<AgrMainExtPO>();
            agrAgrDo.getAgrMainExt().forEach(agrMainExtPO -> {
                AgrMainExtPO po = (AgrMainExtPO)AgrRu.js((Object)agrMainExtPO, AgrMainExtPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setMainExtId(IdUtil.nextId());
                agrMainExtPOs.add(po);
            });
            this.agrMainExtMapper.insertBatch(agrMainExtPOs);
        }
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrAccessory())) {
            ArrayList<AgrAccessoryPO> agrAccessoryPOs = new ArrayList<AgrAccessoryPO>();
            agrAgrDo.getAgrAccessory().forEach(agrAccessoryPO -> {
                AgrAccessoryPO po = (AgrAccessoryPO)AgrRu.js((Object)agrAccessoryPO, AgrAccessoryPO.class);
                po.setOrderId(agrAgrDo.getAgrId());
                po.setObjId(agrAgrDo.getAgrId());
                po.setId(IdUtil.nextId());
                po.setObjType(AgrCommConstant.FileObjType.AGR);
                agrAccessoryPOs.add(po);
            });
            this.agrAccessoryMapper.insertBatch(agrAccessoryPOs);
        }
    }

    public void updateAgrMain(AgrAgrDo agrAgrDo) {
        AgrMainPO agrMainPOSet = (AgrMainPO)AgrRu.js((Object)agrAgrDo, AgrMainPO.class);
        agrMainPOSet.setUpdateLoginId(agrAgrDo.getUserId());
        agrMainPOSet.setUpdateName(agrAgrDo.getName());
        agrMainPOSet.setUpdateUsername(agrAgrDo.getUsername());
        agrMainPOSet.setUpdateTime(agrAgrDo.getOperTime());
        AgrMainPO agrMainPOWhere = new AgrMainPO();
        agrMainPOWhere.setAgrId(agrAgrDo.getAgrId());
        this.agrMainMapper.updateBy(agrMainPOSet, agrMainPOWhere);
    }

    public AgrAgrDo getAgrMain(AgrAgrQryBo param0) {
        AgrMainPO agrMain = new AgrMainPO();
        agrMain.setAgrId(param0.getAgrId());
        AgrMainPO agrMainPO = this.agrMainMapper.getModelBy(agrMain);
        return (AgrAgrDo)AgrRu.js((Object)agrMainPO, AgrAgrDo.class);
    }

    public void deleteAgrSub(AgrAgrDo param0) {
        AgrAdjustCfgPO agrAdjustCfgPO = new AgrAdjustCfgPO();
        agrAdjustCfgPO.setAgrId(param0.getAgrId());
        this.agrAdjustCfgMapper.deleteBy(agrAdjustCfgPO);
        AgrPayConfigPO agrPayConfigPODel = new AgrPayConfigPO();
        agrPayConfigPODel.setAgrId(param0.getAgrId());
        this.agrPayConfigMapper.deleteBy(agrPayConfigPODel);
        AgrAppScopePO agrAppScopePODel = new AgrAppScopePO();
        agrAppScopePODel.setAgrId(param0.getAgrId());
        this.agrAppScopeMapper.deleteBy(agrAppScopePODel);
        AgrCataScopePO agrCataScopePODel = new AgrCataScopePO();
        agrCataScopePODel.setAgrId(param0.getAgrId());
        this.agrCataScopeMapper.deleteBy(agrCataScopePODel);
        AgrMainExtPO agrMainExtPODel = new AgrMainExtPO();
        agrMainExtPODel.setAgrId(param0.getAgrId());
        this.agrMainExtMapper.deleteBy(agrMainExtPODel);
        AgrRelPO agrRelPODel = new AgrRelPO();
        agrRelPODel.setAgrId(param0.getAgrId());
        this.agrRelMapper.deleteBy(agrRelPODel);
        AgrAccessoryPO agrAccessoryPODel = new AgrAccessoryPO();
        agrAccessoryPODel.setObjId(param0.getAgrId());
        this.agrAccessoryMapper.deleteBy(agrAccessoryPODel);
    }

    public AgrAgrDo getAgrDetail(AgrAgrQryBo param0) {
        AgrMainPO modelBy = this.agrMainMapper.getModelBy((AgrMainPO)AgrRu.js((Object)param0, AgrMainPO.class));
        AgrAgrDo agrAgrDo = (AgrAgrDo)AgrRu.js((Object)modelBy, AgrAgrDo.class);
        AgrAppScopePO agrAppScopePO = new AgrAppScopePO();
        agrAppScopePO.setAgrId(param0.getAgrId());
        List<AgrAppScopePO> agrAppScopePOS = this.agrAppScopeMapper.getList(agrAppScopePO);
        agrAgrDo.setAgrAppScope(AgrRu.jsl(agrAppScopePOS, AgrAppScope.class));
        AgrPayConfigPO agrPayConfigPO = new AgrPayConfigPO();
        agrPayConfigPO.setAgrId(param0.getAgrId());
        List<AgrPayConfigPO> agrPayConfigPOS = this.agrPayConfigMapper.getList(agrPayConfigPO);
        agrAgrDo.setAgrPayConfig(AgrRu.jsl(agrPayConfigPOS, AgrPayConfig.class));
        AgrAdjustCfgPO adjustCfgPO = new AgrAdjustCfgPO();
        adjustCfgPO.setAgrId(param0.getAgrId());
        AgrAdjustCfgPO agrAdjustCfgPO = this.agrAdjustCfgMapper.getModelBy(adjustCfgPO);
        agrAgrDo.setAgrAdjustCfg((AgrAdjustCfg)AgrRu.js((Object)agrAdjustCfgPO, AgrAdjustCfg.class));
        AgrCataScopePO agrCataScopePO = new AgrCataScopePO();
        agrCataScopePO.setAgrId(param0.getAgrId());
        List<AgrCataScopePO> agrCataScopePOS = this.agrCataScopeMapper.getList(agrCataScopePO);
        agrAgrDo.setAgrCataScope(AgrRu.jsl(agrCataScopePOS, AgrCataScope.class));
        AgrRelPO agrRelPO = new AgrRelPO();
        agrRelPO.setAgrId(param0.getAgrId());
        List<AgrRelPO> agrRelPOS = this.agrRelMapper.getList(agrRelPO);
        agrAgrDo.setAgrRel(AgrRu.jsl(agrRelPOS, AgrRel.class));
        AgrMainExtPO agrMainExtPO = new AgrMainExtPO();
        agrMainExtPO.setAgrId(param0.getAgrId());
        List<AgrMainExtPO> agrMainExtPOS = this.agrMainExtMapper.getList(agrMainExtPO);
        agrAgrDo.setAgrMainExt(AgrRu.jsl(agrMainExtPOS, AgrMainExt.class));
        AgrAccessoryPO agrAccessoryPO = new AgrAccessoryPO();
        agrAccessoryPO.setObjId(param0.getAgrId());
        agrAccessoryPO.setOrderId(param0.getAgrId());
        agrAccessoryPO.setObjType(AgrCommConstant.AccessoryObjType.AGR_MAIN);
        List<AgrAccessoryPO> agrAccessoryPOS = this.agrAccessoryMapper.getList(agrAccessoryPO);
        agrAgrDo.setAgrAccessory(AgrRu.jsl(agrAccessoryPOS, AgrAccessory.class));
        return agrAgrDo;
    }

    public void saveAgrItem(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrItem())) {
            ArrayList<AgrItemPO> agrItemPOs = new ArrayList<AgrItemPO>();
            ArrayList<AgrItemLadderPricePO> agrItemLadderPricePOS = new ArrayList<AgrItemLadderPricePO>();
            ArrayList<AgrItemExtPO> agrItemExtPOS = new ArrayList<AgrItemExtPO>();
            agrAgrDo.getAgrItem().stream().forEach(agrItem -> {
                AgrItemPO agrItemPO = (AgrItemPO)JSON.parseObject((String)JSON.toJSONString((Object)agrItem), AgrItemPO.class);
                agrItemPO.setAgrId(agrAgrDo.getAgrId());
                agrItemPO.setAgrItemId(IdUtil.nextId());
                if (agrItemPO.getAgrSkuStatus() == null) {
                    agrItemPO.setAgrSkuStatus(1);
                }
                agrItemPOs.add(agrItemPO);
                if (!CollectionUtils.isEmpty((Collection)agrItem.getAgrItemLadderPrice())) {
                    agrItem.getAgrItemLadderPrice().forEach(agrItemLadderPrice -> {
                        AgrItemLadderPricePO agrItemLadderPricePO = (AgrItemLadderPricePO)JSON.parseObject((String)JSON.toJSONString((Object)agrItemLadderPrice), AgrItemLadderPricePO.class);
                        agrItemLadderPricePO.setAgrId(agrAgrDo.getAgrId());
                        agrItemLadderPricePO.setAgrItemId(agrItemPO.getAgrItemId());
                        agrItemLadderPricePO.setItemLadderPriceId(IdUtil.nextId());
                        agrItemLadderPricePOS.add(agrItemLadderPricePO);
                    });
                }
                if (!CollectionUtils.isEmpty((Collection)agrItem.getAgrItemExt())) {
                    agrItem.getAgrItemExt().forEach(agrItemExt -> {
                        AgrItemExtPO agrItemExtPO = (AgrItemExtPO)JSON.parseObject((String)JSON.toJSONString((Object)agrItemExt), AgrItemExtPO.class);
                        agrItemExtPO.setAgrId(agrAgrDo.getAgrId());
                        agrItemExtPO.setAgrItemId(agrItemPO.getAgrItemId());
                        agrItemExtPO.setItemExtId(IdUtil.nextId());
                        agrItemExtPOS.add(agrItemExtPO);
                    });
                }
            });
            this.agrItemMapper.insertBatch(agrItemPOs);
            if (!CollectionUtils.isEmpty(agrItemLadderPricePOS)) {
                this.agrItemLadderPriceMapper.insertBatch(agrItemLadderPricePOS);
            }
            if (!CollectionUtils.isEmpty(agrItemExtPOS)) {
                this.agrItemExtMapper.insertBatch(agrItemExtPOS);
            }
        }
    }

    public void deleteAgrItemByBatch(AgrAgrDo agrAgrDo) {
        AgrItemPO agrItemPODel = new AgrItemPO();
        agrItemPODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty((Collection)agrAgrDo.getAgrItem())) {
            agrItemPODel.setAgrItemIds(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemIds());
            agrItemPODel.setAgrItemId(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemId());
        }
        this.agrItemMapper.deleteBy(agrItemPODel);
        AgrItemExtPO agrItemExtPODel = new AgrItemExtPO();
        agrItemExtPODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty((Collection)agrAgrDo.getAgrItem())) {
            agrItemExtPODel.setAgrItemIds(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemIds());
            agrItemExtPODel.setAgrItemId(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemId());
        }
        this.agrItemExtMapper.deleteBy(agrItemExtPODel);
        AgrItemLadderPricePO agrItemLadderPricePODel = new AgrItemLadderPricePO();
        agrItemLadderPricePODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty((Collection)agrAgrDo.getAgrItem())) {
            agrItemLadderPricePODel.setAgrItemIds(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemIds());
            agrItemLadderPricePODel.setAgrItemId(((AgrItem)agrAgrDo.getAgrItem().get(0)).getAgrItemId());
        }
        this.agrItemLadderPriceMapper.deleteBy(agrItemLadderPricePODel);
    }

    public void updateAgrItemByBatch(AgrAgrDo agrAgrDo) {
        if (!CollectionUtils.isEmpty((Collection)agrAgrDo.getAgrItem())) {
            for (AgrItem agrItem : agrAgrDo.getAgrItem()) {
                AgrItemPO agrItemPOWhere = new AgrItemPO();
                agrItemPOWhere.setAgrItemIds(agrItem.getAgrItemIds());
                agrItemPOWhere.setAgrItemId(agrItem.getAgrItemId());
                agrItemPOWhere.setAgrId(agrAgrDo.getAgrId());
                AgrItemPO agrItemPOSet = (AgrItemPO)AgrRu.js((Object)agrItem, AgrItemPO.class);
                agrItemPOSet.setAgrId(null);
                agrItemPOSet.setAgrItemId(null);
                this.agrItemMapper.updateBy(agrItemPOSet, agrItemPOWhere);
            }
        }
    }

    public AgrItemListQryRspPageBo getAgrItemtList(AgrItemListQryReqPageBo param0) {
        Page pg = new Page(param0.getPageNo().intValue(), param0.getPageSize().intValue());
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = new AgrItemListQryRspPageBo();
        List<AgrItemPO> listPage = this.agrItemMapper.getListPage((AgrItemPO)AgrRu.js((Object)param0, AgrItemPO.class), (Page<AgrItemPO>)pg);
        if (ObjectUtil.isNotEmpty(listPage)) {
            List agrItems = AgrRu.jsl(listPage, AgrItem.class);
            for (AgrItem agrItem : agrItems) {
                AgrItemLadderPricePO agrItemLadderPricePO = new AgrItemLadderPricePO();
                agrItemLadderPricePO.setAgrItemId(agrItem.getAgrItemId());
                List<AgrItemLadderPricePO> agrItemLadderPricePOS = this.agrItemLadderPriceMapper.getList(agrItemLadderPricePO);
                AgrItemExtPO agrItemExtPO = new AgrItemExtPO();
                List<AgrItemExtPO> agrItemExtPOS = this.agrItemExtMapper.getList(agrItemExtPO);
                if (ObjectUtil.isNotEmpty(agrItemExtPOS)) {
                    agrItem.setAgrItemExt(AgrRu.jsl(agrItemExtPOS, AgrItemExt.class));
                }
                if (ObjectUtil.isNotEmpty(agrItemLadderPricePOS)) {
                    agrItem.setAgrItemLadderPrice(AgrRu.jsl(agrItemLadderPricePOS, AgrItemLadderPrice.class));
                }
                agrItemListQryRspPageBo.setPageNo(param0.getPageNo());
                agrItemListQryRspPageBo.setTotal(Integer.valueOf(pg.getTotalPages()));
                agrItemListQryRspPageBo.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
                agrItemListQryRspPageBo.setRows(agrItems);
            }
            return agrItemListQryRspPageBo;
        }
        return agrItemListQryRspPageBo;
    }

    public void saveAgrMain(AgrAgrDo agrAgrDo) {
        AgrMainPO agrMainPO = (AgrMainPO)AgrRu.js((Object)agrAgrDo, AgrMainPO.class);
        agrMainPO.setCreateLoginId(agrAgrDo.getUserId());
        agrMainPO.setCreateName(agrAgrDo.getName());
        agrMainPO.setCreateTime(agrAgrDo.getOperTime());
        agrMainPO.setCreateUsername(agrAgrDo.getUsername());
        agrMainPO.setCreateOrgId(ObjectUtil.isNotEmpty((Object)agrAgrDo.getOrgId()) ? agrAgrDo.getOrgId() + "" : null);
        agrMainPO.setCreateOrgName(agrAgrDo.getOrgName());
        this.agrMainMapper.insert(agrMainPO);
    }

    public void deleteAgrMain(AgrAgrDo param0) {
        AgrMainPO agrMainPO = new AgrMainPO();
        agrMainPO.setAgrId(param0.getAgrId());
        this.agrMainMapper.deleteBy(agrMainPO);
    }

    public AgrGetAllAgrListRspBO getAllAgrList() {
        List<AgrMainPO> list = this.agrMainMapper.getList(new AgrMainPO());
        AgrGetAllAgrListRspBO retBo = new AgrGetAllAgrListRspBO();
        if (ObjectUtil.isNotEmpty(list)) {
            retBo.setRows(AgrRu.jsl(list, AgrAgrDo.class));
        } else {
            retBo.setRows(new ArrayList());
        }
        return retBo;
    }

    public void saveAgrAllocateRecord(AgrAgrDo agrAgrDo) {
        if (ObjectUtil.isNotEmpty((Object)agrAgrDo.getAgrAllocateRecord())) {
            ArrayList<AgrAllocateRecordPO> agrAllocateRecordPOS = new ArrayList<AgrAllocateRecordPO>();
            agrAgrDo.getAgrAllocateRecord().forEach(agrAllocateRecord -> {
                AgrAllocateRecordPO po = (AgrAllocateRecordPO)AgrRu.js((Object)agrAllocateRecord, AgrAllocateRecordPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                po.setOperTime(agrAgrDo.getOperTime());
                po.setOperId(agrAgrDo.getUserId());
                agrAllocateRecordPOS.add(po);
            });
            this.agrAllocateRecordMapper.insertBatch(agrAllocateRecordPOS);
        }
    }

    public AgrAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrAgrQryBo agrAgrQryBo) {
        AgrAgrAllocateRecordListRspBO bo = new AgrAgrAllocateRecordListRspBO();
        AgrAllocateRecordPO agrAllocateRecordPO = new AgrAllocateRecordPO();
        agrAllocateRecordPO.setAgrId(agrAgrQryBo.getAgrId());
        List<AgrAllocateRecordPO> list = this.agrAllocateRecordMapper.getList(agrAllocateRecordPO);
        if (!ObjectUtil.isEmpty(list)) {
            bo.setRows(AgrRu.jsl(list, AgrAllocateRecord.class));
        } else {
            bo.setRows(new ArrayList());
        }
        return bo;
    }
}

