package com.tydic.dyc.agr.repository.impl;

import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.auditorder.sub.UocApprovalObj;
import com.tydic.dyc.agr.repository.AgrAuditOrderRepository;
import com.tydic.dyc.agr.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.agr.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.agr.repository.po.UocApprovalObjPO;
import com.tydic.dyc.agr.repository.po.UocAuditOrderPO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:AgrAuditOrderRepositoryImpl
 * 说明:TODO
 * 时间:2022/9/2 11:59
 * 作者:代愿愿
 */
@Slf4j
@Service
public class AgrAuditOrderRepositoryImpl implements AgrAuditOrderRepository {

    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;

    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Override
    public void saveAuditOrder(AgrAuditOrderDo agrAuditOrderDo) {
        UocAuditOrderPO uocAuditOrderPO = AgrRu.js(agrAuditOrderDo, UocAuditOrderPO.class);
        uocAuditOrderMapper.insert(uocAuditOrderPO);
        if(!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())){
            List<UocApprovalObjPO> uocApprovalObjPOS = new ArrayList<>();
            agrAuditOrderDo.getUocApprovalObj().forEach(uocApprovalObj -> {
                UocApprovalObjPO po = AgrRu.js(uocApprovalObj,UocApprovalObjPO.class);
                po.setAuditOrderId(agrAuditOrderDo.getAuditOrderId());
                po.setId(IdUtil.nextId());
                po.setOrderId(agrAuditOrderDo.getOrderId());
                uocApprovalObjPOS.add(po);
            });
            uocApprovalObjMapper.insertBatch(uocApprovalObjPOS);
        }
    }

    @Override
    public AgrAuditOrderDo getAuditObj(AgrAuditOrderQryBo agrAuditOrderQryBo) {
        UocApprovalObjPO uocApprovalObjPO = AgrRu.js(agrAuditOrderQryBo,UocApprovalObjPO.class) ;
        List<UocApprovalObjPO> pos =  uocApprovalObjMapper.getList(uocApprovalObjPO);
        List<UocApprovalObj> uocApprovalObj = AgrRu.jsl(pos,UocApprovalObj.class);
        AgrAuditOrderDo agrAuditOrderDo = new AgrAuditOrderDo();
        agrAuditOrderDo.setUocApprovalObj(uocApprovalObj);
        return agrAuditOrderDo;
    }
}
