package com.tydic.dyc.agr.repository.impl;

import com.tydic.dyc.agr.model.common.AgrCommonDo;
import com.tydic.dyc.agr.model.common.qrybo.AgrBatchDealRecordQryBo;
import com.tydic.dyc.agr.model.common.qrybo.AgrChngMsgQryBo;
import com.tydic.dyc.agr.model.common.qrybo.AgrStatusChngRecordQryBo;
import com.tydic.dyc.agr.model.common.sub.AgrAgrChngMsg;
import com.tydic.dyc.agr.model.common.sub.AgrAgrStatusChngRecord;
import com.tydic.dyc.agr.model.common.sub.ComBatchDealRrecord;
import com.tydic.dyc.agr.repository.AgrCommonRepository;
import com.tydic.dyc.agr.repository.dao.AgrAgrChngMsgMapper;
import com.tydic.dyc.agr.repository.dao.AgrAgrStatusChngRecordMapper;
import com.tydic.dyc.agr.repository.dao.ComBatchDealRrecordMapper;
import com.tydic.dyc.agr.repository.po.AgrAgrChngMsgPO;
import com.tydic.dyc.agr.repository.po.AgrAgrStatusChngRecordPO;
import com.tydic.dyc.agr.repository.po.ComBatchDealRrecordPO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题:AgrCommonRepositoryImpl
 * 说明:TODO
 * 时间:2023/2/7 16:18
 * 作者:代愿愿
 */
@Service
public class AgrCommonRepositoryImpl implements AgrCommonRepository {
    @Autowired
    private AgrAgrChngMsgMapper agrAgrChngMsgMapper;
    @Autowired
    private AgrAgrStatusChngRecordMapper agrAgrStatusChngRecordMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;

    @Override
    public void saveAgrChngMsg(AgrCommonDo agrCommonDo) {
        if(!CollectionUtils.isEmpty(agrCommonDo.getAgrAgrChngMsg())){
            List<AgrAgrChngMsgPO> agrAgrChngMsgPOS = AgrRu.jsl(agrCommonDo.getAgrAgrChngMsg(),AgrAgrChngMsgPO.class);
            agrAgrChngMsgMapper.insertBatch(agrAgrChngMsgPOS);
        }
    }

    @Override
    public void updateAgrChngMsg(AgrCommonDo agrCommonDo) {
        if(!CollectionUtils.isEmpty(agrCommonDo.getAgrAgrChngMsg())){
            agrCommonDo.getAgrAgrChngMsg().forEach(agrAgrChngMsg -> {
                AgrAgrChngMsgPO set = new AgrAgrChngMsgPO() ;
                set.setMsgStatus(agrAgrChngMsg.getMsgStatus());

                AgrAgrChngMsgPO where = new AgrAgrChngMsgPO() ;
                where.setMsgId(agrAgrChngMsg.getMsgId());
                agrAgrChngMsgMapper.updateBy(set,where);
            });

        }
    }

    @Override
    public AgrCommonDo getAgrChngMsgList(AgrChngMsgQryBo agrChngMsgQryBo) {
        AgrAgrChngMsgPO agrAgrChngMsgPO = AgrRu.js(agrChngMsgQryBo,AgrAgrChngMsgPO.class);
        List<AgrAgrChngMsgPO> pos = agrAgrChngMsgMapper.getList(agrAgrChngMsgPO);
        AgrCommonDo agrCommonDo = new AgrCommonDo();
        agrCommonDo.setAgrAgrChngMsg(AgrRu.jsl(pos, AgrAgrChngMsg.class));
        return agrCommonDo;
    }

    @Override
    public void saveAgrStatusChngRecord(AgrCommonDo agrCommonDo) {
        if(!CollectionUtils.isEmpty(agrCommonDo.getAgrAgrStatusChngRecord())){
            List<AgrAgrStatusChngRecordPO> agrAgrStatusChngRecordPOS = AgrRu.jsl(agrCommonDo.getAgrAgrStatusChngRecord(),AgrAgrStatusChngRecordPO.class);;
            agrAgrStatusChngRecordMapper.insertBatch(agrAgrStatusChngRecordPOS);
        }

    }

    @Override
    public AgrCommonDo getAgrStatusChngRecordList(AgrStatusChngRecordQryBo agrStatusChngRecordQryBo) {
        AgrAgrStatusChngRecordPO agrAgrStatusChngRecordPO = AgrRu.js(agrStatusChngRecordQryBo,AgrAgrStatusChngRecordPO.class);
        List<AgrAgrStatusChngRecordPO> pos = agrAgrStatusChngRecordMapper.getList(agrAgrStatusChngRecordPO);
        AgrCommonDo agrCommonDo = new AgrCommonDo();
        agrCommonDo.setAgrAgrStatusChngRecord(AgrRu.jsl(pos, AgrAgrStatusChngRecord.class));
        return agrCommonDo;
    }

    @Override
    public void addBatchDealRecord(AgrCommonDo agrCommonDo) {
        if(!CollectionUtils.isEmpty(agrCommonDo.getComBatchDealRrecord())){
            List<ComBatchDealRrecordPO> comBatchDealRrecordPOS = AgrRu.jsl(agrCommonDo.getComBatchDealRrecord(),ComBatchDealRrecordPO.class);
            comBatchDealRrecordPOS.forEach(comBatchDealRrecordPO -> {
                comBatchDealRrecordPO.setId(IdUtil.nextId());
                comBatchDealRrecordPO.setCreateTime(new Date());
                comBatchDealRrecordPO.setCreateUserId(agrCommonDo.getUserId());
                comBatchDealRrecordPO.setCreateUserName(agrCommonDo.getUsername());
            });
            this.comBatchDealRrecordMapper.insertBatch(comBatchDealRrecordPOS);
        }

    }

    @Override
    public void deleteBatchDealRecord(AgrCommonDo agrCommonDo) {
        if(!CollectionUtils.isEmpty(agrCommonDo.getComBatchDealRrecord())){
            agrCommonDo.getComBatchDealRrecord().forEach(comBatchDealRrecord -> {
                ComBatchDealRrecordPO comBatchDealRrecordPO = AgrRu.js(comBatchDealRrecord,ComBatchDealRrecordPO.class);
                this.comBatchDealRrecordMapper.deleteBy(comBatchDealRrecordPO);
            });
        }
    }

    @Override
    public AgrCommonDo getBatchDealRecordList(AgrBatchDealRecordQryBo agrBatchDealRecordQryBo) {
        AgrCommonDo agrCommonDo = new AgrCommonDo();
        ComBatchDealRrecordPO comBatchDealRrecordPO = AgrRu.js(agrBatchDealRecordQryBo,ComBatchDealRrecordPO.class);
        List<ComBatchDealRrecordPO> pos = this.comBatchDealRrecordMapper.getList(comBatchDealRrecordPO);
        if(!CollectionUtils.isEmpty(pos)){
            agrCommonDo.setComBatchDealRrecord(AgrRu.jsl(pos, ComBatchDealRrecord.class));
        }
        return agrCommonDo;
    }
}
