/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.auditorder.sub.UocApprovalObj;
import com.tydic.dyc.agr.repository.AgrAuditOrderRepository;
import com.tydic.dyc.agr.repository.dao.AgrMainMapper;
import com.tydic.dyc.agr.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.agr.repository.dao.UocApprovalObjMapperUns;
import com.tydic.dyc.agr.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.agr.repository.po.AgrMainPO;
import com.tydic.dyc.agr.repository.po.UocApprovalObjPO;
import com.tydic.dyc.agr.repository.po.UocAuditOrderPO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrAuditOrderRepositoryImpl
implements AgrAuditOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(AgrAuditOrderRepositoryImpl.class);
    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private AgrMainMapper agrMainMapper;
    @Autowired
    private UocApprovalObjMapperUns ucApprovalObjMapperUns;

    public void saveAuditOrder(AgrAuditOrderDo agrAuditOrderDo) {
        UocAuditOrderPO uocAuditOrderPO = (UocAuditOrderPO)AgrRu.js((Object)agrAuditOrderDo, UocAuditOrderPO.class);
        this.uocAuditOrderMapper.insert(uocAuditOrderPO);
        if (!CollectionUtils.isEmpty((Collection)agrAuditOrderDo.getUocApprovalObj())) {
            ArrayList<UocApprovalObjPO> uocApprovalObjPOS = new ArrayList<UocApprovalObjPO>();
            agrAuditOrderDo.getUocApprovalObj().forEach(uocApprovalObj -> {
                UocApprovalObjPO po = (UocApprovalObjPO)AgrRu.js((Object)uocApprovalObj, UocApprovalObjPO.class);
                po.setAuditOrderId(agrAuditOrderDo.getAuditOrderId());
                po.setId(IdUtil.nextId());
                po.setOrderId(agrAuditOrderDo.getOrderId());
                po.setCreateTime(new Date());
                if (AgrCommConstant.AuditObjType.AGREEMENT_AUDIT.equals(uocApprovalObj.getObjBusiType())) {
                    AgrMainPO agrMainPO = new AgrMainPO();
                    agrMainPO.setAgrId(agrAuditOrderDo.getOrderId());
                    AgrMainPO modelBy = this.agrMainMapper.getModelBy(agrMainPO);
                    if (ObjectUtil.isNull((Object)modelBy)) {
                        log.error("\u534f\u8bae\u5ba1\u6279\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u534f\u8bae\u4e0d\u5b58\u5728\uff0c\u534f\u8baeID\uff1a{}", (Object)agrAuditOrderDo.getOrderId());
                    } else {
                        po.setObjVersion(modelBy.getAgrVersion());
                    }
                }
                uocApprovalObjPOS.add(po);
            });
            this.uocApprovalObjMapper.insertBatch(uocApprovalObjPOS);
        }
    }

    public AgrAuditOrderDo getAuditObj(AgrAuditOrderQryBo agrAuditOrderQryBo) {
        UocApprovalObjPO uocApprovalObjPO = (UocApprovalObjPO)AgrRu.js((Object)agrAuditOrderQryBo, UocApprovalObjPO.class);
        List<UocApprovalObjPO> pos = this.uocApprovalObjMapper.getList(uocApprovalObjPO);
        List uocApprovalObj = AgrRu.jsl(pos, UocApprovalObj.class);
        AgrAuditOrderDo agrAuditOrderDo = new AgrAuditOrderDo();
        agrAuditOrderDo.setUocApprovalObj(uocApprovalObj);
        return agrAuditOrderDo;
    }

    public void updateAuditObjVersion(AgrAuditOrderDo param0) {
        List uocApprovalObj = param0.getUocApprovalObj();
        uocApprovalObj.forEach(e -> {
            UocApprovalObjPO where = new UocApprovalObjPO();
            where.setAuditOrderId(e.getAuditOrderId());
            where.setOrderId(param0.getOrderId());
            where.setObjId(e.getObjId());
            UocApprovalObjPO set = new UocApprovalObjPO();
            set.setObjVersion(e.getObjVersion());
            this.ucApprovalObjMapperUns.updateObjVersionIsNull(set, where);
        });
    }
}

