package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.auditorder.sub.UocApprovalObj;
import com.tydic.dyc.agr.repository.AgrAuditOrderRepository;
import com.tydic.dyc.agr.repository.dao.AgrMainMapper;
import com.tydic.dyc.agr.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.agr.repository.dao.UocApprovalObjMapperUns;
import com.tydic.dyc.agr.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.agr.repository.po.AgrMainPO;
import com.tydic.dyc.agr.repository.po.UocApprovalObjPO;
import com.tydic.dyc.agr.repository.po.UocAuditOrderPO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:AgrAuditOrderRepositoryImpl
 * 说明:TODO
 * 时间:2022/9/2 11:59
 * 作者:代愿愿
 */
@Slf4j
@Service
public class AgrAuditOrderRepositoryImpl implements AgrAuditOrderRepository {

    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;

    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Autowired
    private AgrMainMapper agrMainMapper;

    @Autowired
    private UocApprovalObjMapperUns ucApprovalObjMapperUns;

    @Override
    public void saveAuditOrder(AgrAuditOrderDo agrAuditOrderDo) {
        UocAuditOrderPO uocAuditOrderPO = AgrRu.js(agrAuditOrderDo, UocAuditOrderPO.class);
        uocAuditOrderMapper.insert(uocAuditOrderPO);
        if(!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())){
            List<UocApprovalObjPO> uocApprovalObjPOS = new ArrayList<>();
            agrAuditOrderDo.getUocApprovalObj().forEach(uocApprovalObj -> {
                UocApprovalObjPO po = AgrRu.js(uocApprovalObj,UocApprovalObjPO.class);
                po.setAuditOrderId(agrAuditOrderDo.getAuditOrderId());
                po.setId(IdUtil.nextId());
                po.setOrderId(agrAuditOrderDo.getOrderId());
                po.setCreateTime(new Date());
                if (AgrCommConstant.AuditObjType.AGREEMENT_AUDIT.equals(uocApprovalObj.getObjBusiType())) {
                    // 协议新增审批
                    // 新增对象版本号
                    AgrMainPO agrMainPO = new AgrMainPO();
                    agrMainPO.setAgrId(agrAuditOrderDo.getOrderId());
                    AgrMainPO modelBy = agrMainMapper.getModelBy(agrMainPO);
                    if (ObjectUtil.isNull(modelBy)) {
                        log.error("协议审批单保存失败，协议不存在，协议ID：{}", agrAuditOrderDo.getOrderId());
                    } else {
                        po.setObjVersion(modelBy.getAgrVersion());
                    }
                }
                uocApprovalObjPOS.add(po);
            });
            uocApprovalObjMapper.insertBatch(uocApprovalObjPOS);
        }
    }

    @Override
    public AgrAuditOrderDo getAuditObj(AgrAuditOrderQryBo agrAuditOrderQryBo) {
        UocApprovalObjPO uocApprovalObjPO = AgrRu.js(agrAuditOrderQryBo,UocApprovalObjPO.class) ;
        List<UocApprovalObjPO> pos =  uocApprovalObjMapper.getList(uocApprovalObjPO);
        List<UocApprovalObj> uocApprovalObj = AgrRu.jsl(pos,UocApprovalObj.class);
        AgrAuditOrderDo agrAuditOrderDo = new AgrAuditOrderDo();
        agrAuditOrderDo.setUocApprovalObj(uocApprovalObj);
        return agrAuditOrderDo;
    }

    @Override
    public void updateAuditObjVersion(AgrAuditOrderDo param0) {
        List<UocApprovalObj> uocApprovalObj = param0.getUocApprovalObj();
        uocApprovalObj.forEach(e -> {
            UocApprovalObjPO where = new UocApprovalObjPO();
            where.setAuditOrderId(e.getAuditOrderId());
            where.setOrderId(param0.getOrderId());
            where.setObjId(e.getObjId());

            UocApprovalObjPO set = new UocApprovalObjPO();
            set.setObjVersion(e.getObjVersion());

            this.ucApprovalObjMapperUns.updateObjVersionIsNull(set, where);
        });
    }
}
