package com.tydic.dyc.agr.repository.impl;

import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTodoQryBo;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskDeal;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.model.procinst.sub.UocTodo;
import com.tydic.dyc.agr.repository.AgrProcInstRepository;
import com.tydic.dyc.agr.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.agr.repository.dao.UocOrderTaskDealMapper;
import com.tydic.dyc.agr.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.agr.repository.dao.UocTodoMapper;
import com.tydic.dyc.agr.repository.po.UocOrderProcInstPO;
import com.tydic.dyc.agr.repository.po.UocOrderTaskDealPO;
import com.tydic.dyc.agr.repository.po.UocOrderTaskInstPO;
import com.tydic.dyc.agr.repository.po.UocTodoPO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:AgrProcInstRepositoryImpl
 * 说明:TODO
 * 时间:2022/8/24 17:40
 * 作者:代愿愿
 */
@Service
public class AgrProcInstRepositoryImpl implements AgrProcInstRepository {

    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;

    @Autowired
    private UocTodoMapper uocTodoMapper;

    @Override
    public AgrProcInstDo getTaskList(AgrTaskQryBo agrTaskQryBo) {
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        List<UocOrderTaskInstPO> uocOrderTaskInstPOList = uocOrderTaskInstMapper.getList(AgrRu.js(agrTaskQryBo,UocOrderTaskInstPO.class));
        agrProcInstDo.setAgrUocOrderTaskInst(AgrRu.jsl(uocOrderTaskInstPOList, UocOrderTaskInst.class));
        return agrProcInstDo;
    }

    @Override
    public void updateTask(AgrProcInstDo agrProcInstDo) {
        //获取任务实例
        List<UocOrderTaskInstPO> taskInstPOList = AgrRu.jsl(agrProcInstDo.getAgrUocOrderTaskInst(), UocOrderTaskInstPO.class);
        taskInstPOList.forEach(uocOrderTaskInstPO -> {
            //创建修改条件
            UocOrderTaskInstPO where = new UocOrderTaskInstPO();
            //设置任务实例id
            where.setTaskInstId(uocOrderTaskInstPO.getTaskInstId());
            where.setTaskInstIds(uocOrderTaskInstPO.getTaskInstIds());
            where.setOrderId(uocOrderTaskInstPO.getOrderId());
            where.setObjId(uocOrderTaskInstPO.getObjId());
            //根据条件更新数据
            uocOrderTaskInstMapper.updateBy(uocOrderTaskInstPO,where);
        });
    }

    @Override
    public AgrProcInstDo getProInst(AgrProcInstDo agrProcInstDo) {
        UocOrderProcInstPO reqPo =  AgrRu.js(agrProcInstDo,UocOrderProcInstPO.class);
        UocOrderProcInstPO rspPo =  uocOrderProcInstMapper.getModelBy(reqPo);
        return AgrRu.js(rspPo,AgrProcInstDo.class);
    }

    @Override
    public void saveProcInst(AgrProcInstDo agrProcInstDo) {
        UocOrderProcInstPO uocOrderProcInstPO = AgrRu.js(agrProcInstDo,UocOrderProcInstPO.class);
        uocOrderProcInstPO.setId(IdUtil.nextId());
        uocOrderProcInstPO.setCreateTime(agrProcInstDo.getOperTime());
        uocOrderProcInstMapper.insert(uocOrderProcInstPO);
    }

    @Override
    public void saveTask(AgrProcInstDo agrProcInstDo) {
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
            List<UocOrderTaskInstPO> uocOrderTaskInstPOS =  new ArrayList<>();
            agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                UocOrderTaskInstPO po = AgrRu.js(uocOrderTaskInst,UocOrderTaskInstPO.class);
                po.setCreateTime(agrProcInstDo.getOperTime());
                po.setId(IdUtil.nextId());
                uocOrderTaskInstPOS.add(po);
            });
            uocOrderTaskInstMapper.insertBatch(uocOrderTaskInstPOS);
        }
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskDeal())){
            List<UocOrderTaskDealPO> uocOrderTaskDealPOS = new ArrayList<>() ;
            agrProcInstDo.getAgrUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
                UocOrderTaskDealPO po = AgrRu.js(uocOrderTaskDeal,UocOrderTaskDealPO.class);
                po.setId(IdUtil.nextId());
                uocOrderTaskDealPOS.add(po);
            });
            uocOrderTaskDealMapper.insertBatch(uocOrderTaskDealPOS);
        }
    }

    @Override
    public void updateTaskDeal(AgrProcInstDo agrProcInstDo) {
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskDeal())){
            agrProcInstDo.getAgrUocOrderTaskDeal().forEach(uocOrderTaskDeal -> {
                // where
                UocOrderTaskDealPO wherePo = new UocOrderTaskDealPO();
                wherePo.setTaskInstId(uocOrderTaskDeal.getTaskInstId());
                wherePo.setTaskInstIds(uocOrderTaskDeal.getTaskInstIds());
                wherePo.setOrderId(uocOrderTaskDeal.getOrderId());
                wherePo.setObjId(uocOrderTaskDeal.getObjId());
                // set
                UocOrderTaskDealPO setPo = new UocOrderTaskDealPO();
                setPo.setDealId(uocOrderTaskDeal.getDealId());
                setPo.setDealName(uocOrderTaskDeal.getDealName());
                setPo.setDealType(uocOrderTaskDeal.getDealType());
                setPo.setDealClass(uocOrderTaskDeal.getDealClass());
                uocOrderTaskDealMapper.updateBy(setPo,wherePo);
            });
        }

    }

    @Override
    public void deleteTask(AgrProcInstDo agrProcInstDo) {
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocOrderTaskInst())){
            agrProcInstDo.getAgrUocOrderTaskInst().forEach(uocOrderTaskInst -> {
                UocOrderTaskInstPO uocOrderTaskInstPO = AgrRu.js(uocOrderTaskInst,UocOrderTaskInstPO.class);
                uocOrderTaskInstMapper.deleteBy(uocOrderTaskInstPO);
            });
        }
    }

    @Override
    public AgrProcInstDo getTaskDealList(AgrTaskQryBo AgrTaskQryBo) {
        AgrProcInstDo agrProcInstDo1 = new AgrProcInstDo();
        UocOrderTaskDealPO uocOrderTaskDealPO = AgrRu.js(AgrTaskQryBo,UocOrderTaskDealPO.class);
        List<UocOrderTaskDealPO> pos = uocOrderTaskDealMapper.getList(uocOrderTaskDealPO);
        if(!CollectionUtils.isEmpty(pos)){
            agrProcInstDo1.setAgrUocOrderTaskDeal(AgrRu.jsl(pos, UocOrderTaskDeal.class));
        }
        return agrProcInstDo1;
    }


    @Override
    public void saveTaskLog(AgrProcInstDo param0) {

    }

    @Override
    public AgrProcInstDo getTodoList(AgrTodoQryBo agrTodoQryBo) {
        UocTodoPO uocTodoPO = AgrRu.js(agrTodoQryBo,UocTodoPO.class) ;
        List<String> busiIds = new ArrayList<>();
        if(agrTodoQryBo!=null&& agrTodoQryBo.getQryFlag()){
            UocOrderTaskInstPO uocOrderTaskInstPO = new UocOrderTaskInstPO() ;
            uocOrderTaskInstPO.setTaskInstId(agrTodoQryBo.getBusiId());
            UocOrderTaskInstPO po = uocOrderTaskInstMapper.getModelBy(uocOrderTaskInstPO);
            UocOrderTaskInstPO uocOrderTaskInstPO1 = new UocOrderTaskInstPO() ;
            uocOrderTaskInstPO1.setProcState(po.getProcState());
            List<UocOrderTaskInstPO> pos = uocOrderTaskInstMapper.getList(uocOrderTaskInstPO1);
            pos.forEach(uocOrderTaskInstPO2 -> {
                busiIds.add(uocOrderTaskInstPO2.getTaskInstId());
            });

        }
        uocTodoPO.setBusiIds(busiIds);
        List<UocTodoPO> todoPOS = uocTodoMapper.getList(uocTodoPO);
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        if(!CollectionUtils.isEmpty(todoPOS)){
            agrProcInstDo.setAgrUocTodo(AgrRu.jsl(todoPOS, UocTodo.class));
        }

        return agrProcInstDo;
    }

    @Override
    public void saveTodo(AgrProcInstDo agrProcInstDo) {
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocTodo())){
            List<UocTodoPO> uocTodoPOS = AgrRu.jsl(agrProcInstDo.getAgrUocTodo(),UocTodoPO.class) ;
            uocTodoPOS.forEach(uocTodoPO -> {
                uocTodoPO.setCreateTime(new Date());
            });
            uocTodoMapper.insertBatch(uocTodoPOS);
        }
    }
    @Override
    public void updateTodo(AgrProcInstDo agrProcInstDo) {
        if(!CollectionUtils.isEmpty(agrProcInstDo.getAgrUocTodo())){
            agrProcInstDo.getAgrUocTodo().forEach(uocTodo -> {
                UocTodoPO set = AgrRu.js(uocTodo,UocTodoPO.class)  ;
                set.setTodoState(1);
                UocTodoPO where = new UocTodoPO();
                where.setOrderId(uocTodo.getOrderId());
                where.setBusiId(uocTodo.getBusiId());
                where.setTodoIds(uocTodo.getTodoIds());
                uocTodoMapper.updateBy(set,where);
            });
        }
    }

}
