package com.tydic.dyc.agr.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.model.agrsync.AgrSyncRecordDo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrGetAgrItemInfoRspPageBo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrGetSyncProcessRspPageBo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrSyncQryBo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrItemInfo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrMainInfo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrSyncProcess;
import com.tydic.dyc.agr.repository.AgrSyncRecordRepository;
import com.tydic.dyc.agr.repository.dao.AgrItemInfoMapper;
import com.tydic.dyc.agr.repository.dao.AgrMainInfoMapper;
import com.tydic.dyc.agr.repository.dao.AgrSyncProcessMapper;
import com.tydic.dyc.agr.repository.dao.AgrSyncRecordMapper;
import com.tydic.dyc.agr.repository.po.AgrItemInfoPO;
import com.tydic.dyc.agr.repository.po.AgrMainInfoPO;
import com.tydic.dyc.agr.repository.po.AgrSyncProcessPO;
import com.tydic.dyc.agr.repository.po.AgrSyncRecordPO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题:AgrSyncRecordRepositoryImpl
 * 说明:TODO
 * 时间:2023/1/29 14:30
 * 作者:代愿愿
 */
@Service
public class AgrSyncRecordRepositoryImpl  implements AgrSyncRecordRepository {
    @Autowired
    private AgrSyncRecordMapper agrSyncRecordMapper;

    @Autowired
    private AgrMainInfoMapper agrMainInfoMapper;

    @Autowired
    private AgrItemInfoMapper agrItemInfoMapper;

    @Autowired
    private AgrSyncProcessMapper agrSyncProcessMapper;
    @Override
    public void saveAgrSyncRecord(AgrSyncRecordDo agrSyncRecordDo) {
        // 1 新增同步记录
        Date createTime = new Date();
        Long syncRecordId = IdUtil.nextId();
        AgrSyncRecordPO agrSyncRecordPO2 = AgrRu.js(agrSyncRecordDo,AgrSyncRecordPO.class);
        agrSyncRecordPO2.setSyncRecordId(syncRecordId);
        agrSyncRecordPO2.setCreateTime(createTime);
        agrSyncRecordPO2.setSyncResult(AgrCommConstant.SyncResult.SUCCESS);
        agrSyncRecordMapper.insert(agrSyncRecordPO2);
        // 2 新增协议明细信息
        if(agrSyncRecordDo.getSyncType().equals(AgrCommConstant.AgrSyncType.AGR_ITEM)){
            if(!CollectionUtils.isEmpty(agrSyncRecordDo.getAgrItemInfo())){
                List<AgrItemInfoPO> agrItemInfoPOS = AgrRu.jsl(agrSyncRecordDo.getAgrItemInfo(),AgrItemInfoPO.class);
                agrItemInfoPOS.forEach(agrItemInfoPO -> {
                    agrItemInfoPO.setId(IdUtil.nextId());
                    agrItemInfoPO.setAgrId(agrSyncRecordDo.getAgrId());
                    agrItemInfoPO.setBatchNo(agrSyncRecordDo.getBatchNo());
                    agrItemInfoPO.setSyncRecordId(agrSyncRecordPO2.getSyncRecordId());
                    agrItemInfoPO.setCreateTime(createTime);
                });
                agrItemInfoMapper.insertBatch(agrItemInfoPOS);
            }
        }
        // 3 新增协议信息
        if(agrSyncRecordDo.getSyncType().equals(AgrCommConstant.AgrSyncType.AGR_MAIN)){
            if(!ObjectUtils.isEmpty(agrSyncRecordDo.getAgrMainInfo())){
                AgrMainInfoPO agrMainInfoPO = AgrRu.js(agrSyncRecordDo.getAgrMainInfo(),AgrMainInfoPO.class);
                agrMainInfoPO.setId(IdUtil.nextId());
                agrMainInfoPO.setAgrId(agrSyncRecordDo.getAgrId());
                agrMainInfoPO.setBatchNo(agrSyncRecordDo.getBatchNo());
                agrMainInfoPO.setSyncRecordId(agrSyncRecordPO2.getSyncRecordId());
                agrMainInfoPO.setCreateTime(createTime);
                agrMainInfoMapper.insert(agrMainInfoPO);
            }
        }
        // 4 根据批次号查询已同步批次
        AgrSyncRecordPO agrSyncRecordPO = new AgrSyncRecordPO() ;
        agrSyncRecordPO.setBatchNo(agrSyncRecordDo.getBatchNo());
        agrSyncRecordPO.setAgrId(agrSyncRecordDo.getAgrId());
        List<AgrSyncRecordPO> agrSyncRecordPOs = agrSyncRecordMapper.getList(agrSyncRecordPO);
        Boolean failFlag = false;
        Integer totalBatchNum = 0;
        if(!CollectionUtils.isEmpty(agrSyncRecordPOs)){
            for (AgrSyncRecordPO agrSyncRecordPO1: agrSyncRecordPOs) {
                if(agrSyncRecordPO1.getSyncResult().equals(AgrCommConstant.SyncResult.FAIL)){
                    failFlag = true;
                }
                totalBatchNum++;
            }
        }
        // 5 如果是最后一批次同时没有失败记录
        if(totalBatchNum == agrSyncRecordDo.getBatchNum()&& !failFlag){
            AgrSyncProcessPO agrSyncProcessPO = new AgrSyncProcessPO();
            agrSyncProcessPO.setId(IdUtil.nextId());
            agrSyncProcessPO.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrSyncProcessPO.setCreateTime(createTime);
            agrSyncProcessPO.setProcessStatus(AgrCommConstant.ProcessStatus.TO_PROCESS);
            agrSyncProcessPO.setAgrId(agrSyncRecordDo.getAgrId());
            agrSyncProcessMapper.insert(agrSyncProcessPO);
        }
        // 6 如果有失败记录
        if(failFlag){
            // 根据批次号和协议ID删除三个表
            AgrSyncRecordPO agrSyncRecordPO1 = new AgrSyncRecordPO() ;
            agrSyncRecordPO1.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrSyncRecordPO1.setAgrId(agrSyncRecordDo.getAgrId());
            agrSyncRecordMapper.deleteBy(agrSyncRecordPO1);

            AgrMainInfoPO agrMainInfoPO = new AgrMainInfoPO();
            agrMainInfoPO.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrMainInfoPO.setAgrId(agrSyncRecordDo.getAgrId());
            agrMainInfoMapper.deleteBy(agrMainInfoPO);

            AgrItemInfoPO agrItemInfoPO = new AgrItemInfoPO();
            agrItemInfoPO.setBatchNo(agrSyncRecordDo.getBatchNo());
            agrItemInfoPO.setAgrId(agrSyncRecordDo.getAgrId());
            agrItemInfoMapper.deleteBy(agrItemInfoPO);
        }

    }

    @Override
    public void updateAgrSyncProcess(AgrSyncRecordDo agrSyncRecordDo) {
        AgrSyncProcessPO set = AgrRu.js(agrSyncRecordDo.getAgrSyncProcess(),AgrSyncProcessPO.class);
        set.setUpdateTime(new Date());
        AgrSyncProcessPO where = new AgrSyncProcessPO();
        where.setId(agrSyncRecordDo.getAgrSyncProcess().getId());
        agrSyncProcessMapper.updateBy(set,where);
    }

    @Override
    public AgrGetSyncProcessRspPageBo getAgrSyncProcessByPage(AgrSyncQryBo agrSyncQryBo) {
        Page<AgrSyncProcessPO> pg = new Page<>(agrSyncQryBo.getPageNo(), agrSyncQryBo.getPageSize());
        AgrSyncProcessPO agrsyncprocesspo = new AgrSyncProcessPO();
        agrsyncprocesspo.setProcessStatus(agrSyncQryBo.getProcessStatus());
        List<AgrSyncProcessPO> agrSyncProcessPOs = agrSyncProcessMapper.getListPage(agrsyncprocesspo,pg);

        //设置返回分页数据
        AgrGetSyncProcessRspPageBo agrGetSyncProcessRspPageBo = new AgrGetSyncProcessRspPageBo();
        List<AgrSyncProcess> agrSyncProcesss = AgrRu.jsl(agrSyncProcessPOs, AgrSyncProcess.class);
        agrGetSyncProcessRspPageBo.setPageNo(agrSyncQryBo.getPageNo());
        agrGetSyncProcessRspPageBo.setTotal(pg.getTotalPages());
        agrGetSyncProcessRspPageBo.setRecordsTotal(pg.getTotalCount());
        agrGetSyncProcessRspPageBo.setRows(agrSyncProcesss);
        return agrGetSyncProcessRspPageBo;
    }

    @Override
    public AgrSyncRecordDo getAgrMainInfo(AgrSyncQryBo agrSyncQryBo) {
        AgrMainInfoPO agrMainInfoPO = new AgrMainInfoPO();
        agrMainInfoPO.setBatchNo(agrSyncQryBo.getBatchNo());
        agrMainInfoPO.setAgrId(agrSyncQryBo.getAgrId());
        AgrMainInfoPO po = agrMainInfoMapper.getModelBy(agrMainInfoPO);
        AgrMainInfo agrMainInfo = AgrRu.js(po,AgrMainInfo.class);
        AgrSyncRecordDo agrSyncRecordDo = new AgrSyncRecordDo();
        agrSyncRecordDo.setAgrMainInfo(agrMainInfo);
        return agrSyncRecordDo;
    }

    @Override
    public AgrGetAgrItemInfoRspPageBo getAgrItemInfoByPage(AgrSyncQryBo agrSyncQryBo) {
        Page<AgrItemInfoPO> pg = new Page<>(agrSyncQryBo.getPageNo(), agrSyncQryBo.getPageSize());
        AgrItemInfoPO agrItemInfoPO = new AgrItemInfoPO() ;
        agrItemInfoPO.setBatchNo(agrSyncQryBo.getBatchNo());
        agrItemInfoPO.setAgrId(agrSyncQryBo.getAgrId());
        List<AgrItemInfoPO> agrItemInfoPOs = agrItemInfoMapper.getListPage(agrItemInfoPO,pg);
        //设置返回分页数据
        AgrGetAgrItemInfoRspPageBo agrGetAgrItemInfoRspPageBo = new AgrGetAgrItemInfoRspPageBo();
        List<AgrItemInfo> agrItemInfos = AgrRu.jsl(agrItemInfoPOs, AgrItemInfo.class);
        agrGetAgrItemInfoRspPageBo.setPageNo(agrSyncQryBo.getPageNo());
        agrGetAgrItemInfoRspPageBo.setTotal(pg.getTotalPages());
        agrGetAgrItemInfoRspPageBo.setRecordsTotal(pg.getTotalCount());
        agrGetAgrItemInfoRspPageBo.setRows(agrItemInfos);
        return agrGetAgrItemInfoRspPageBo;
    }
}
