package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.qrybo.*;
import com.tydic.dyc.agr.model.agr.sub.*;
import com.tydic.dyc.agr.repository.AgrAgrRepository;
import com.tydic.dyc.agr.repository.dao.*;
import com.tydic.dyc.agr.repository.po.*;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:AgrAgrRepositoryImpl
 * 说明:TODO
 * 时间:2022/8/23 15:25
 * 作者:代愿愿
 */
@Slf4j
@Service
public class AgrAgrRepositoryImpl implements AgrAgrRepository {

    @Autowired
    private AgrMainMapper agrMainMapper;

    @Autowired
    private AgrItemMapper agrItemMapper;

    @Autowired
    private AgrAppScopeMapper agrAppScopeMapper;

    @Autowired
    private AgrPayConfigMapper agrPayConfigMapper;

    @Autowired
    private AgrAdjustCfgMapper agrAdjustCfgMapper;

    @Autowired
    private AgrCataScopeMapper agrCataScopeMapper;

    @Autowired
    private AgrRelMapper agrRelMapper;

    @Autowired
    private AgrMainExtMapper agrMainExtMapper;

    @Autowired
    private AgrAccessoryMapper agrAccessoryMapper;


    @Autowired
    private AgrItemLadderPriceMapper agrItemLadderPriceMapper;

    @Autowired
    private AgrItemExtMapper agrItemExtMapper;


    @Autowired
    private AgrAllocateRecordMapper agrAllocateRecordMapper;

    @Autowired
    private AgrItemMapperUns agrItemMapperUns;

    @Autowired
    private AgrAgrVersionMapper agrAgrVersionMapper;

    @Autowired
    private AgrMainHisMapper agrMainHisMapper;

    @Autowired
    private AgrItemHisMapper agrItemHisMapper;

    @Autowired
    private AgrAppScopeHisMapper agrAppScopeHisMapper;

    @Autowired
    private AgrPayConfigHisMapper agrPayConfigHisMapper;

    @Autowired
    private AgrAdjustCfgHisMapper agrAdjustCfgHisMapper;

    @Autowired
    private AgrCataScopeHisMapper agrCataScopeHisMapper;

    @Autowired
    private AgrRelHisMapper agrRelHisMapper;

    @Autowired
    private AgrMainExtHisMapper agrMainExtHisMapper;

    @Autowired
    private AgrItemLadderPriceHisMapper agrItemLadderPriceHisMapper;

    @Autowired
    private AgrItemExtHisMapper agrItemExtHisMapper;

    @Autowired
    private AgrAccessoryHisMapper agrAccessoryHisMapper;
    @Autowired
    private AgrMainMapperUns agrMainMapperUns;



    @Override
    public void saveAgrSub(AgrAgrDo agrAgrDo) {
        //保存协议应用范围
        if (ObjectUtil.isNotEmpty(agrAgrDo.getAgrAppScope())) {
            List<AgrAppScopePO> agrAppScopePOs = new ArrayList<>();
            agrAgrDo.getAgrAppScope().forEach(agrAppScope -> {
                AgrAppScopePO po = AgrRu.js(agrAppScope, AgrAppScopePO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                if(null == po.getAppScopeId()){
                    po.setAppScopeId(IdUtil.nextId());
                }
                po.setScopeType(agrAgrDo.getScopeType());
                agrAppScopePOs.add(po);
            });
            agrAppScopeMapper.insertBatch(agrAppScopePOs);
        }
        //保存协议支付配置
        if (ObjectUtil.isNotEmpty(agrAgrDo.getAgrPayConfig())) {
            List<AgrPayConfigPO> agrPayConfigPOs = new ArrayList<>();
            agrAgrDo.getAgrPayConfig().forEach(agrPayConfig -> {
                AgrPayConfigPO po = AgrRu.js(agrPayConfig, AgrPayConfigPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                if(null == po.getPayCfgId()){
                    po.setPayCfgId(IdUtil.nextId());
                }
                agrPayConfigPOs.add(po);
            });
            agrPayConfigMapper.insertBatch(agrPayConfigPOs);
        }
        //保存协议调价配置
        if (agrAgrDo.getAgrAdjustCfg() != null) {
            AgrAdjustCfgPO agrAdjustCfgPO = AgrRu.js(agrAgrDo.getAgrAdjustCfg(), AgrAdjustCfgPO.class);
            agrAdjustCfgPO.setAgrId(agrAgrDo.getAgrId());
            if(null == agrAdjustCfgPO.getAdjustCfgId()){
                agrAdjustCfgPO.setAdjustCfgId(IdUtil.nextId());
            }
            agrAdjustCfgMapper.insert(agrAdjustCfgPO);
        }
        //保存协议类目范围
        if (ObjectUtil.isNotEmpty(agrAgrDo.getAgrCataScope())) {
            List<AgrCataScopePO> agrCataScopePOs = new ArrayList<>();
            agrAgrDo.getAgrCataScope().forEach(agrCataScope -> {
                AgrCataScopePO po = AgrRu.js(agrCataScope, AgrCataScopePO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                if(null == po.getCataScopeId()){
                    po.setCataScopeId(IdUtil.nextId());
                }
                agrCataScopePOs.add(po);
            });
            agrCataScopeMapper.insertBatch(agrCataScopePOs);
        }
        //保存协议外部关联
        if (!CollectionUtils.isEmpty(agrAgrDo.getAgrRel())&& ObjectUtil.isNotEmpty(agrAgrDo.getAgrRel().get(0).getObjId())) {
            List<AgrRelPO> agrRelPOs = new ArrayList<>();
            agrAgrDo.getAgrRel().forEach(agrRelPO -> {
                AgrRelPO po = AgrRu.js(agrRelPO, AgrRelPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                if(null == po.getRelId()){
                    po.setRelId(IdUtil.nextId());
                }
                po.setObjNo(agrRelPO.getObjNo());
                po.setObjName(agrRelPO.getObjName());
                po.setObjId(agrRelPO.getObjId());
                po.setObjType(AgrCommConstant.RelObjType.CONTRACT);
                agrRelPOs.add(po);
            });
            agrRelMapper.insertBatch(agrRelPOs);
        }
        //保存协议主体拓展
        if (ObjectUtil.isNotEmpty(agrAgrDo.getAgrMainExt())) {
            List<AgrMainExtPO> agrMainExtPOs = new ArrayList<>();
            agrAgrDo.getAgrMainExt().forEach(agrMainExtPO -> {
                AgrMainExtPO po = AgrRu.js(agrMainExtPO, AgrMainExtPO.class);
                po.setAgrId(agrAgrDo.getAgrId());
                if(null == po.getMainExtId()){
                    po.setMainExtId(IdUtil.nextId());
                }
                agrMainExtPOs.add(po);
            });
            agrMainExtMapper.insertBatch(agrMainExtPOs);
        }
        //保存协议主体附件
        if (ObjectUtil.isNotEmpty(agrAgrDo.getAgrAccessory())) {
            List<AgrAccessoryPO> agrAccessoryPOs = new ArrayList<>();
            agrAgrDo.getAgrAccessory().forEach(agrAccessoryPO -> {
                AgrAccessoryPO po = AgrRu.js(agrAccessoryPO, AgrAccessoryPO.class);
                po.setOrderId(agrAgrDo.getAgrId());
                po.setObjId(agrAgrDo.getAgrId());
                if(null == po.getId()){
                    po.setId(IdUtil.nextId());
                }
                po.setObjType(AgrCommConstant.FileObjType.AGR);
                agrAccessoryPOs.add(po);
            });
            agrAccessoryMapper.insertBatch(agrAccessoryPOs);
        }
    }

    @Override
    public void updateAgrMain(AgrAgrDo agrAgrDo) {
        //修改协议主体
        AgrMainPO agrMainPOSet = AgrRu.js(agrAgrDo, AgrMainPO.class);
        agrMainPOSet.setUpdateLoginId(agrAgrDo.getUserId());
        agrMainPOSet.setUpdateName(agrAgrDo.getName());
        agrMainPOSet.setUpdateUsername(agrAgrDo.getUsername());
        agrMainPOSet.setUpdateTime(agrAgrDo.getOperTime());
        AgrMainPO agrMainPOWhere = new AgrMainPO();
        //设置协议ID
        agrMainPOWhere.setAgrId(agrAgrDo.getAgrId());
//        agrMainPOSet.setCreateLoginId(agrMainPOSet.getAgrOperatorId());
//        agrMainPOSet.setCreateUsername(agrMainPOSet.getAgrOperatorUsername());
//        agrMainPOSet.setCreateName(agrMainPOSet.getAgrOperatorName());
        this.agrMainMapper.updateBy(agrMainPOSet, agrMainPOWhere);
    }

    @Override
    public AgrAgrDo getAgrMain(AgrAgrQryBo agrAgrQryBo) {
        AgrMainPO agrMain = new AgrMainPO();
        agrMain.setAgrId(agrAgrQryBo.getAgrId());
        agrMain.setAgrCode(agrAgrQryBo.getAgrCode());
        agrMain.setRelCode(agrAgrQryBo.getRelCode());
        agrMain.setAgrType(agrAgrQryBo.getAgrType());
        AgrMainPO agrMainPO = this.agrMainMapper.getModelBy(agrMain);
        return AgrRu.js(agrMainPO, AgrAgrDo.class);
    }

    @Override
    public void deleteAgrSub(AgrAgrDo param0) {
        //删除协议调价配置
        AgrAdjustCfgPO agrAdjustCfgPO = new AgrAdjustCfgPO();
        //设置协议ID
        agrAdjustCfgPO.setAgrId(param0.getAgrId());
        this.agrAdjustCfgMapper.deleteBy(agrAdjustCfgPO);

        //删除协议支付配置
        AgrPayConfigPO agrPayConfigPODel = new AgrPayConfigPO();
        //设置协议ID
        agrPayConfigPODel.setAgrId(param0.getAgrId());
        this.agrPayConfigMapper.deleteBy(agrPayConfigPODel);

        //删除协议应用范围
        AgrAppScopePO agrAppScopePODel = new AgrAppScopePO();
        //设置协议ID
        agrAppScopePODel.setAgrId(param0.getAgrId());
        this.agrAppScopeMapper.deleteBy(agrAppScopePODel);

        //删除协议类目范围
        AgrCataScopePO agrCataScopePODel = new AgrCataScopePO();
        //设置协议ID
        agrCataScopePODel.setAgrId(param0.getAgrId());
        this.agrCataScopeMapper.deleteBy(agrCataScopePODel);

        //删除协议主体拓展
        AgrMainExtPO agrMainExtPODel = new AgrMainExtPO();
        //设置协议ID
        agrMainExtPODel.setAgrId(param0.getAgrId());
        this.agrMainExtMapper.deleteBy(agrMainExtPODel);

//        //删除协议外部关联
//        AgrRelPO agrRelPODel = new AgrRelPO();
//        //设置协议ID
//        agrRelPODel.setAgrId(param0.getAgrId());
//        this.agrRelMapper.deleteBy(agrRelPODel);

        //删除协议附件
        AgrAccessoryPO agrAccessoryPODel = new AgrAccessoryPO();
        //设置对象ID
        agrAccessoryPODel.setObjId(param0.getAgrId());
        this.agrAccessoryMapper.deleteBy(agrAccessoryPODel);

    }

    @Override
    public AgrAgrDo getAgrDetail(AgrAgrQryBo agrAgrQryBo) {
        //协议主体
        AgrMainPO agrMainPO = AgrRu.js(agrAgrQryBo, AgrMainPO.class);
        AgrMainPO modelBy = this.agrMainMapper.getModelBy(agrMainPO);
        if(modelBy==null){
            // 查询协议历史表
            AgrMainHisPO agrMainHisPO = AgrRu.js(agrAgrQryBo, AgrMainHisPO.class);;
            AgrMainHisPO agrMainHisPO1 = this.agrMainHisMapper.getModelBy(agrMainHisPO);
            if(null!=agrMainHisPO1){
                agrAgrQryBo.setAgrId(agrMainHisPO1.getAgrId());
                AgrAgrDo agrAgrDo = AgrRu.js(agrMainHisPO1, AgrAgrDo.class);
                //协议应用范围
                AgrAppScopeHisPO agrappscopehispo = new AgrAppScopeHisPO();
                agrappscopehispo.setAgrId(agrAgrQryBo.getAgrId());
                agrappscopehispo.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrAppScopeHisPO> agrAppScopeHisPOS = this.agrAppScopeHisMapper.getList(agrappscopehispo);
                agrAgrDo.setAgrAppScope(AgrRu.jsl(agrAppScopeHisPOS, AgrAppScope.class));

                //协议支付配置
                AgrPayConfigHisPO agrPayConfigHisPO = new AgrPayConfigHisPO();
                agrPayConfigHisPO.setAgrId(agrAgrQryBo.getAgrId());
                agrPayConfigHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrPayConfigHisPO> agrPayConfigHisPOS = this.agrPayConfigHisMapper.getList(agrPayConfigHisPO);
                agrAgrDo.setAgrPayConfig(AgrRu.jsl(agrPayConfigHisPOS, AgrPayConfig.class));

                //协议调价配置
                AgrAdjustCfgHisPO adjustCfgHisPO = new AgrAdjustCfgHisPO();
                adjustCfgHisPO.setAgrId(agrAgrQryBo.getAgrId());
                adjustCfgHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                AgrAdjustCfgHisPO agrAdjustCfgHisPO = this.agrAdjustCfgHisMapper.getModelBy(adjustCfgHisPO);
                agrAgrDo.setAgrAdjustCfg(AgrRu.js(agrAdjustCfgHisPO, AgrAdjustCfg.class));

                //协议类目范围
                AgrCataScopeHisPO agrCataScopeHisPO = new AgrCataScopeHisPO();
                agrCataScopeHisPO.setAgrId(agrAgrQryBo.getAgrId());
                agrCataScopeHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrCataScopeHisPO> agrCataScopeHisPOS = this.agrCataScopeHisMapper.getList(agrCataScopeHisPO);
                agrAgrDo.setAgrCataScope(AgrRu.jsl(agrCataScopeHisPOS, AgrCataScope.class));

                //协议外部关联
                AgrRelHisPO agrRelHisPO = new AgrRelHisPO();
                agrRelHisPO.setAgrId(agrAgrQryBo.getAgrId());
                agrRelHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrRelHisPO> agrRelHisPOS = this.agrRelHisMapper.getList(agrRelHisPO);
                agrAgrDo.setAgrRel(AgrRu.jsl(agrRelHisPOS, AgrRel.class));

                //协议主体拓展
                AgrMainExtHisPO agrMainExtHisPO = new AgrMainExtHisPO();
                agrMainExtHisPO.setAgrId(agrAgrQryBo.getAgrId());
                agrMainExtHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrMainExtHisPO> agrMainExtHisPOS = this.agrMainExtHisMapper.getList(agrMainExtHisPO);
                agrAgrDo.setAgrMainExt(AgrRu.jsl(agrMainExtHisPOS, AgrMainExt.class));

                //协议主体附件
                AgrAccessoryPO agrAccessoryPO = new AgrAccessoryPO();
                //分库建ID=协议ID
                agrAccessoryPO.setObjId(agrAgrQryBo.getAgrId());
                //对象ID=协议ID
                agrAccessoryPO.setOrderId(agrAgrQryBo.getAgrId());
                agrAccessoryPO.setObjType(AgrCommConstant.AccessoryObjType.AGR_MAIN);
                List<AgrAccessoryPO> agrAccessoryPOS = this.agrAccessoryMapper.getList(agrAccessoryPO);
                agrAgrDo.setAgrAccessory(AgrRu.jsl(agrAccessoryPOS, AgrAccessory.class));
                return agrAgrDo;
            }else {
                return null;
            }

        }else {
            agrAgrQryBo.setAgrId(modelBy.getAgrId());
            AgrAgrDo agrAgrDo = AgrRu.js(modelBy, AgrAgrDo.class);
            //协议应用范围
            AgrAppScopePO agrAppScopePO = new AgrAppScopePO();
            agrAppScopePO.setAgrId(agrAgrQryBo.getAgrId());
            List<AgrAppScopePO> agrAppScopePOS = this.agrAppScopeMapper.getList(agrAppScopePO);
            agrAgrDo.setAgrAppScope(AgrRu.jsl(agrAppScopePOS, AgrAppScope.class));
            //协议支付配置
            AgrPayConfigPO agrPayConfigPO = new AgrPayConfigPO();
            agrPayConfigPO.setAgrId(agrAgrQryBo.getAgrId());
            List<AgrPayConfigPO> agrPayConfigPOS = this.agrPayConfigMapper.getList(agrPayConfigPO);
            agrAgrDo.setAgrPayConfig(AgrRu.jsl(agrPayConfigPOS, AgrPayConfig.class));

            //协议调价配置
            AgrAdjustCfgPO adjustCfgPO = new AgrAdjustCfgPO();
            adjustCfgPO.setAgrId(agrAgrQryBo.getAgrId());
            AgrAdjustCfgPO agrAdjustCfgPO = this.agrAdjustCfgMapper.getModelBy(adjustCfgPO);
            agrAgrDo.setAgrAdjustCfg(AgrRu.js(agrAdjustCfgPO, AgrAdjustCfg.class));

            //协议类目范围
            AgrCataScopePO agrCataScopePO = new AgrCataScopePO();
            agrCataScopePO.setAgrId(agrAgrQryBo.getAgrId());
            List<AgrCataScopePO> agrCataScopePOS = this.agrCataScopeMapper.getList(agrCataScopePO);
            agrAgrDo.setAgrCataScope(AgrRu.jsl(agrCataScopePOS, AgrCataScope.class));

            //协议外部关联
            AgrRelPO agrRelPO = new AgrRelPO();
            agrRelPO.setAgrId(agrAgrQryBo.getAgrId());
            List<AgrRelPO> agrRelPOS = this.agrRelMapper.getList(agrRelPO);
            agrAgrDo.setAgrRel(AgrRu.jsl(agrRelPOS, AgrRel.class));

            //协议主体拓展
            AgrMainExtPO agrMainExtPO = new AgrMainExtPO();
            agrMainExtPO.setAgrId(agrAgrQryBo.getAgrId());
            List<AgrMainExtPO> agrMainExtPOS = this.agrMainExtMapper.getList(agrMainExtPO);
            agrAgrDo.setAgrMainExt(AgrRu.jsl(agrMainExtPOS, AgrMainExt.class));

            //协议主体附件
            AgrAccessoryPO agrAccessoryPO = new AgrAccessoryPO();
            //分库建ID=协议ID
            agrAccessoryPO.setObjId(agrAgrQryBo.getAgrId());
            //对象ID=协议ID
            agrAccessoryPO.setOrderId(agrAgrQryBo.getAgrId());
            agrAccessoryPO.setObjType(AgrCommConstant.AccessoryObjType.AGR_MAIN);
            List<AgrAccessoryPO> agrAccessoryPOS = this.agrAccessoryMapper.getList(agrAccessoryPO);
            agrAgrDo.setAgrAccessory(AgrRu.jsl(agrAccessoryPOS, AgrAccessory.class));
            return agrAgrDo;
        }
    }

    @Override
    public void saveAgrItem(AgrAgrDo agrAgrDo) {
        //新增加协议明细
        if (ObjectUtil.isNotEmpty(agrAgrDo.getAgrItem())) {
            List<AgrItemPO> agrItemPOs = new ArrayList<>();
            List<AgrItemLadderPricePO> agrItemLadderPricePOS = new ArrayList<>();
            List<AgrItemExtPO> agrItemExtPOS = new ArrayList<>();
            agrAgrDo.getAgrItem().stream().forEach(agrItem -> {
                // 组装协议明细
                AgrItemPO agrItemPO = JSON.parseObject(JSON.toJSONString(agrItem), AgrItemPO.class);
                agrItemPO.setAgrId(agrAgrDo.getAgrId());
                agrItemPO.setUniqueKey(agrItem.getCommodityTypeName()+"_"+agrItem.getMaterialCode());
                if(agrItemPO.getAgrItemId()==null){
                    agrItemPO.setAgrItemId(IdUtil.nextId());
                }
                if (agrItemPO.getAgrSkuStatus() == null) {
                    agrItemPO.setAgrSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
                }
                agrItemPOs.add(agrItemPO);
                // 组装协议明细阶梯价
                if (!CollectionUtils.isEmpty(agrItem.getAgrItemLadderPrice())) {
                    agrItem.getAgrItemLadderPrice().forEach(agrItemLadderPrice -> {
                        AgrItemLadderPricePO agrItemLadderPricePO = JSON.parseObject(JSON.toJSONString(agrItemLadderPrice), AgrItemLadderPricePO.class);
                        agrItemLadderPricePO.setAgrId(agrAgrDo.getAgrId());
                        agrItemLadderPricePO.setAgrItemId(agrItemPO.getAgrItemId());
                        if(agrItemLadderPricePO.getItemLadderPriceId()==null){
                            agrItemLadderPricePO.setItemLadderPriceId(IdUtil.nextId());
                        }
                        agrItemLadderPricePOS.add(agrItemLadderPricePO);
                    });
                }
                // 组装协议明细扩展字段
                if (!CollectionUtils.isEmpty(agrItem.getAgrItemExt())) {
                    agrItem.getAgrItemExt().forEach(agrItemExt -> {
                        AgrItemExtPO agrItemExtPO = JSON.parseObject(JSON.toJSONString(agrItemExt), AgrItemExtPO.class);
                        agrItemExtPO.setAgrId(agrAgrDo.getAgrId());
                        agrItemExtPO.setAgrItemId(agrItemPO.getAgrItemId());
                        if(agrItemExtPO.getItemExtId()==null){
                            agrItemExtPO.setItemExtId(IdUtil.nextId());
                        }
                        agrItemExtPOS.add(agrItemExtPO);
                    });
                }

            });
            // 批量新增协议明细
            agrItemMapper.insertBatch(agrItemPOs);
            if (!CollectionUtils.isEmpty(agrItemLadderPricePOS)) {
                // 批量新增明细阶梯价
                agrItemLadderPriceMapper.insertBatch(agrItemLadderPricePOS);
            }
            if (!CollectionUtils.isEmpty(agrItemExtPOS)) {
                // 批量新增明细扩展字段
                agrItemExtMapper.insertBatch(agrItemExtPOS);
            }
        }
    }


    @Override
    public void deleteAgrItemByBatch(AgrAgrDo agrAgrDo) {
        //协议明细批量删除
        AgrItemPO agrItemPODel = new AgrItemPO();
        agrItemPODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty(agrAgrDo.getAgrItem())) {
            agrItemPODel.setAgrItemIds(agrAgrDo.getAgrItem().get(0).getAgrItemIds());
            agrItemPODel.setAgrItemId(agrAgrDo.getAgrItem().get(0).getAgrItemId());
        }
        agrItemMapper.deleteBy(agrItemPODel);
        //协议明细扩展批量删除
        AgrItemExtPO agrItemExtPODel = new AgrItemExtPO();
        agrItemExtPODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty(agrAgrDo.getAgrItem())) {
            agrItemExtPODel.setAgrItemIds(agrAgrDo.getAgrItem().get(0).getAgrItemIds());
            agrItemExtPODel.setAgrItemId(agrAgrDo.getAgrItem().get(0).getAgrItemId());
        }
        agrItemExtMapper.deleteBy(agrItemExtPODel);
        //协议明细阶梯价删除
        AgrItemLadderPricePO agrItemLadderPricePODel = new AgrItemLadderPricePO();
        agrItemLadderPricePODel.setAgrId(agrAgrDo.getAgrId());
        if (!CollectionUtils.isEmpty(agrAgrDo.getAgrItem())) {
            agrItemLadderPricePODel.setAgrItemIds(agrAgrDo.getAgrItem().get(0).getAgrItemIds());
            agrItemLadderPricePODel.setAgrItemId(agrAgrDo.getAgrItem().get(0).getAgrItemId());
        }
        agrItemLadderPriceMapper.deleteBy(agrItemLadderPricePODel);
    }

    @Override
    public void updateAgrItemByBatch(AgrAgrDo agrAgrDo) {
        if (!CollectionUtils.isEmpty(agrAgrDo.getAgrItem())){
            for (AgrItem agrItem : agrAgrDo.getAgrItem()) {
                AgrItemPO agrItemPO = AgrRu.js(agrItem, AgrItemPO.class);
                agrItemPO.setAgrId(agrAgrDo.getAgrId());
                agrItemMapperUns.updateAgrItemByBatch(agrItemPO);
            }
        }
    }

    @Override
    public AgrItemListQryRspPageBo getAgrItemtList(AgrItemListQryReqPageBo reqPageBo) {
        if (StrUtil.isEmpty(reqPageBo.getOrderBy())) {
            // 默认按协议明细id降序
            reqPageBo.setOrderBy("agr_item_id desc");
        }
        //协议主体
        if(CollectionUtils.isEmpty(reqPageBo.getAgrIds())){
            // 如果根据协议ID和版本号查询时，需要看看是否查询历史表
            AgrMainPO agrMainPO = new AgrMainPO();
            agrMainPO.setAgrId(reqPageBo.getAgrId());
            agrMainPO.setAgrVersion(reqPageBo.getAgrVersion());
            AgrMainPO modelBy = this.agrMainMapper.getModelBy(agrMainPO);
            if(modelBy == null){
                // 查询协议历史表
                AgrMainHisPO agrMainHisPO = new AgrMainHisPO();
                agrMainHisPO.setAgrId(reqPageBo.getAgrId());
                agrMainHisPO.setAgrVersion(reqPageBo.getAgrVersion());
                AgrMainHisPO agrMainHisPO1 = this.agrMainHisMapper.getModelBy(agrMainHisPO);
                if(null ==agrMainHisPO1 ){
                    throw new BaseBusinessException("","协议数据不存在");
                }
                Page<AgrItemPO> pg = new Page<>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
                //设置返回分页数据
                AgrItemListQryRspPageBo agrItemListQryRspPageBo = new AgrItemListQryRspPageBo();
                AgrItemHisPO agrItemHisPO = AgrRu.js(reqPageBo, AgrItemHisPO.class);
                agrItemHisPO.setAgrMainHisId(agrMainHisPO1.getAgrMainHisId());
                List<AgrItemPO> listPage = agrItemMapperUns.getListHisPage(agrItemHisPO, pg);
                List<AgrItem> agrItems = AgrRu.jsl(listPage, AgrItem.class);
                agrItemListQryRspPageBo.setPageNo(reqPageBo.getPageNo());
                agrItemListQryRspPageBo.setTotal(pg.getTotalPages());
                agrItemListQryRspPageBo.setRecordsTotal(pg.getTotalCount());
                agrItemListQryRspPageBo.setRows(agrItems);
                return agrItemListQryRspPageBo;
            }
        }
        Page<AgrItemPO> pg = new Page<>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
        //设置返回分页数据
        AgrItemListQryRspPageBo agrItemListQryRspPageBo = new AgrItemListQryRspPageBo();
        List<AgrItemPO> listPage = agrItemMapperUns.getListPage(AgrRu.js(reqPageBo, AgrItemPO.class), pg);
        List<AgrItem> agrItems = AgrRu.jsl(listPage, AgrItem.class);
        agrItemListQryRspPageBo.setPageNo(reqPageBo.getPageNo());
        agrItemListQryRspPageBo.setTotal(pg.getTotalPages());
        agrItemListQryRspPageBo.setRecordsTotal(pg.getTotalCount());
        agrItemListQryRspPageBo.setRows(agrItems);
        return agrItemListQryRspPageBo;
    }


    @Override
    public void saveAgrMain(AgrAgrDo agrAgrDo) {
        AgrMainPO agrMainPO = AgrRu.js(agrAgrDo, AgrMainPO.class);
        agrMainPO.setCreateLoginId(agrAgrDo.getUserId());
        agrMainPO.setCreateName(agrAgrDo.getName());
        agrMainPO.setCreateTime(agrAgrDo.getOperTime());
        agrMainPO.setCreateUsername(agrAgrDo.getUsername());
        agrMainPO.setCreateOrgId(ObjectUtil.isNotEmpty(agrAgrDo.getOrgId()) ? agrAgrDo.getOrgId() : null);
        agrMainPO.setCreateOrgName(agrAgrDo.getOrgName());
        agrMainMapper.insert(agrMainPO);

    }

    @Override
    public void deleteAgrMain(AgrAgrDo param0) {
        AgrMainPO agrMainPO = new AgrMainPO();
        agrMainPO.setAgrId(param0.getAgrId());
        this.agrMainMapper.deleteBy(agrMainPO);
    }

    @Override
    public AgrListQryRspPageBo getAllAgrList(AgrListQryReqPageBo agrListQryReqPageBo) {
        AgrMainPO agrMainPO = new AgrMainPO();
        Page<AgrMainPO> agrMainPOPage = new Page<>(agrListQryReqPageBo.getPageNo(), agrListQryReqPageBo.getPageSize());
        List<AgrMainPO> list = agrMainMapper.getListPage(agrMainPO,agrMainPOPage);
        AgrListQryRspPageBo retBo = new AgrListQryRspPageBo();
        if (ObjectUtil.isNotEmpty(list)) {
            retBo.setRows(AgrRu.jsl(list, AgrAgrDo.class));
        }
        retBo.setPageNo(agrMainPOPage.getPageNo());
        retBo.setTotal(agrMainPOPage.getTotalPages());
        retBo.setRecordsTotal(agrMainPOPage.getTotalCount());
        return retBo;
    }

    @Override
    public void saveAgrAllocateRecord(AgrAgrDo agrAgrDo) {
        //保存分配记录
        if (ObjectUtil.isNotEmpty(agrAgrDo.getAgrAllocateRecord())) {
            List<AgrAllocateRecordPO> agrAllocateRecordPOS = new ArrayList<>();
            agrAgrDo.getAgrAllocateRecord().forEach(agrAllocateRecord -> {
                AgrAllocateRecordPO po = AgrRu.js(agrAllocateRecord, AgrAllocateRecordPO.class);
                po.setAllocateLogId(IdUtil.nextId());
                po.setAgrId(agrAgrDo.getAgrId());
                po.setOperTime(new Date());
                po.setOperId(agrAgrDo.getUserId());
                po.setOperName(agrAgrDo.getName());
                agrAllocateRecordPOS.add(po);
            });
            agrAllocateRecordMapper.insertBatch(agrAllocateRecordPOS);
        }
    }

    @Override
    public AgrAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrAgrQryBo agrAgrQryBo) {
        AgrAgrAllocateRecordListRspBO bo = new AgrAgrAllocateRecordListRspBO();
        AgrAllocateRecordPO agrAllocateRecordPO = new AgrAllocateRecordPO();
        agrAllocateRecordPO.setAgrId(agrAgrQryBo.getAgrId());
        agrAllocateRecordPO.setOrderBy(agrAgrQryBo.getOrderBy());
        List<AgrAllocateRecordPO> list = agrAllocateRecordMapper.getList(agrAllocateRecordPO);
        if (!ObjectUtil.isEmpty(list)) {
            bo.setRows(AgrRu.jsl(list, AgrAllocateRecord.class));
        } else {
            bo.setRows(new ArrayList<>());
        }
        return bo;
    }

    @Override
    public AgrGetAgrMainListRspQryBo getAgrMainList(AgrAgrQryBo agrAgrQryBo) {
        //准备出参
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = new AgrGetAgrMainListRspQryBo();
        Page<AgrGetAgrMainListRspQryBo> pg = new Page<>(agrAgrQryBo.getPageNo(), agrAgrQryBo.getPageSize());
        List<AgrMainPO> agrMainPOS = agrMainMapperUns.getPageList(agrAgrQryBo, pg);
        List<AgrAgrDo> rows = AgrRu.jsl(agrMainPOS, AgrAgrDo.class);
        agrGetAgrMainListRspQryBo.setRows(rows);
        agrGetAgrMainListRspQryBo.setPageNo(pg.getPageNo());
        agrGetAgrMainListRspQryBo.setTotal(pg.getTotalPages());
        agrGetAgrMainListRspQryBo.setRecordsTotal(pg.getTotalCount());
        agrGetAgrMainListRspQryBo.setRows(rows);
        return agrGetAgrMainListRspQryBo;
    }

    @Override
    public AgrGetAgrItemCountByCommodityTypeRspPageBo getAgrItemCountByCommodityType(AgrGetAgrItemCountByCommodityTypeReqPageBo reqPageBo) {
        AgrGetAgrItemCountByCommodityTypeRspPageBo rspPageBo = new AgrGetAgrItemCountByCommodityTypeRspPageBo();
        Page<AgrItemCountQryBo> pg = new Page<>(reqPageBo.getPageNo(), reqPageBo.getPageSize());
        //设置返回分页数据
        List<AgrItemCountQryBo> listPage = agrItemMapperUns.getAgrItemCountByCommodityType(AgrRu.js(reqPageBo, AgrItemPO.class), pg);
        rspPageBo.setPageNo(reqPageBo.getPageNo());
        rspPageBo.setTotal(pg.getTotalPages());
        rspPageBo.setRecordsTotal(pg.getTotalCount());
        rspPageBo.setRows(listPage);
        return rspPageBo;
    }

    @Override
    public void saveAgrVersion(AgrAgrDo agrAgrDo) {
        // 1 删除待生效
        AgrAgrVersionPO agrAgrVersionPO1 = new AgrAgrVersionPO();
        agrAgrVersionPO1.setAgrId(agrAgrDo.getAgrId());
        agrAgrVersionPO1.setVersionStatus(AgrCommConstant.AgrVersionStatus.TO_VALID);
        this.agrAgrVersionMapper.deleteBy(agrAgrVersionPO1);
        List<AgrAgrVersionPO> agrAgrVersionPOS =  AgrRu.jsl(agrAgrDo.getAgrAgrVersion(),AgrAgrVersionPO.class);
        agrAgrVersionPOS.forEach(agrAgrVersionPO -> {
            agrAgrVersionPO.setAgrVersionId(IdUtil.nextId());
        });
        this.agrAgrVersionMapper.insertBatch(agrAgrVersionPOS);
    }

    @Override
    public AgrGetAgrVersionListRspBo getAgrVersionList(AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo) {
        AgrAgrVersionPO agrAgrVersionPO = AgrRu.js(agrGetAgrVersionListReqBo,AgrAgrVersionPO.class);
        List<AgrAgrVersionPO>  pos = this.agrAgrVersionMapper.getList(agrAgrVersionPO);
        List<AgrAgrVersion> rows = AgrRu.jsl(pos,AgrAgrVersion.class);
        AgrGetAgrVersionListRspBo rspBo = new AgrGetAgrVersionListRspBo();
        rspBo.setRows(rows);
        return rspBo;
    }

    @Override
    public void saveAgrHis(AgrAgrDo agrAgrDo) {

        // 2 复制协议主体
        Long mainHisId = this.copyAgrMain(agrAgrDo);
        // 3 复制协议应用范围
        this.copyAgrAppScope(agrAgrDo,mainHisId);
        //4  复制协议支付配置
        this.copyAgrPayConfig(agrAgrDo,mainHisId);
        //5  复制协议调价配置
        this.copyAgrAdjustCfg(agrAgrDo,mainHisId);
        //6  复制协议类目范围
        this.copyAgrCataScope(agrAgrDo,mainHisId);
        //7  复制协议外部关联
        this.copyAgrRel(agrAgrDo,mainHisId);
        //8  复制协议主体拓展
        this.copyAgrMainExt(agrAgrDo,mainHisId);
        //9  复制复制协议明细
        this.copyAgrItem(agrAgrDo,mainHisId);
        // 10  处理协议版本号
        this.dealAgrVersion(agrAgrDo);
        // 复制附件 agr_accessory_his
        this.copyAccessor(agrAgrDo, mainHisId);
    }

    private void saveAgrChngSysHis(AgrAgrDo agrAgrDo) {
        // 1 查询生效中的协议版本号(不存在生效中的协议版本，则不需要新增历史版本信息)
        if (!this.dealChangeSynAgrVersion(agrAgrDo)) {
            return;
        }
        // 2 复制协议主体
        Long mainHisId = this.copyAgrMain(agrAgrDo);
        // 3 复制协议应用范围
        this.copyAgrAppScope(agrAgrDo,mainHisId);
        //4  复制协议支付配置
        this.copyAgrPayConfig(agrAgrDo,mainHisId);
        //5  复制协议调价配置
        this.copyAgrAdjustCfg(agrAgrDo,mainHisId);
        //6  复制协议类目范围
        this.copyAgrCataScope(agrAgrDo,mainHisId);
        //8  复制协议主体拓展
        this.copyAgrMainExt(agrAgrDo,mainHisId);
        // 复制附件 agr_accessory_his
        this.copyAccessor(agrAgrDo, mainHisId);

    }

    private boolean dealChangeSynAgrVersion(AgrAgrDo agrAgrDo) {
        // 1 查询生效中的协议版本号
        AgrAgrVersionPO agrAgrVersionPO = new AgrAgrVersionPO();
        agrAgrVersionPO.setAgrId(agrAgrDo.getAgrId());
        agrAgrVersionPO.setVersionStatus(AgrCommConstant.AgrVersionStatus.VALID);
        AgrAgrVersionPO pos = this.agrAgrVersionMapper.getModelBy(agrAgrVersionPO);
        if (ObjectUtil.isNull(pos)) {
            return false;
        }
        String newVersion = pos.getAgrVersion().substring(0, 1) + (Integer.parseInt(pos.getAgrVersion().substring(1)) + 1);

        // 2 修改上一版本为已失效
        AgrAgrVersionPO set = new AgrAgrVersionPO();
        set.setVersionStatus(AgrCommConstant.AgrVersionStatus.INVALID);
        AgrAgrVersionPO where = new AgrAgrVersionPO();
        where.setAgrId(agrAgrDo.getAgrId());
        where.setAgrVersionId(pos.getAgrVersionId());
        this.agrAgrVersionMapper.updateBy(set, where);
        // 3 新增变更记录
        AgrAgrVersionPO insert = new AgrAgrVersionPO();
        insert.setAgrVersionId(IdUtil.nextId());
        insert.setAgrId(agrAgrDo.getAgrId());
        insert.setAgrCode(pos.getAgrCode());
        insert.setVersionStatus(AgrCommConstant.AgrVersionStatus.VALID);
        insert.setChngType(agrAgrDo.getAgrAgrVersion().get(0).getChngType());
        insert.setAgrVersion(newVersion);
        insert.setChngApplyCreateTime(ObjectUtil.isNull(agrAgrDo.getAgrAgrVersion().get(0).getChngApplyCreateTime()) ? new Date() : agrAgrDo.getAgrAgrVersion().get(0).getChngApplyCreateTime());
        insert.setRelCode(agrAgrDo.getRelCode());
        insert.setCreateTime(new Date());
        this.agrAgrVersionMapper.insert(insert);
        // 4 修改协议版本号
        AgrMainPO set2 = new AgrMainPO();
        set2.setAgrVersion(newVersion);
        AgrMainPO where2 = new AgrMainPO();
        where2.setAgrId(agrAgrDo.getAgrId());
        this.agrMainMapper.updateBy(set2, where2);
        return true;
    }


    private void copyAccessor(AgrAgrDo agrAgrDo, Long mainHisId) {
        AgrAccessoryPO agrAccessoryPO = new AgrAccessoryPO();
        agrAccessoryPO.setObjId(agrAgrDo.getAgrId());
        List<AgrAccessoryPO> agrAccessoryPOList = this.agrAccessoryMapper.getList(agrAccessoryPO);
        if (CollectionUtil.isEmpty(agrAccessoryPOList)) {
            return;
        }
        List<AgrAccessoryHisPO> agrAccessoryHisPOList = agrAccessoryPOList.stream().map(e -> {
            AgrAccessoryHisPO agrAccessoryHisPO = AgrRu.js(e, AgrAccessoryHisPO.class);
            agrAccessoryHisPO.setObjHisId(mainHisId);
            return agrAccessoryHisPO;
        }).collect(Collectors.toList());
        this.agrAccessoryHisMapper.insertBatch(agrAccessoryHisPOList);
    }

    @Override
    public void checkAgrItemSave(AgrAgrDo agrAgrDo) {
        // 查询协议模式
        AgrMainPO agrMainPO = new AgrMainPO();
        agrMainPO.setAgrId(agrAgrDo.getAgrId());
        AgrMainPO agrMainPO1 = this.agrMainMapper.getModelBy(agrMainPO);
        if(agrMainPO1!=null){
            if(agrMainPO1.getTradeMode().equals(AgrCommConstant.TradeMode.PURCHASE_AND_SALE)){
                //贸易模式需要校验加价比率
                AgrItemPO agrItemPO = new AgrItemPO();
                agrItemPO.setAgrId(agrAgrDo.getAgrId());
                int count  = this.agrItemMapperUns.checkAgrItemSave(agrItemPO);
                if(count>0){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_ERROR,"当前物料明细有必填项未填写，请核实完善后再提交！");
                }
            }else {
                // 撮合模式不用校验加价比率
                AgrItemPO agrItemPO = new AgrItemPO();
                agrItemPO.setAgrId(agrAgrDo.getAgrId());
                int count  = this.agrItemMapperUns.checkAgrItemSave1(agrItemPO);
                if(count>0){
                    throw new BaseBusinessException(AgrRspConstant.RESP_CODE_ERROR,"当前物料明细有必填项未填写，请核实完善后再提交！");
                }
            }
        }

    }

    @Override
    public void updateAgrItemSpecifyField(AgrAgrDo agrAgrDo) {
        if(!CollectionUtils.isEmpty(agrAgrDo.getAgrItem())){
            AgrItemPO agrItemPO = AgrRu.js(agrAgrDo.getAgrItem().get(0),AgrItemPO.class);
            agrItemPO.setAgrId(agrAgrDo.getAgrId());
            if(AgrCommConstant.updateRange.ALL.equals(agrAgrDo.getUpdateRange())){
                this.agrItemMapperUns.updateAgrItemByAgrId(agrItemPO);
            }
            if(AgrCommConstant.updateRange.SPECIFY.equals(agrAgrDo.getUpdateRange())){
                this.agrItemMapperUns.updateAgrItemByAgrItemIds(agrItemPO);
            }
            if(AgrCommConstant.updateRange.NO_WRITE.equals(agrAgrDo.getUpdateRange())){
                this.agrItemMapperUns.updateAgrItemByNull(agrItemPO);
            }
        }
    }

    @Override
    public void deleteAgrVersionRecord(AgrAgrDo agrAgrDo) {
        if(!CollectionUtils.isEmpty(agrAgrDo.getAgrAgrVersion())){
            AgrAgrVersionPO agrAgrVersionPO = AgrRu.js(agrAgrDo.getAgrAgrVersion().get(0),AgrAgrVersionPO.class);
            this.agrAgrVersionMapper.deleteBy(agrAgrVersionPO);
        }
    }

    @Override
    public AgrGetAgrMainListRspQryBo dealAgrInvalid(AgrAgrDo agrAgrDo) {
        AgrGetAgrMainListRspQryBo rspBo = new AgrGetAgrMainListRspQryBo();
        // 根据协议id查询所有已生效子协议
        AgrMainPO agrMainPO = new AgrMainPO();
        agrMainPO.setParentAgrId(agrAgrDo.getAgrId());
        agrMainPO.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        List<AgrMainPO> childrenAgrList = this.agrMainMapper.getList(agrMainPO);
        List<Long> agrIdList = childrenAgrList.stream().map(AgrMainPO::getAgrId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(agrIdList)) {
            agrIdList = new ArrayList<>();
        }
        // 添加当前协议id
        agrIdList.add(agrAgrDo.getAgrId());

        agrIdList.forEach(e -> {
            AgrMainPO set = new AgrMainPO();
            set.setAgrStatus(AgrCommConstant.AgreementStatus.BE_OVERDUE);
            AgrMainPO where = new AgrMainPO();
            where.setAgrId(e);
            this.agrMainMapper.updateBy(set, where);
        });
        List<AgrAgrDo> agrDos = agrIdList.stream().map(e -> {
            AgrAgrDo agrDo = new AgrAgrDo();
            agrDo.setAgrId(e);
            agrDo.setAgrStatus(AgrCommConstant.AgreementStatus.BE_OVERDUE);
            return agrDo;
        }).collect(Collectors.toList());
        rspBo.setRows(agrDos);
        return rspBo;
    }

    @Override
    public void dealChangeSyn(AgrAgrDo agrAgrDo) {
        // 协议日志新增
        this.saveAgrChngSysHis(agrAgrDo);
        // 协议主体修改
        AgrMainPO set = AgrRu.js(agrAgrDo, AgrMainPO.class);
        AgrMainPO where = new AgrMainPO();
        where.setAgrId(agrAgrDo.getAgrId());
        this.agrMainMapper.updateBy(set, where);
        // 附件修改
        AgrAccessoryPO accessoryPOWhere = new AgrAccessoryPO();
        accessoryPOWhere.setObjId(agrAgrDo.getAgrId());
        accessoryPOWhere.setObjType(AgrCommConstant.AccessoryObjType.AGR_MAIN);
        this.agrAccessoryMapper.deleteBy(accessoryPOWhere);
        if (!CollectionUtil.isEmpty(agrAgrDo.getAgrAccessory())) {
            List<AgrAccessoryPO> accessoryPOList = agrAgrDo.getAgrAccessory().stream().map(e -> {
                AgrAccessoryPO accessoryPO = AgrRu.js(e, AgrAccessoryPO.class);
                accessoryPO.setId(IdUtil.nextId());
                accessoryPO.setOrderId(agrAgrDo.getAgrId());
                accessoryPO.setObjId(agrAgrDo.getAgrId());
                if (ObjectUtil.isNull(accessoryPO.getAttachmentType())) {
                    accessoryPO.setAttachmentType(AgrCommConstant.AccessoryObjType.AGR_MAIN);
                }
                accessoryPO.setObjType(AgrCommConstant.AccessoryObjType.AGR_MAIN);
                accessoryPO.setCreateTime(new Date());
                return accessoryPO;
            }).collect(Collectors.toList());
            this.agrAccessoryMapper.insertBatch(accessoryPOList);
        }
    }

    /**
     * 复制协议明细
     */
    private void copyAgrItem(AgrAgrDo agrAgrDo,Long mainHisId){
        Page<AgrItemPO> pg = new Page<>(1, 1000);
        AgrItemPO agrItemPO = new AgrItemPO();
        agrItemPO.setAgrId(agrAgrDo.getAgrId());
        List<AgrItemPO> agrItemPOs = agrItemMapperUns.getListPage(agrItemPO, pg);
        if(!CollectionUtils.isEmpty(agrItemPOs)){
            this.copyAgrItemInfo(agrItemPOs,mainHisId,agrAgrDo.getAgrId());
            // 如果明细数据不止一页
            if(pg.getTotalPages()>1){
                int total = pg.getTotalPages();
                for (int i=2;i<=total;i++){
                    Page<AgrItemPO> pg1 = new Page<>(i, 1000);
                    List<AgrItemPO> agrItemPOs1 = agrItemMapperUns.getListPage(agrItemPO, pg1);
                    this.copyAgrItemInfo(agrItemPOs1,mainHisId,agrAgrDo.getAgrId());
                }
            }
        }
    }
    private void copyAgrItemInfo(List<AgrItemPO> agrItemPOs,Long mainHisId,Long agrId){
        if(!CollectionUtils.isEmpty(agrItemPOs)){
            // 1 复制协议明细
            List<AgrItemHisPO> agrItemHisPOS = AgrRu.jsl(agrItemPOs,AgrItemHisPO.class) ;
            Map<Long,Long> agrItemIdHisIdMap = new HashMap<>();
            List<Long> agrItemIds = new ArrayList<>();
            agrItemHisPOS.forEach(agrItemHisPO -> {
                agrItemHisPO.setAgrMainHisId(mainHisId);
                agrItemHisPO.setAgrItemHisId(IdUtil.nextId());
                agrItemIdHisIdMap.put(agrItemHisPO.getAgrItemId(),agrItemHisPO.getAgrItemHisId());
                agrItemIds.add(agrItemHisPO.getAgrItemId());
            });
            this.agrItemHisMapper.insertBatch(agrItemHisPOS);
            // 2 复制协议明细扩展
            AgrItemExtPO agrItemExtPO = new AgrItemExtPO();
            agrItemExtPO.setAgrId(agrId);
            agrItemExtPO.setAgrItemIds(agrItemIds);
            List<AgrItemExtPO> agrItemExtPOS = this.agrItemExtMapper.getList(agrItemExtPO);
            List<AgrItemExtHisPO> agrItemExtHisPOS = AgrRu.jsl(agrItemExtPOS,AgrItemExtHisPO.class);
            if(!CollectionUtils.isEmpty(agrItemExtHisPOS)){
                agrItemExtHisPOS.forEach(agrItemExtHisPO -> {
                    agrItemExtHisPO.setAgrItemHisId(agrItemIdHisIdMap.get(agrItemExtHisPO.getAgrItemId()));
                    agrItemExtHisPO.setItemExtHisId(IdUtil.nextId());
                });
                this.agrItemExtHisMapper.insertBatch(agrItemExtHisPOS);
            }
            // 3 复制协议明细阶梯价
            AgrItemLadderPricePO agrItemLadderPricePO = new AgrItemLadderPricePO();
            agrItemLadderPricePO.setAgrId(agrId);
            agrItemLadderPricePO.setAgrItemIds(agrItemIds);
            List<AgrItemLadderPricePO> agrItemLadderPricePOS = this.agrItemLadderPriceMapper.getList(agrItemLadderPricePO);
            List<AgrItemLadderPriceHisPO> agrItemLadderPriceHisPOS = AgrRu.jsl(agrItemLadderPricePOS,AgrItemLadderPriceHisPO.class);
            if(!CollectionUtils.isEmpty(agrItemLadderPriceHisPOS)){
                agrItemLadderPriceHisPOS.forEach(agrItemLadderPriceHisPO -> {
                    agrItemLadderPriceHisPO.setAgrItemHisId(agrItemIdHisIdMap.get(agrItemLadderPriceHisPO.getAgrItemId()));
                    agrItemLadderPriceHisPO.setItemLadderPriceHisId(IdUtil.nextId());
                });
                this.agrItemLadderPriceHisMapper.insertBatch(agrItemLadderPriceHisPOS);
            }
        }

    }
    /**
     * 复制协议主体拓展
     */
    private void copyAgrMainExt(AgrAgrDo agrAgrDo,Long mainHisId){
        AgrMainExtPO agrMainExtPO = new AgrMainExtPO();
        agrMainExtPO.setAgrId(agrAgrDo.getAgrId());
        List<AgrMainExtPO> agrMainExtPOS = this.agrMainExtMapper.getList(agrMainExtPO);
        List<AgrMainExtHisPO> agrMainExtHisPOS = AgrRu.jsl(agrMainExtPOS,AgrMainExtHisPO.class);
        if(!CollectionUtils.isEmpty(agrMainExtHisPOS)){
            agrMainExtHisPOS.forEach(agrMainExtHisPO -> {
                agrMainExtHisPO.setAgrMainHisId(mainHisId);
                agrMainExtHisPO.setMainExtHisId(IdUtil.nextId());
            });
            this.agrMainExtHisMapper.insertBatch(agrMainExtHisPOS);
        }
    }
    /**
     * 复制协议外部关联
     */
    private void copyAgrRel(AgrAgrDo agrAgrDo,Long mainHisId){
        AgrRelPO agrRelPO = new AgrRelPO();
        agrRelPO.setAgrId(agrAgrDo.getAgrId());
        List<AgrRelPO> agrRelPOS = this.agrRelMapper.getList(agrRelPO);
        List<AgrRelHisPO> agrRelHisPOS = AgrRu.jsl(agrRelPOS,AgrRelHisPO.class);
        if(!CollectionUtils.isEmpty(agrRelHisPOS)){
            agrRelHisPOS.forEach(agrRelHisPO -> {
                agrRelHisPO.setAgrMainHisId(mainHisId);
                agrRelHisPO.setRelHisId(IdUtil.nextId());
            });
            this.agrRelHisMapper.insertBatch(agrRelHisPOS);
        }
    }
    /**
     * 复制协议类目范围
     */
    private void copyAgrCataScope(AgrAgrDo agrAgrDo,Long mainHisId){
        AgrCataScopePO agrCataScopePO = new AgrCataScopePO();
        agrCataScopePO.setAgrId(agrAgrDo.getAgrId());
        List<AgrCataScopePO> agrCataScopePOS = this.agrCataScopeMapper.getList(agrCataScopePO);
        List<AgrCataScopeHisPO> agrCataScopeHisPOS = AgrRu.jsl(agrCataScopePOS,AgrCataScopeHisPO.class);
        if(!CollectionUtils.isEmpty(agrCataScopeHisPOS)){
            agrCataScopeHisPOS.forEach(agrCataScopeHisPO -> {
                agrCataScopeHisPO.setAgrMainHisId(mainHisId);
                agrCataScopeHisPO.setCataScopeHisId(IdUtil.nextId());
            });
            this.agrCataScopeHisMapper.insertBatch(agrCataScopeHisPOS);
        }
    }
    /**
     * 复制协议调价配置
     */
    private void copyAgrAdjustCfg(AgrAgrDo agrAgrDo,Long mainHisId){
        AgrAdjustCfgPO adjustCfgPO = new AgrAdjustCfgPO();
        adjustCfgPO.setAgrId(agrAgrDo.getAgrId());
        AgrAdjustCfgPO agrAdjustCfgPO = this.agrAdjustCfgMapper.getModelBy(adjustCfgPO);
        AgrAdjustCfgHisPO agrAdjustCfgHisPO = AgrRu.js(agrAdjustCfgPO,AgrAdjustCfgHisPO.class);
        if(agrAdjustCfgHisPO!=null){
            agrAdjustCfgHisPO.setAgrMainHisId(mainHisId);
            agrAdjustCfgHisPO.setAdjustCfgHisId(IdUtil.nextId());
            this.agrAdjustCfgHisMapper.insert(agrAdjustCfgHisPO);
        }
    }
    /**
     * 复制协议支付配置
     */
    private void copyAgrPayConfig(AgrAgrDo agrAgrDo,Long mainHisId){
        AgrPayConfigPO agrPayConfigPO = new AgrPayConfigPO();
        agrPayConfigPO.setAgrId(agrAgrDo.getAgrId());
        List<AgrPayConfigPO> agrPayConfigPOS = this.agrPayConfigMapper.getList(agrPayConfigPO);
        List<AgrPayConfigHisPO> agrPayConfigHisPOS = AgrRu.jsl(agrPayConfigPOS,AgrPayConfigHisPO.class);
        if(!CollectionUtils.isEmpty(agrPayConfigHisPOS)){
            agrPayConfigHisPOS.forEach(agrPayConfigHisPO -> {
                agrPayConfigHisPO.setAgrMainHisId(mainHisId);
                agrPayConfigHisPO.setPayCfgHisId(IdUtil.nextId());
            });
            this.agrPayConfigHisMapper.insertBatch(agrPayConfigHisPOS);
        }
    }
    /**
     * 复制协议应用范围
     */
    private void copyAgrAppScope(AgrAgrDo agrAgrDo,Long mainHisId){
        AgrAppScopePO agrAppScopePO = new AgrAppScopePO();
        agrAppScopePO.setAgrId(agrAgrDo.getAgrId());
        List<AgrAppScopePO> agrAppScopePOS = this.agrAppScopeMapper.getList(agrAppScopePO);
        List<AgrAppScopeHisPO> agrAppScopeHisPOS = AgrRu.jsl(agrAppScopePOS,AgrAppScopeHisPO.class);
        if(!CollectionUtils.isEmpty(agrAppScopeHisPOS)){
            agrAppScopeHisPOS.forEach(agrAppScopeHisPO -> {
                agrAppScopeHisPO.setAgrMainHisId(mainHisId);
                agrAppScopeHisPO.setAppScopeHisId(IdUtil.nextId());
            });
            this.agrAppScopeHisMapper.insertBatch(agrAppScopeHisPOS);
        }
    }
    /**
     * 复制协议主体
     */
    private Long copyAgrMain(AgrAgrDo agrAgrDo){
        AgrMainPO reqPo = new AgrMainPO();
        reqPo.setAgrId(agrAgrDo.getAgrId());
        AgrMainPO modelBy = this.agrMainMapper.getModelBy(reqPo);
        AgrMainHisPO agrMainHisPO = AgrRu.js(modelBy,AgrMainHisPO.class) ;
        agrMainHisPO.setAgrMainHisId(IdUtil.nextId());
        this.agrMainHisMapper.insert(agrMainHisPO);
        return agrMainHisPO.getAgrMainHisId();
    }
    /**
     * 处理协议版本号
     */
    private void dealAgrVersion(AgrAgrDo agrAgrDo){
        // 1 查询生效中的协议版本号
        AgrAgrVersionPO agrAgrVersionPO = new AgrAgrVersionPO();
        agrAgrVersionPO.setAgrId(agrAgrDo.getAgrId());
        agrAgrVersionPO.setVersionStatus(AgrCommConstant.AgrVersionStatus.VALID);
        AgrAgrVersionPO pos  = this.agrAgrVersionMapper.getModelBy(agrAgrVersionPO);

        // 2 修改上一版本为已失效
        AgrAgrVersionPO set = new AgrAgrVersionPO() ;
        set.setVersionStatus(AgrCommConstant.AgrVersionStatus.INVALID);
        AgrAgrVersionPO where  = new AgrAgrVersionPO() ;
        where.setAgrId(agrAgrDo.getAgrId());
        where.setAgrVersionId(pos.getAgrVersionId());
        this.agrAgrVersionMapper.updateBy(set,where);
        // 3 将新个版本号更新到最新的一条版本记录中
        AgrAgrVersionPO set1 = new AgrAgrVersionPO() ;
        // 拼接最新版本号
        String newVersion = pos.getAgrVersion().substring(0,1)+(Integer.parseInt(pos.getAgrVersion().substring(1))+1);
        set1.setAgrVersion(newVersion);
        set1.setVersionStatus(AgrCommConstant.AgrVersionStatus.VALID);
        AgrAgrVersionPO where1  = new AgrAgrVersionPO() ;
        where1.setAgrId(agrAgrDo.getAgrId());
        where1.setVersionStatus(AgrCommConstant.AgrVersionStatus.TO_VALID);
        this.agrAgrVersionMapper.updateBy(set1,where1);
        // 4 修改协议版本号
        AgrMainPO set2 = new  AgrMainPO();
        set2.setAgrVersion(newVersion);
        AgrMainPO where2 = new  AgrMainPO();
        where2.setAgrId(agrAgrDo.getAgrId());
        this.agrMainMapper.updateBy(set2,where2);
    }
}
