package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.auditorder.AgrAuditOrderDo;
import com.tydic.dyc.agr.model.auditorder.qrybo.AgrAuditOrderQryBo;
import com.tydic.dyc.agr.model.auditorder.sub.UocApprovalObj;
import com.tydic.dyc.agr.repository.AgrAuditOrderRepository;
import com.tydic.dyc.agr.repository.dao.*;
import com.tydic.dyc.agr.repository.po.*;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditToDoInfoReqBO;
import com.tydic.dyc.agr.service.auditorder.bo.AgrGetAuditToDoInfoRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:AgrAuditOrderRepositoryImpl
 * 说明:TODO
 * 时间:2022/9/2 11:59
 * 作者:代愿愿
 */
@Slf4j
@Service
public class AgrAuditOrderRepositoryImpl implements AgrAuditOrderRepository {

    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;

    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Autowired
    private AgrMainMapper agrMainMapper;

    @Autowired
    private UocApprovalObjMapperUns ucApprovalObjMapperUns;

    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;

    @Autowired
    private UocOrderTaskInstMapperUns uocOrderTaskInstMapperUns;

    @Override
    public void saveAuditOrder(AgrAuditOrderDo agrAuditOrderDo) {
        UocAuditOrderPO uocAuditOrderPO = AgrRu.js(agrAuditOrderDo, UocAuditOrderPO.class);
        uocAuditOrderMapper.insert(uocAuditOrderPO);
        if(!CollectionUtils.isEmpty(agrAuditOrderDo.getUocApprovalObj())){
            List<UocApprovalObjPO> uocApprovalObjPOS = new ArrayList<>();
            agrAuditOrderDo.getUocApprovalObj().forEach(uocApprovalObj -> {
                UocApprovalObjPO po = AgrRu.js(uocApprovalObj,UocApprovalObjPO.class);
                po.setAuditOrderId(agrAuditOrderDo.getAuditOrderId());
                po.setId(IdUtil.nextId());
                po.setOrderId(agrAuditOrderDo.getOrderId());
                po.setCreateTime(new Date());
                if (AgrCommConstant.AuditObjType.AGREEMENT_AUDIT.equals(uocApprovalObj.getObjBusiType())) {
                    // 协议新增审批
                    // 新增对象版本号
                    AgrMainPO agrMainPO = new AgrMainPO();
                    agrMainPO.setAgrId(agrAuditOrderDo.getOrderId());
                    AgrMainPO modelBy = agrMainMapper.getModelBy(agrMainPO);
                    if (ObjectUtil.isNull(modelBy)) {
                        log.error("协议审批单保存失败，协议不存在，协议ID：{}", agrAuditOrderDo.getOrderId());
                    } else {
                        po.setObjVersion(modelBy.getAgrVersion());
                    }
                }
                uocApprovalObjPOS.add(po);
            });
            uocApprovalObjMapper.insertBatch(uocApprovalObjPOS);
        }
    }

    @Override
    public AgrAuditOrderDo getAuditObj(AgrAuditOrderQryBo agrAuditOrderQryBo) {
        UocApprovalObjPO uocApprovalObjPO = AgrRu.js(agrAuditOrderQryBo,UocApprovalObjPO.class) ;
        List<UocApprovalObjPO> pos =  uocApprovalObjMapper.getList(uocApprovalObjPO);
        List<UocApprovalObj> uocApprovalObj = AgrRu.jsl(pos,UocApprovalObj.class);
        AgrAuditOrderDo agrAuditOrderDo = new AgrAuditOrderDo();
        agrAuditOrderDo.setUocApprovalObj(uocApprovalObj);
        return agrAuditOrderDo;
    }

    @Override
    public void updateAuditObjVersion(AgrAuditOrderDo param0) {
        List<UocApprovalObj> uocApprovalObj = param0.getUocApprovalObj();
        uocApprovalObj.forEach(e -> {
            UocApprovalObjPO where = new UocApprovalObjPO();
            where.setAuditOrderId(e.getAuditOrderId());
            where.setOrderId(param0.getOrderId());
            where.setObjId(e.getObjId());

            UocApprovalObjPO set = new UocApprovalObjPO();
            set.setObjVersion(e.getObjVersion());

            this.ucApprovalObjMapperUns.updateObjVersionIsNull(set, where);
        });
    }

    @Override
    public AgrGetAuditToDoInfoRspBO getAuditTodoInfo(AgrGetAuditToDoInfoReqBO reqBO) {
        AgrGetAuditToDoInfoRspBO rspBO = new AgrGetAuditToDoInfoRspBO();
        // 查询审批对象信息
        UocApprovalObjPO uocapprovalobjpo = new UocApprovalObjPO();
        uocapprovalobjpo.setAuditOrderId(reqBO.getObjId());
        uocapprovalobjpo.setOrderId(reqBO.getOrderId());
        UocApprovalObjPO approvalObjPO = this.uocApprovalObjMapper.getModelBy(uocapprovalobjpo);
        rspBO.setDataType(approvalObjPO.getObjType());
        if (AgrCommConstant.ObjType.AGREEMENT.equals(approvalObjPO.getObjType())) {
            rspBO.setAgrId(Long.valueOf(approvalObjPO.getObjId()));
        } else if (AgrCommConstant.ObjType.CHANGE.equals(approvalObjPO.getObjType())){
            rspBO.setChngApplyId(Long.valueOf(approvalObjPO.getObjId()));
            rspBO.setAgrId(approvalObjPO.getOrderId());
        }

        // 根据审批单id查询流程实例信息
        UocOrderProcInstPO uocorderprocinstpo = new UocOrderProcInstPO();
        uocorderprocinstpo.setObjId(reqBO.getObjId());
        uocorderprocinstpo.setOrderBy("create_time DESC limit 1");
        UocOrderProcInstPO procInstPO = this.uocOrderProcInstMapper.getModelBy(uocorderprocinstpo);
        rspBO.setProcInstId(procInstPO.getProcInstId());

        // 查询待办任务信息
        UocOrderTaskInstPO uocordertaskinstpo = new UocOrderTaskInstPO();
        uocordertaskinstpo.setProcInstId(procInstPO.getProcInstId());
        uocordertaskinstpo.setFinishTag(AgrCommConstant.PROC_TASK_FINISHED.NO_FINISHED);
        uocordertaskinstpo.setDealOperId(reqBO.getUserId());
        UocOrderTaskInstPO orderTaskInstPO = this.uocOrderTaskInstMapperUns.qryOrderTaskInst(uocordertaskinstpo);
        if (ObjectUtil.isNotNull(orderTaskInstPO)) {
            rspBO.setTaskId(orderTaskInstPO.getTaskInstId());
            rspBO.setTaskSignTag(orderTaskInstPO.getTaskSignTag());
        }
        return rspBO;
    }
}
