/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.agr.model.portion.AgrPortionDo;
import com.tydic.dyc.agr.model.portion.sub.AgrPortionAgr;
import com.tydic.dyc.agr.model.portion.sub.AgrPortionAgrInfo;
import com.tydic.dyc.agr.model.portion.sub.AgrPortionAgrInfoLog;
import com.tydic.dyc.agr.model.portion.sub.AgrPortionLog;
import com.tydic.dyc.agr.repository.AgrPortionRepository;
import com.tydic.dyc.agr.repository.dao.AgrPortionAgrInfoLogMapper;
import com.tydic.dyc.agr.repository.dao.AgrPortionAgrInfoMapper;
import com.tydic.dyc.agr.repository.dao.AgrPortionAgrMapper;
import com.tydic.dyc.agr.repository.dao.AgrPortionLogMapper;
import com.tydic.dyc.agr.repository.dao.AgrPortionMapper;
import com.tydic.dyc.agr.repository.po.AgrPortionAgrInfoLogPO;
import com.tydic.dyc.agr.repository.po.AgrPortionAgrInfoPO;
import com.tydic.dyc.agr.repository.po.AgrPortionAgrPO;
import com.tydic.dyc.agr.repository.po.AgrPortionLogPO;
import com.tydic.dyc.agr.repository.po.AgrPortionPO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.portion.bo.AgrGetPortionDetailReqBO;
import com.tydic.dyc.agr.service.portion.bo.AgrGetPortionDetailRspBO;
import com.tydic.dyc.agr.service.portion.bo.AgrGetPortionListReqBO;
import com.tydic.dyc.agr.service.portion.bo.AgrGetPortionListRspBO;
import com.tydic.dyc.agr.service.portion.bo.AgrPortionAgrBO;
import com.tydic.dyc.agr.service.portion.bo.AgrPortionAgrInfoBO;
import com.tydic.dyc.agr.service.portion.bo.AgrPortionBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrPortionRepositoryImpl
implements AgrPortionRepository {
    @Autowired
    private AgrPortionMapper agrPortionMapper;
    @Autowired
    private AgrPortionAgrMapper agrPortionAgrMapper;
    @Autowired
    private AgrPortionAgrInfoLogMapper agrPortionAgrInfoLogMapper;
    @Autowired
    private AgrPortionAgrInfoMapper agrPortionAgrInfoMapper;
    @Autowired
    private AgrPortionLogMapper agrPortionLogMapper;

    public void createPortion(AgrPortionDo agrPortionDo) {
        Date now = new Date();
        AgrPortionPO agrPortionPO = (AgrPortionPO)AgrRu.js((Object)agrPortionDo, AgrPortionPO.class);
        long portionId = IdUtil.nextId();
        agrPortionPO.setPortionId(IdUtil.nextId());
        agrPortionPO.setCreateTime(now);
        agrPortionPO.setPortionStatus("\u5ba1\u6279\u4e2d");
        this.agrPortionMapper.insert(agrPortionPO);
        ArrayList<AgrPortionAgrPO> agrPortionAgrPOS = new ArrayList<AgrPortionAgrPO>(agrPortionDo.getAgrList().size());
        for (AgrPortionAgr agrPortionAgr : agrPortionDo.getAgrList()) {
            AgrPortionAgrPO agrPortionAgrPO = (AgrPortionAgrPO)AgrRu.js((Object)agrPortionAgr, AgrPortionAgrPO.class);
            agrPortionAgrPO.setPortionId(portionId);
            agrPortionAgrPO.setId(IdUtil.nextId());
            agrPortionAgrPOS.add(agrPortionAgrPO);
        }
        this.agrPortionAgrMapper.insetBatch(agrPortionAgrPOS);
        ArrayList<AgrPortionAgrInfoPO> agrPortionAgrInfoPOS = new ArrayList<AgrPortionAgrInfoPO>(agrPortionDo.getAgrInfoList().size());
        for (AgrPortionAgrInfo agrPortionAgrInfo : agrPortionDo.getAgrInfoList()) {
            AgrPortionAgrInfoPO addressAgrInfoPO = (AgrPortionAgrInfoPO)AgrRu.js((Object)agrPortionAgrInfo, AgrPortionAgrInfoPO.class);
            addressAgrInfoPO.setId(IdUtil.nextId());
            addressAgrInfoPO.setPortionNa(JSONObject.toJSONString((Object)agrPortionAgrInfo.getPortionNaList()));
            addressAgrInfoPO.setPortionId(portionId);
            agrPortionAgrInfoPOS.add(addressAgrInfoPO);
        }
        this.agrPortionAgrInfoMapper.insertBatch(agrPortionAgrInfoPOS);
    }

    public void adjustPortion(AgrPortionDo agrPortionDo) {
        AgrPortionAgrInfoPO agrPortionAgrInfoPO = new AgrPortionAgrInfoPO();
        agrPortionAgrInfoPO.setPortionId(agrPortionDo.getPortionId());
        List<AgrPortionAgrInfoPO> list = this.agrPortionAgrInfoMapper.getList(agrPortionAgrInfoPO);
        for (AgrPortionAgrInfo agrPortionAgrInfo : agrPortionDo.getAgrInfoList()) {
            AgrPortionAgrInfoPO set = (AgrPortionAgrInfoPO)AgrRu.js((Object)agrPortionAgrInfo, AgrPortionAgrInfoPO.class);
            if (!CollectionUtils.isEmpty((Collection)agrPortionAgrInfo.getPortionNaList())) {
                set.setPortionNa(JSONObject.toJSONString((Object)agrPortionAgrInfo.getPortionNaList()));
            }
            AgrPortionAgrInfoPO where = new AgrPortionAgrInfoPO();
            where.setId(agrPortionAgrInfoPO.getId());
            this.agrPortionAgrInfoMapper.updateBy(set, where);
        }
        long logId = IdUtil.nextId();
        Date now = new Date();
        ArrayList<AgrPortionAgrInfoLogPO> agrPortionAgrInfoLogPOS = new ArrayList<AgrPortionAgrInfoLogPO>();
        Map<Long, AgrPortionAgrInfo> agrPortionAgrInfoMap = agrPortionDo.getAgrInfoList().stream().collect(Collectors.toMap(AgrPortionAgrInfo::getId, o -> o));
        for (AgrPortionAgrInfoPO po : list) {
            AgrPortionAgrInfo agrPortionAgrInfo = agrPortionAgrInfoMap.get(po.getId());
            if (agrPortionAgrInfo == null) continue;
            AgrPortionAgrInfoLogPO agrPortionAgrInfoLogPO = (AgrPortionAgrInfoLogPO)AgrRu.js((Object)po, AgrPortionAgrInfoLogPO.class);
            agrPortionAgrInfoLogPO.setLogId(logId);
            agrPortionAgrInfoLogPO.setId(IdUtil.nextId());
            agrPortionAgrInfoLogPO.setCategoryIdAfter(agrPortionAgrInfo.getCategoryId());
            agrPortionAgrInfoLogPO.setCategoryName(agrPortionAgrInfo.getCategoryName());
            if (!CollectionUtil.isEmpty((Collection)agrPortionAgrInfo.getPortionNaList())) {
                agrPortionAgrInfoLogPO.setPortionNaAfter(agrPortionAgrInfo.getPortionNa());
            }
            agrPortionAgrInfoLogPO.setPortionTypeAfter(agrPortionAgrInfo.getPortionType());
            agrPortionAgrInfoLogPO.setPortionVeldooAfter(agrPortionAgrInfo.getPortionVeldoo());
            agrPortionAgrInfoLogPOS.add(agrPortionAgrInfoLogPO);
        }
        if (!CollectionUtil.isEmpty(agrPortionAgrInfoLogPOS)) {
            this.agrPortionAgrInfoLogMapper.insertBatch(agrPortionAgrInfoLogPOS);
            AgrPortionLogPO agrPortionLogPO = new AgrPortionLogPO();
            agrPortionLogPO.setPortionId(agrPortionDo.getPortionId());
            agrPortionLogPO.setLogId(logId);
            agrPortionLogPO.setAdjustType(agrPortionDo.getAdjustType());
            agrPortionLogPO.setCreateOperId(agrPortionDo.getCreateOperId());
            agrPortionLogPO.setCreateOperName(agrPortionDo.getCreateOperName());
            agrPortionLogPO.setCreateTime(now);
            this.agrPortionLogMapper.insert(agrPortionLogPO);
        }
        AgrPortionPO adpPortionPO = new AgrPortionPO();
        adpPortionPO.setPortionId(agrPortionDo.getPortionId());
        adpPortionPO.setUpdateOperId(agrPortionDo.getCreateOperId());
        adpPortionPO.setUpdateOperName(agrPortionDo.getCreateOperName());
        adpPortionPO.setUpdateTime(now);
        this.agrPortionMapper.updateByPrimaryKeySelective(adpPortionPO);
    }

    public AgrGetPortionListRspBO getAgrPortionList(AgrGetPortionListReqBO reqBO) {
        AgrGetPortionListRspBO rspBO = new AgrGetPortionListRspBO();
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setPageNo(reqBO.getPageNo().intValue());
        List<AgrPortionPO> portionList = this.agrPortionMapper.getPortionListPage(reqBO, page);
        if (CollectionUtil.isEmpty(portionList)) {
            return rspBO;
        }
        List<Long> portionIdList = portionList.stream().map(AgrPortionPO::getPortionId).collect(Collectors.toList());
        List agrPortionBOS = JUtil.jsl(portionList, AgrPortionBO.class);
        AgrPortionAgrPO agrPortionAgrPO = new AgrPortionAgrPO();
        agrPortionAgrPO.setPortionIdList(portionIdList);
        List<AgrPortionAgrPO> agrInfoList = this.agrPortionAgrMapper.getList(agrPortionAgrPO);
        if (CollectionUtil.isNotEmpty(agrInfoList)) {
            Map<Long, Long> portionIdAndCount = agrInfoList.stream().collect(Collectors.groupingBy(AgrPortionAgrPO::getPortionId, Collectors.counting()));
            agrPortionBOS.forEach(e -> e.setRelAgrNum(Integer.valueOf(((Long)portionIdAndCount.get(e.getPortionId())).intValue())));
        }
        AgrPortionAgrInfoPO agrPortionAgrInfoPO = new AgrPortionAgrInfoPO();
        agrPortionAgrInfoPO.setPortionIdList(portionIdList);
        List<AgrPortionAgrInfoPO> agrInfoPOList = this.agrPortionAgrInfoMapper.getList(agrPortionAgrInfoPO);
        if (CollectionUtil.isNotEmpty(agrInfoPOList)) {
            Map<Long, List<AgrPortionAgrInfoPO>> porIdAndPurList = agrInfoPOList.stream().collect(Collectors.groupingBy(AgrPortionAgrInfoPO::getPortionId));
            agrPortionBOS.forEach(e -> {
                List agrPortionAgrInfoPOS = (List)porIdAndPurList.get(e.getPortionId());
                Integer portionType = ((AgrPortionAgrInfoPO)agrPortionAgrInfoPOS.get(0)).getPortionType();
                e.setPortionType(((AgrPortionAgrInfoPO)agrPortionAgrInfoPOS.get(0)).getPortionType());
                e.setPortionTypeStr(AgrCommConstant.PortionTypeEum.valueByCode((Integer)portionType).getValue());
                e.setPurIdList(agrPortionAgrInfoPOS.stream().map(AgrPortionAgrInfoPO::getPurId).collect(Collectors.toList()));
            });
        } else {
            agrPortionBOS.forEach(e -> {
                e.setPortionType(AgrCommConstant.PortionTypeEum.OK.getCode());
                e.setPortionTypeStr(AgrCommConstant.PortionTypeEum.OK.getValue());
            });
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setRows(agrPortionBOS);
        return rspBO;
    }

    public AgrGetPortionDetailRspBO getPortionDetail(AgrGetPortionDetailReqBO reqBO) {
        AgrPortionPO agrPortionPO = new AgrPortionPO();
        agrPortionPO.setPortionId(reqBO.getPortionId());
        AgrPortionPO modelBy = this.agrPortionMapper.getModelBy(agrPortionPO);
        AgrGetPortionDetailRspBO rspBO = (AgrGetPortionDetailRspBO)JUtil.js((Object)modelBy, AgrGetPortionDetailRspBO.class);
        AgrPortionAgrPO agrPortionAgrPO = new AgrPortionAgrPO();
        agrPortionAgrPO.setPortionId(reqBO.getPortionId());
        List<AgrPortionAgrPO> agrPortionAgrPOS = this.agrPortionAgrMapper.getList(agrPortionAgrPO);
        rspBO.setAgrList(JUtil.jsl(agrPortionAgrPOS, AgrPortionAgrBO.class));
        AgrPortionAgrInfoPO agrPortionAgrInfoPO = new AgrPortionAgrInfoPO();
        agrPortionAgrInfoPO.setPortionId(reqBO.getPortionId());
        List<AgrPortionAgrInfoPO> agrInfoPOList = this.agrPortionAgrInfoMapper.getList(agrPortionAgrInfoPO);
        rspBO.setAgrInfoList(JUtil.jsl(agrInfoPOList, AgrPortionAgrInfoBO.class));
        return rspBO;
    }

    public List<AgrPortionLog> getAgrPortionLogPageList(AgrPortionLog agrPortionLog, Page<AgrPortionLog> page) {
        AgrPortionLogPO agrPortionLogPO = new AgrPortionLogPO();
        agrPortionLogPO.setPortionId(agrPortionLog.getPortionId());
        Page agrPortionLogPOPage = new Page();
        agrPortionLogPOPage.setPageSize(page.getPageSize());
        agrPortionLogPOPage.setPageNo(page.getPageNo());
        List<AgrPortionLogPO> pageList = this.agrPortionLogMapper.getPageList(agrPortionLogPO, (Page<AgrPortionLogPO>)agrPortionLogPOPage);
        page.setResult(AgrRu.jsl((List)agrPortionLogPOPage.getResult(), AgrPortionLog.class));
        page.setTotalPages(agrPortionLogPOPage.getTotalPages());
        page.setTotalCount(agrPortionLogPOPage.getTotalCount());
        return page.getResult();
    }

    public List<AgrPortionAgrInfoLog> getAgrPortionAgrInfoList(AgrPortionAgrInfoLog agrPortionAgrInfo) {
        AgrPortionAgrInfoLogPO agrPortionAgrInfoLogPO = (AgrPortionAgrInfoLogPO)AgrRu.js((Object)agrPortionAgrInfo, AgrPortionAgrInfoLogPO.class);
        List<AgrPortionAgrInfoLogPO> list = this.agrPortionAgrInfoLogMapper.getList(agrPortionAgrInfoLogPO);
        return AgrRu.jsl(list, AgrPortionAgrInfoLog.class);
    }
}

