/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.repository.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.agr.model.sysDicDictionary.SysDicDictionaryDo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.AgrDictionaryRspBo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.DicDictionaryBo;
import com.tydic.dyc.agr.model.sysDicDictionary.qrybo.SysDicDictionaryRspBo;
import com.tydic.dyc.agr.repository.AgrDictionaryRepository;
import com.tydic.dyc.agr.repository.dao.DictionaryMapperUns;
import com.tydic.dyc.agr.repository.dao.SysDicDictionaryMapper;
import com.tydic.dyc.agr.repository.po.DicDictionaryPO;
import com.tydic.dyc.agr.repository.po.SysDicDictionaryPo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AgrDictionaryRepositoryImpl
implements AgrDictionaryRepository {
    @Autowired
    private DictionaryMapperUns dictionaryMapperUns;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    private static final Integer DIC_ORDER_ID = 1;
    private static final String SYS_CODE_DEFAULT = "AGR";

    public List<DicDictionaryBo> selectByPCodeList(List<String> pCodeList) {
        List<Object> dicDictionaryBoList = new ArrayList<DicDictionaryBo>();
        if (CollectionUtil.isNotEmpty(pCodeList)) {
            List<DicDictionaryPO> dictionaryPOList = this.dictionaryMapperUns.selectByPCodeList(pCodeList.stream().distinct().collect(Collectors.toList()));
            dicDictionaryBoList = AgrRu.jsl(dictionaryPOList, DicDictionaryBo.class);
        }
        return dicDictionaryBoList;
    }

    public SysDicDictionaryDo getDictionaryByDo(SysDicDictionaryDo dicDictionaryDo) {
        SysDicDictionaryDo dictionaryDo = new SysDicDictionaryDo();
        SysDicDictionaryPo dictionaryPo = new SysDicDictionaryPo();
        BeanUtils.copyProperties((Object)dicDictionaryDo, (Object)dictionaryPo);
        SysDicDictionaryPo sysDicDictionaryPo = this.sysDicDictionaryMapper.getModelBy(dictionaryPo);
        if (null != sysDicDictionaryPo) {
            BeanUtils.copyProperties((Object)sysDicDictionaryPo, (Object)dictionaryDo);
        }
        return dictionaryDo;
    }

    public void addDicDictionary(SysDicDictionaryDo sysDicDictionaryDo) {
        if (StringUtils.isEmpty((Object)sysDicDictionaryDo.getSysCode())) {
            sysDicDictionaryDo.setSysCode(SYS_CODE_DEFAULT);
        }
        SysDicDictionaryPo sysDicDictionaryPo = new SysDicDictionaryPo();
        sysDicDictionaryPo.setTitle(sysDicDictionaryDo.getTitle());
        sysDicDictionaryPo.setOrderId(DIC_ORDER_ID);
        sysDicDictionaryPo.setDescrip(sysDicDictionaryDo.getDescrip());
        sysDicDictionaryPo.setDelFlag(AgrCommConstant.IsDelete.NORMAL);
        sysDicDictionaryPo.setSysCode(sysDicDictionaryDo.getSysCode());
        sysDicDictionaryPo.setCode(sysDicDictionaryDo.getCode());
        sysDicDictionaryPo.setPCode(sysDicDictionaryDo.getPCode());
        this.sysDicDictionaryMapper.insert(sysDicDictionaryPo);
    }

    public void deleteDicDictionary(SysDicDictionaryDo dicDictionaryBO) {
        SysDicDictionaryPo dicDictionaryModel = new SysDicDictionaryPo();
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        this.sysDicDictionaryMapper.deleteByCondition(dicDictionaryModel);
    }

    public AgrDictionaryRspBo queryBypCodeBackMap(SysDicDictionaryDo sysDicDictionaryDo) {
        List<SysDicDictionaryPo> listPo = this.sysDicDictionaryMapper.getList(this.getDicDictionaryPO(sysDicDictionaryDo.getSysCode(), sysDicDictionaryDo.getPCode()));
        AgrDictionaryRspBo umcDictionaryRspBo = new AgrDictionaryRspBo();
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(listPo)) {
            for (SysDicDictionaryPo po : listPo) {
                map.put(po.getCode(), po.getTitle());
            }
        }
        umcDictionaryRspBo.setMap(map);
        return umcDictionaryRspBo;
    }

    public SysDicDictionaryRspBo queryBypCodeBackPo(SysDicDictionaryDo dicDictionaryDo) {
        SysDicDictionaryPo js = (SysDicDictionaryPo)AgrRu.js((Object)dicDictionaryDo, SysDicDictionaryPo.class);
        if (StringUtils.isEmpty((Object)js.getOrderBy())) {
            js.setOrderBy("ORDER_ID Asc");
        }
        List<SysDicDictionaryPo> list = this.sysDicDictionaryMapper.getList(js);
        List sysDicDictionaryDoList = AgrRu.jsl(list, SysDicDictionaryDo.class);
        SysDicDictionaryRspBo sysDicDictionaryRspBo = new SysDicDictionaryRspBo();
        sysDicDictionaryRspBo.setRows(sysDicDictionaryDoList);
        return sysDicDictionaryRspBo;
    }

    public void updateDicDictionary(SysDicDictionaryDo dicDictionaryBO) {
        SysDicDictionaryPo dicDictionaryModel = new SysDicDictionaryPo();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelFlag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        this.sysDicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    public SysDicDictionaryPo getDicDictionaryPO(String sysCode, String pCode) {
        SysDicDictionaryPo queryDictionaryPO = new SysDicDictionaryPo();
        queryDictionaryPO.setPCode(pCode);
        if (StringUtils.isEmpty((Object)sysCode)) {
            sysCode = SYS_CODE_DEFAULT;
        }
        queryDictionaryPO.setSysCode(sysCode);
        return queryDictionaryPO;
    }
}

