/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.agreement.ability.AgrFileTemplateDownloadAbilityService;
import com.tydic.agreement.ability.AgrFileUploadAbilityService;
import com.tydic.agreement.ability.bo.AgrFileTemplateDownloadAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrFileTemplateDownloadAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrFileUploadAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrFileUploadAbilityRspBO;
import java.io.ByteArrayInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/agr/ossUpload"})
public class AgrFileUpAndDownController {
    private static final Logger log = LoggerFactory.getLogger(AgrFileUpAndDownController.class);
    @Autowired
    private AgrFileUploadAbilityService agrFileUploadAbilityService;
    @Value(value="${oss.accessUrl}")
    public String accessUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private AgrFileTemplateDownloadAbilityService agrFileTemplateDownloadAbilityService;

    @PostMapping(value={"/uploadFile"})
    public AgrFileUploadAbilityRspBO approvalAgreementAdd(@RequestParam(value="file") MultipartFile file, @RequestParam(value="fileUploadPath") String fileUploadPath) {
        AgrFileUploadAbilityReqBO agrFileUploadAbilityReqBO = new AgrFileUploadAbilityReqBO();
        try {
            byte[] b = file.getBytes();
            ByteArrayInputStream input = new ByteArrayInputStream(b);
            agrFileUploadAbilityReqBO.setInput(input);
            agrFileUploadAbilityReqBO.setFileName(file.getOriginalFilename());
        }
        catch (Exception b) {
            // empty catch block
        }
        AgrFileUploadAbilityRspBO abilityRspBO = this.agrFileUploadAbilityService.uploadFile(agrFileUploadAbilityReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u6587\u4ef6\u4e0a\u4f20Rest\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)abilityRspBO));
        }
        return abilityRspBO;
    }

    @PostMapping(value={"/downloadFileTemplate"})
    public AgrFileTemplateDownloadAbilityRspBO downloadFileTemplate(@RequestBody AgrFileTemplateDownloadAbilityReqBO abilityReqBO) {
        return this.agrFileTemplateDownloadAbilityService.downloadFileTemplate(abilityReqBO);
    }
}

