/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityRspBO;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.busicommon.commodity.api.DycUccSkuListBatchEditCacheService;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSkuListBatchEditCacheServiceReqBo;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSkuListBatchEditCacheServiceRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.commodity.api.DycUccSkuListBatchEditCacheService"})
public class DycUccSkuListBatchEditCacheServiceImpl
implements DycUccSkuListBatchEditCacheService {
    private static final Logger log = LoggerFactory.getLogger(DycUccSkuListBatchEditCacheServiceImpl.class);
    @Autowired
    private UccSkuListQryAbilityService uccSkuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;
    @Value(value="${ucc.skuIdQueryMaxPageSize:20000}")
    private Integer skuIdQueryMaxPageSize;

    @PostMapping(value={"generateSkuBatchEditCache"})
    public DycUccSkuListBatchEditCacheServiceRspBo generateSkuBatchEditCache(@RequestBody DycUccSkuListBatchEditCacheServiceReqBo reqBo) {
        String strReq = JSONObject.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccSkuListQryAbilityReqBO abilityReqBO = (UccSkuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccSkuListQryAbilityReqBO.class);
        this.setReqAuth(reqBo, strReq, abilityReqBO);
        abilityReqBO.setPageSize(this.skuIdQueryMaxPageSize.intValue());
        abilityReqBO.setQuerySkuIdOnly(Boolean.valueOf(true));
        UccSkuListQryAbilityRspBO abilityRspBO = this.uccSkuListQryAbilityService.getSkuListQry(abilityReqBO);
        DycUccSkuListBatchEditCacheServiceRspBo rspBO = new DycUccSkuListBatchEditCacheServiceRspBo();
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        String rspStr = JSONObject.toJSONString((Object)abilityRspBO);
        rspBO = (DycUccSkuListBatchEditCacheServiceRspBo)JSONObject.parseObject((String)rspStr, DycUccSkuListBatchEditCacheServiceRspBo.class);
        rspBO.setRedisCommodityIdCacheKey(abilityRspBO.getRedisCommodityIdCacheKey());
        rspBO.setCode("0");
        rspBO.setMessage("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private void setReqAuth(DycUccSkuListBatchEditCacheServiceReqBo reqBO, String strReq, UccSkuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            if (reqBO.getLoginTagIn().equals("0")) {
                abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
                abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
                abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
                abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
                abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
                abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
            }
            if (authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
                abilityReqBO.setCreateOperId(reqBO.getUserId() + "");
            }
        }
    }
}

