/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.busicommon.commodity.api.DycUccSkuListQryService;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSkuListQryBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSkuListQryReqBO;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSkuListQryRspBO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.commodity.api.DycUccSkuListQryService"})
public class DycUccSkuListQryServiceImpl
implements DycUccSkuListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUccSkuListQryServiceImpl.class);
    @Autowired
    private UccSkuListQryAbilityService uccSkuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;

    @PostMapping(value={"getSkuListQry"})
    public DycUccSkuListQryRspBO getSkuListQry(@RequestBody DycUccSkuListQryReqBO reqBO) {
        String strReq = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccSkuListQryAbilityReqBO abilityReqBO = (UccSkuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccSkuListQryAbilityReqBO.class);
        this.setReqAuth(reqBO, strReq, abilityReqBO);
        UccSkuListQryAbilityRspBO abilityRspBO = this.uccSkuListQryAbilityService.getSkuListQry(abilityReqBO);
        DycUccSkuListQryRspBO rspBO = new DycUccSkuListQryRspBO();
        if ("0000".equals(abilityRspBO.getRespCode())) {
            String rspStr = JSONObject.toJSONString((Object)abilityRspBO);
            rspBO = (DycUccSkuListQryRspBO)JSONObject.parseObject((String)rspStr, DycUccSkuListQryRspBO.class);
            if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                List result = JSONObject.parseArray((String)JSONObject.toJSONString((Object)abilityRspBO.getRows()), UccSkuManagementListQryBO.class);
                Map mapList = result.stream().collect(Collectors.toMap(UccSkuManagementListQryBO::getSkuId, Function.identity()));
                for (DycUccSkuListQryBO each : rspBO.getRows()) {
                    if (!mapList.containsKey(each.getSkuId())) continue;
                    each.setSkuApprovalStatus(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getApprovalStatus());
                    each.setSkuApprovalStatusDesc(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getApprovalStatusDesc());
                }
            }
        } else {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        return rspBO;
    }

    private void setReqSkuStatus(DycUccSkuListQryReqBO reqBO, UccSkuListQryAbilityReqBO abilityReqBO) {
        if (null != reqBO.getTabId()) {
            switch (reqBO.getTabId()) {
                case 0: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_DRAFT, SkuStatusConstants.SKU_STATUS_EDIT_AUDITING, SkuStatusConstants.SKU_STATUS_EDIT_AUDIT_REJECT));
                    break;
                }
                case 1: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_WAIT_SHELF, SkuStatusConstants.SKU_STATUS_PUT_ON_AUDITING, SkuStatusConstants.SKU_STATUS_PUT_ON_AUDIT_REJECT));
                    break;
                }
                case 2: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_ON_SHELF, SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDIT_REJECT));
                    break;
                }
                case 3: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_ECCOM_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_FORCE_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_WARING_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDITING, SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDIT_REJECT));
                    break;
                }
                case 4: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_FREEZE, SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDITING));
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_WAIT_ON_GOVERN));
                    break;
                }
                case 7: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_TO_REL));
                    break;
                }
            }
        }
    }

    private void setReqAuth(DycUccSkuListQryReqBO reqBO, String strReq, UccSkuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            if (reqBO.getLoginTagIn().equals("0")) {
                abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
                abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
                abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
                abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
                abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
                abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
            }
            if (authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
                abilityReqBO.setCreateOperId(reqBO.getUserId() + "");
            }
        }
    }
}

