/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.common.ability.api.UccSpuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityRspBO;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.busicommon.commodity.api.DycUccSpuListBatchEditCacheService;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListBatchEditCacheServiceReqBo;
import com.tydic.dyc.busicommon.commodity.bo.DycUccSpuListBatchEditCacheServiceRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.commodity.api.DycUccSpuListBatchEditCacheService"})
public class DycUccSpuListBatchEditCacheServiceImpl
implements DycUccSpuListBatchEditCacheService {
    private static final Logger log = LoggerFactory.getLogger(DycUccSpuListBatchEditCacheServiceImpl.class);
    @Autowired
    private UccSpuListQryAbilityService uccSpuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;
    @Value(value="${ucc.commodityIdQueryMaxPageSize:20000}")
    private Integer commodityIdQueryMaxPageSize;

    @PostMapping(value={"generateCacheSpuBatchEdit"})
    public DycUccSpuListBatchEditCacheServiceRspBo generateCacheSpuBatchEdit(@RequestBody DycUccSpuListBatchEditCacheServiceReqBo reqBo) {
        String strReq = JSONObject.toJSONString((Object)reqBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccSpuListQryAbilityReqBO abilityReqBO = (UccSpuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccSpuListQryAbilityReqBO.class);
        this.setReqAuth(reqBo, strReq, abilityReqBO);
        abilityReqBO.setPageSize(this.commodityIdQueryMaxPageSize.intValue());
        abilityReqBO.setQueryCommodityIdOnly(Boolean.valueOf(true));
        UccSpuListQryAbilityRspBO abilityRspBO = this.uccSpuListQryAbilityService.getSpuListQry(abilityReqBO);
        DycUccSpuListBatchEditCacheServiceRspBo rspBO = new DycUccSpuListBatchEditCacheServiceRspBo();
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        rspBO.setRedisCommodityIdCacheKey(abilityRspBO.getRedisCommodityIdCacheKey());
        rspBO.setCode("0");
        rspBO.setMessage("\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    private void setReqAuth(DycUccSpuListBatchEditCacheServiceReqBo reqBO, String strReq, UccSpuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            if (reqBO.getLoginTagIn().equals("0")) {
                abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
                abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
                abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
                abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
                abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
                abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
            }
            if (authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
                abilityReqBO.setCreateOperId(reqBO.getUserId() + "");
            }
        }
    }
}

