/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.controller;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.common.communal.bo.ComUocFileAppBO;
import com.tydic.dyc.common.communal.bo.ComUocFileUploadAppReqBO;
import com.tydic.dyc.common.communal.bo.ComUocFileUploadAppRspBO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dyc/common/communal"})
public class ComUocFileUpLoadController {
    private static final Logger log = LoggerFactory.getLogger(ComUocFileUpLoadController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ComUocFileUpLoadController.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${upload.uploadTime:3}")
    private Integer uploadTime;
    private static final String REDIS_KEY_PREFIX = "UPLOAD_FILE_PREFIX_";
    @Value(value="${upload.uploadMsg:\u8bf7\u63a7\u5236\u6587\u4ef6\u4e0a\u4f20\u65f6\u95f4\u95f4\u9694}")
    private String uploadMsg;

    @PostMapping(value={"/noauth/fileGeneration/upload"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO uploadByNoauth(MultipartFile[] files) {
        return this.upload(files, null);
    }

    @PostMapping(value={"/fileGeneration/upload"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO upload(@RequestParam(value="files") MultipartFile[] files, Long userId) {
        Object o;
        if (files == null || files.length == 0) {
            log.info("\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return null;
        }
        if (userId != null && userId > 0L && (o = this.cacheClient.get(REDIS_KEY_PREFIX + userId)) != null) {
            ComUocFileUploadAppRspBO rspBo = new ComUocFileUploadAppRspBO();
            rspBo.setCode("1");
            rspBo.setMessage(this.uploadMsg);
            return rspBo;
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        for (MultipartFile file : files) {
            InputStream inputStream = null;
            try {
                inputStream = file.getInputStream();
                String fileName = file.getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
                comUocFileAppBO.setFile(bytes);
                comUocFileAppBO.setFileName(fileName);
                comUocFileAppBO.setFileType(suffix);
                list.add(comUocFileAppBO);
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
                }
            }
        }
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        if (ObjectUtil.isNotEmpty((Object)userId)) {
            this.cacheClient.set(REDIS_KEY_PREFIX + userId, (Object)userId, this.uploadTime.intValue());
        }
        return this.upload(reqBO);
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
            String fileName = file.getFileName();
            String path = this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, (InputStream)inputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            map.put("innerUrl", innerFileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        return rspBO;
    }
}

