/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.user.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.authority.busi.api.AddMenuCatalogBusiService;
import com.tydic.authority.busi.api.AddSublevelMenuBusiService;
import com.tydic.authority.busi.api.ChangeMenuOrderDownBusiService;
import com.tydic.authority.busi.api.ChangeMenuOrderUpBusiService;
import com.tydic.authority.busi.api.ChangeMenuStatusBusiService;
import com.tydic.authority.busi.api.DeleteMenuBusiService;
import com.tydic.authority.busi.api.SaveMenusByOrgTreePathBusiService;
import com.tydic.authority.busi.api.SelMenuTreeToManagerBusiService;
import com.tydic.authority.busi.api.SelectAllMenuTreeBusiService;
import com.tydic.authority.busi.api.SelectDetailByMenuIdBusiService;
import com.tydic.authority.busi.api.SelectMenuByPIdBusiService;
import com.tydic.authority.busi.api.SelectMenuCatalogBusiService;
import com.tydic.authority.busi.api.SelectMenuCatalogTreeBusiService;
import com.tydic.authority.busi.api.SelectMenuTreeByOrgBusiService;
import com.tydic.authority.busi.api.SelectMenuTreeByUserBusiService;
import com.tydic.authority.busi.api.SelectMgrMenuTreeBusiService;
import com.tydic.authority.busi.api.UpdateByMenuIdBusiService;
import com.tydic.authority.busi.bo.AddMenuCatalogReqBO;
import com.tydic.authority.busi.bo.AddSublevelMenuReqBO;
import com.tydic.authority.busi.bo.ChangeMenuOrderReqBO;
import com.tydic.authority.busi.bo.ChangeMenuStatusReqBO;
import com.tydic.authority.busi.bo.DeleteMenuReqBO;
import com.tydic.authority.busi.bo.SaveMenusByOrgTreePathReqBO;
import com.tydic.authority.busi.bo.SelMenuTreeToManagerReqBO;
import com.tydic.authority.busi.bo.SelectDetailByMenuIdReqBO;
import com.tydic.authority.busi.bo.SelectDetailByMenuIdRspBO;
import com.tydic.authority.busi.bo.SelectMenuByPIdReqBO;
import com.tydic.authority.busi.bo.SelectMenuCatalogTreeReqBO;
import com.tydic.authority.busi.bo.SelectMenuTreeByOrgReqBO;
import com.tydic.authority.busi.bo.SelectMenuTreeByOrgRspBO;
import com.tydic.authority.busi.bo.SelectMenuTreeReqBO;
import com.tydic.authority.busi.bo.UpdateByMenuIdReqBO;
import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.common.user.bo.DycUpdateByMenuIdReqBO;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dyc/common/user/author/menu"}, method={RequestMethod.GET, RequestMethod.POST})
public class MenuController {
    private static final Logger log = LoggerFactory.getLogger(MenuController.class);
    public static final String SYSTEM_ADMIN_CODE = "auth:system:manage";
    public static final String TENANT_ADMIN_CODE = "auth:tenant:manage";
    public static final String ORG_ADMIN_CODE = "auth:org:manage";
    public static final String ORG_INNER_ADMIN_CODE = "auth:innerorg:manage";
    public static final String ORG_EXT_ADMIN_CODE = "auth:extorg:manage";
    @Autowired
    private SelectMenuCatalogBusiService selectMenuCatalogBusiService;
    @Autowired
    private AddMenuCatalogBusiService addMenuCatalogBusiService;
    @Autowired
    private SelectDetailByMenuIdBusiService selectDetailByMenuIdBusiService;
    @Autowired
    private SelectMenuByPIdBusiService selectMenuByPIdBusiService;
    @Autowired
    private AddSublevelMenuBusiService addSublevelMenuBusiService;
    @Autowired
    private UpdateByMenuIdBusiService updateByMenuIdBusiService;
    @Autowired
    private ChangeMenuStatusBusiService changeMenuStatusBusiService;
    @Autowired
    private SelectAllMenuTreeBusiService selectAllMenuTreeBusiService;
    @Autowired
    private SelectMgrMenuTreeBusiService selectMgrMenuTreeBusiService;
    @Autowired
    private SelMenuTreeToManagerBusiService selMenuTreeToManagerBusiService;
    @Autowired
    private DeleteMenuBusiService deleteMenuBusiService;
    @Autowired
    private ChangeMenuOrderUpBusiService changeMenuOrderUpBusiService;
    @Autowired
    private ChangeMenuOrderDownBusiService changeMenuOrderDownBusiService;
    @Autowired
    private SelectMenuTreeByOrgBusiService selectMenuTreeByOrgBusiService;
    @Autowired
    private SaveMenusByOrgTreePathBusiService saveMenusByOrgTreePathBusiService;
    @Autowired
    private SelectMenuTreeByUserBusiService selectMenuTreeByUserBusiService;
    @Autowired
    private SelectMenuCatalogTreeBusiService selectMenuCatalogTreeBusiService;

    @RequestMapping(value={"/addCatalog"})
    @JsonBusiResponseBody
    public Object addCatalog(@RequestBody AddMenuCatalogReqBO addMenuCatalogReqBO) {
        if (StringUtils.isEmpty((CharSequence)addMenuCatalogReqBO.getExtApplicationCode())) {
            addMenuCatalogReqBO.setExtApplicationCode(null);
        }
        this.addMenuCatalogBusiService.addMenuCatalog(addMenuCatalogReqBO);
        return null;
    }

    @RequestMapping(value={"/selectByMenuId"})
    @JsonBusiResponseBody
    public Object selectByMenuId(@RequestBody SelectDetailByMenuIdReqBO selectDetailByMenuIdReqBO) {
        return this.selectDetailByMenuIdBusiService.selectDetailByMenuId(selectDetailByMenuIdReqBO);
    }

    @RequestMapping(value={"/addSublevelMenu"})
    @JsonBusiResponseBody
    public Object addSublevelMenu(@RequestBody AddSublevelMenuReqBO addSublevelMenuReqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)SYSTEM_ADMIN_CODE)) {
            this.addSublevelMenuBusiService.addSublevelMenu(addSublevelMenuReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/update"})
    @JsonBusiResponseBody
    public Object update(@RequestBody UpdateByMenuIdReqBO updateByMenuIdReqBO) {
        try {
            SelectDetailByMenuIdReqBO reqBO = new SelectDetailByMenuIdReqBO();
            reqBO.setMenuId(updateByMenuIdReqBO.getMenuId());
            SelectDetailByMenuIdRspBO selectDetailByMenuIdRspBO = this.selectDetailByMenuIdBusiService.selectDetailByMenuId(reqBO);
        }
        catch (Exception e) {
            log.error("\u7f16\u8f91", (Throwable)e);
        }
        if (null == updateByMenuIdReqBO.getParentId() || updateByMenuIdReqBO.getParentId() == 0L) {
            updateByMenuIdReqBO.setParentId(null);
        }
        this.updateByMenuIdBusiService.updateByMenuId(updateByMenuIdReqBO);
        return null;
    }

    @RequestMapping(value={"/updateSingleMenu"})
    @JsonBusiResponseBody
    public Object updateSingleMenu(@RequestBody DycUpdateByMenuIdReqBO dycUpdateByMenuIdReqBO) {
        this.updateByMenuIdBusiService.updateByMenuId((UpdateByMenuIdReqBO)JSON.parseObject((String)JSON.toJSONString((Object)dycUpdateByMenuIdReqBO), UpdateByMenuIdReqBO.class));
        return null;
    }

    @RequestMapping(value={"/changeStatus"})
    @JsonBusiResponseBody
    public Object changeStatus(@RequestBody ChangeMenuStatusReqBO changeMenuStatusReqBO) {
        this.changeMenuStatusBusiService.changeMenuStatus(changeMenuStatusReqBO);
        return null;
    }

    @RequestMapping(value={"/selMenusByUser"})
    @BusiResponseBody
    public Object selectMenusByUser(@RequestBody SelectMenuTreeReqBO userMenusReqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)SYSTEM_ADMIN_CODE)) {
            return this.selectAllMenuTreeBusiService.selectAllMenuTree(userMenusReqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)TENANT_ADMIN_CODE)) {
            userMenusReqBO.setRoleIdentity(TENANT_ADMIN_CODE);
            return this.selectMgrMenuTreeBusiService.selectMgrMenuTree(userMenusReqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            userMenusReqBO.setRoleIdentity("auth:overall:manage");
            return this.selectMgrMenuTreeBusiService.selectMgrMenuTree(userMenusReqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)ORG_ADMIN_CODE)) {
            return this.selectMenusByOrgAdminAndUser(ORG_ADMIN_CODE, userMenusReqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)ORG_INNER_ADMIN_CODE)) {
            return this.selectMenusByOrgAdminAndUser(ORG_INNER_ADMIN_CODE, userMenusReqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)ORG_EXT_ADMIN_CODE)) {
            return this.selectMenusByOrgAdminAndUser(ORG_EXT_ADMIN_CODE, userMenusReqBO);
        }
        throw new ZTBusinessException("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/configMenusByOrgTreePath"})
    @JsonBusiResponseBody
    public Object configMenusByOrgTreePath(@RequestBody SaveMenusByOrgTreePathReqBO reqBO) {
        this.saveMenusByOrgTreePathBusiService.save(reqBO);
        return null;
    }

    @RequestMapping(value={"/delete"})
    @JsonBusiResponseBody
    public Object delete(@RequestBody DeleteMenuReqBO deleteMenuReqBO) {
        try {
            SelectDetailByMenuIdReqBO reqBO = new SelectDetailByMenuIdReqBO();
            reqBO.setMenuId(deleteMenuReqBO.getMenuId());
            SelectDetailByMenuIdRspBO selectDetailByMenuIdRspBO = this.selectDetailByMenuIdBusiService.selectDetailByMenuId(reqBO);
        }
        catch (Exception e) {
            log.error("\u5220\u9664", (Throwable)e);
        }
        this.deleteMenuBusiService.deleteMenu(deleteMenuReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteBatch"})
    @JsonBusiResponseBody
    public Object deleteBatch(@RequestBody DeleteMenuReqBO deleteMenuReqBO) {
        this.deleteMenuBusiService.deleteMenuBatch(deleteMenuReqBO);
        return null;
    }

    @RequestMapping(value={"/up"})
    @JsonBusiResponseBody
    public Object upOrder(@RequestBody ChangeMenuOrderReqBO changeMenuOrderReqBO) {
        this.changeMenuOrderUpBusiService.changeMenuOrderUp(changeMenuOrderReqBO);
        return null;
    }

    @RequestMapping(value={"/down"})
    @JsonBusiResponseBody
    public Object downOrder(@RequestBody ChangeMenuOrderReqBO changeMenuOrderReqBO) {
        this.changeMenuOrderDownBusiService.changeMenuOrderDown(changeMenuOrderReqBO);
        return null;
    }

    private SelectMenuTreeByOrgRspBO selectMenusByOrgAdminAndOrgTreePath(String orgAdminCode, SelectMenuTreeByOrgReqBO reqBO) {
        UmcMemInfoBO currentUser = UmcMemInfoHelper.getCurrentUser();
        Long userId = currentUser.getUserId();
        reqBO.setRoleIdentity(orgAdminCode);
        reqBO.setMgrUserId(userId);
        return this.selectMenuTreeByOrgBusiService.select(reqBO);
    }

    private SelectMenuTreeByOrgRspBO selectMenusByOrgAdminAndUser(String orgAdminCode, SelectMenuTreeReqBO userMenusReqBO) {
        UmcMemInfoBO currentUser = UmcMemInfoHelper.getCurrentUser();
        Long userId = currentUser.getUserId();
        SelectMenuTreeByOrgReqBO reqBO = new SelectMenuTreeByOrgReqBO();
        reqBO.setRoleIdentity(orgAdminCode);
        reqBO.setMgrUserId(userId);
        reqBO.setOrgTreePath(userMenusReqBO.getOrgTreePath());
        reqBO.setApplicationCode(userMenusReqBO.getApplicationCode());
        return this.selectMenuTreeByUserBusiService.select(reqBO);
    }

    @RequestMapping(value={"/selectCatalogTree"})
    @BusiResponseBody
    public Object selectCatalogTree(@RequestBody SelectMenuCatalogTreeReqBO selectMenuCatalogTreeReqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)SYSTEM_ADMIN_CODE)) {
            return this.selectMenuCatalogTreeBusiService.selectMenuCatalogTree(selectMenuCatalogTreeReqBO);
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/selectByPId"})
    @JsonBusiResponseBody
    public Object selectByPId(@RequestBody SelectMenuByPIdReqBO selectMenuByPIdReqBO) {
        return this.selectMenuByPIdBusiService.selectMenuByPId(selectMenuByPIdReqBO);
    }

    @RequestMapping(value={"/selectMenusByOrgTreePath"})
    @BusiResponseBody
    public Object selectMenusByOrgTreePath(@RequestBody SelectMenuTreeByOrgReqBO reqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)TENANT_ADMIN_CODE)) {
            reqBO.setRoleIdentity(TENANT_ADMIN_CODE);
            return this.selectMenuTreeByOrgBusiService.select(reqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)ORG_ADMIN_CODE)) {
            return this.selectMenusByOrgAdminAndOrgTreePath(ORG_ADMIN_CODE, reqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)ORG_INNER_ADMIN_CODE)) {
            return this.selectMenusByOrgAdminAndOrgTreePath(ORG_INNER_ADMIN_CODE, reqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)ORG_EXT_ADMIN_CODE)) {
            return this.selectMenusByOrgAdminAndOrgTreePath(ORG_EXT_ADMIN_CODE, reqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)SYSTEM_ADMIN_CODE)) {
            reqBO.setRoleIdentity(SYSTEM_ADMIN_CODE);
            return this.selectMenuTreeByOrgBusiService.select(reqBO);
        }
        throw new ZTBusinessException("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/selMenusToManager"})
    @JsonBusiResponseBody
    public Object selMenusToManager(@RequestBody SelMenuTreeToManagerReqBO selMenuTreeToManagerReqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)SYSTEM_ADMIN_CODE)) {
            return this.selMenuTreeToManagerBusiService.selMenuTreeToManager(selMenuTreeToManagerReqBO);
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }
}

