/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryListAbilityService;
import com.tydic.contract.ability.bo.ContractQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryListAbilityRspBO;
import com.tydic.dyc.contract.api.DycContractQueryOrderContractApprovalListService;
import com.tydic.dyc.contract.bo.DycContractQueryOrderContractApprovalListReqBO;
import com.tydic.dyc.contract.bo.DycContractQueryOrderContractApprovalListRspBO;
import com.tydic.dyc.contract.constant.ContractConstant;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.contract.api.DycContractQueryOrderContractApprovalListService"})
public class DycContractQueryOrderContractApprovalListServiceImpl
implements DycContractQueryOrderContractApprovalListService {
    @Autowired
    private ContractQryListAbilityService contractQryListAbilityService;

    @PostMapping(value={"queryOrderContractApprovalList"})
    public DycContractQueryOrderContractApprovalListRspBO queryOrderContractApprovalList(@RequestBody DycContractQueryOrderContractApprovalListReqBO reqBO) {
        this.validate(reqBO);
        ContractQryListAbilityReqBO centerReqBO = (ContractQryListAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ContractQryListAbilityReqBO.class);
        centerReqBO.setContractType(ContractConstant.ContractType.ORDER_CONTRACT);
        if (reqBO.getPageNo() != null && reqBO.getPageNo() > 0) {
            centerReqBO.setPageNo(reqBO.getPageNo());
        }
        if (reqBO.getPageSize() != null && reqBO.getPageSize() > 0) {
            centerReqBO.setPageSize(reqBO.getPageSize());
        }
        centerReqBO.setContractStatusList(this.transTabIdToContractStatus(reqBO.getTabId()));
        ContractQryListAbilityRspBO centerRspBO = this.contractQryListAbilityService.qryContractList(centerReqBO);
        if ("0000".equals(centerRspBO.getRespCode())) {
            return (DycContractQueryOrderContractApprovalListRspBO)JSON.parseObject((String)JSON.toJSONString((Object)centerRspBO), DycContractQueryOrderContractApprovalListRspBO.class);
        }
        throw new ZTBusinessException(centerRspBO.getRespDesc());
    }

    private List<Integer> transTabIdToContractStatus(Integer tabId) {
        ArrayList<Integer> contractStatusList = new ArrayList<Integer>();
        if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_NO_APPROVAL)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
        } else if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_APPROVED)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
        } else if (tabId.equals(ContractConstant.ContractApprovalTabId.TAB_ID_ALL)) {
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH);
            contractStatusList.add(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN);
        } else {
            throw new ZTBusinessException("\u8f93\u5165\u7684\u9875\u7b7eid\u9519\u8bef");
        }
        return contractStatusList;
    }

    private void validate(DycContractQueryOrderContractApprovalListReqBO reqBO) {
        if (reqBO.getTabId() == null) {
            throw new ZTBusinessException("\u5165\u9a7b\u5408\u540c\u5217\u8868\u67e5\u8be2-tabId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

