/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryTermsListAbilityService;
import com.tydic.contract.ability.bo.ContractQryTermsListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryTermsListAbilityRspBO;
import com.tydic.dyc.contract.api.DycContractQueryTermsListService;
import com.tydic.dyc.contract.bo.DycContractQueryTermsListReqBO;
import com.tydic.dyc.contract.bo.DycContractQueryTermsListRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.contract.api.DycContractQueryTermsListService"})
public class DycContractQueryTermsListServiceImpl
implements DycContractQueryTermsListService {
    private static final Logger log = LoggerFactory.getLogger(DycContractQueryTermsListServiceImpl.class);
    @Autowired
    private ContractQryTermsListAbilityService contractQryTermsListAbilityService;

    @PostMapping(value={"queryTermsList"})
    public DycContractQueryTermsListRspBO queryTermsList(@RequestBody DycContractQueryTermsListReqBO reqBO) {
        log.debug("\u5408\u540c\u6761\u6b3e\u5217\u8868\u67e5\u8be2API\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        List<String> orgIdStr = Arrays.asList(reqBO.getOrgPath().split("-"));
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (String str : orgIdStr) {
            orgIds.add(Long.valueOf(str));
        }
        ContractQryTermsListAbilityReqBO centerReqBO = new ContractQryTermsListAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)centerReqBO);
        if (reqBO.getPageNo() != null && reqBO.getPageNo() > 0) {
            centerReqBO.setPageNo(reqBO.getPageNo());
        }
        if (reqBO.getPageSize() != null && reqBO.getPageSize() > 0) {
            centerReqBO.setPageSize(reqBO.getPageSize());
        }
        centerReqBO.setOrgIds(orgIds);
        centerReqBO.setCurrentOrgId(reqBO.getOrgId());
        ContractQryTermsListAbilityRspBO contractQryTermsListAbilityRspBO = this.contractQryTermsListAbilityService.qryTermsList(centerReqBO);
        if ("0000".equals(contractQryTermsListAbilityRspBO.getRespCode())) {
            String resultJsonStr = JSON.toJSONString((Object)contractQryTermsListAbilityRspBO);
            return (DycContractQueryTermsListRspBO)JSONObject.parseObject((String)resultJsonStr, DycContractQueryTermsListRspBO.class);
        }
        throw new ZTBusinessException(contractQryTermsListAbilityRspBO.getRespDesc());
    }
}

