/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.estore.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.estore.ability.api.UccEstoreSkuListQryAbilityService;
import com.tydic.commodity.estore.ability.bo.UccEstoreSkuListQryAbilityReqBO;
import com.tydic.commodity.estore.ability.bo.UccEstoreSkuListQryAbilityRspBO;
import com.tydic.commodity.mall.ability.api.UccMallReplacementPriceAbilityService;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.base.constants.MoneyUtils;
import com.tydic.dyc.estore.commodity.api.DycUccEstoreSkuListQryService;
import com.tydic.dyc.estore.commodity.bo.DycEstoreSkuListQryBO;
import com.tydic.dyc.estore.commodity.bo.DycUccEstoreSkuListQryAbilityReqBO;
import com.tydic.dyc.estore.commodity.bo.DycUccEstoreSkuListQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.estore.commodity.api.DycUccEstoreSkuListQryService"})
public class DycUccEstoreSkuListQryServiceImpl
implements DycUccEstoreSkuListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUccEstoreSkuListQryServiceImpl.class);
    @Autowired
    private UccEstoreSkuListQryAbilityService uccEstoreSkuListQryAbilityService;
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;
    @Autowired
    private UccMallReplacementPriceAbilityService uccMallReplacementPriceAbilityService;

    @PostMapping(value={"getEstoreSkuManagementListQry"})
    public DycUccEstoreSkuListQryAbilityRspBO getEstoreSkuManagementListQry(@RequestBody DycUccEstoreSkuListQryAbilityReqBO reqBO) {
        String strReq = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UccEstoreSkuListQryAbilityReqBO abilityReqBO = (UccEstoreSkuListQryAbilityReqBO)JSONObject.parseObject((String)strReq, UccEstoreSkuListQryAbilityReqBO.class);
        this.setReqAuth(strReq, abilityReqBO);
        UccEstoreSkuListQryAbilityRspBO abilityRspBO = this.uccEstoreSkuListQryAbilityService.getEstoreSkuListQry(abilityReqBO);
        DycUccEstoreSkuListQryAbilityRspBO rspBO = new DycUccEstoreSkuListQryAbilityRspBO();
        if ("0000".equals(abilityRspBO.getRespCode())) {
            String rspStr = JSONObject.toJSONString((Object)abilityRspBO);
            rspBO = (DycUccEstoreSkuListQryAbilityRspBO)JSONObject.parseObject((String)rspStr, DycUccEstoreSkuListQryAbilityRspBO.class);
            if (!CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                List result = JSONObject.parseArray((String)JSONObject.toJSONString((Object)abilityRspBO.getRows()), UccSkuManagementListQryBO.class);
                Map mapList = result.stream().collect(Collectors.toMap(UccSkuManagementListQryBO::getSkuId, Function.identity()));
                int i = 1;
                UccMallReplacementPriceReqBo uccMallReplacementPriceReqBo = new UccMallReplacementPriceReqBo();
                ArrayList<ReplacePriceInfoBO> replacePriceInfoBOList = new ArrayList<ReplacePriceInfoBO>(10);
                for (DycEstoreSkuListQryBO each : rspBO.getRows()) {
                    each.setSerialNumber(Integer.valueOf(i++));
                    if (mapList.containsKey(each.getSkuId())) {
                        each.setSkuApprovalStatus(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getApprovalStatus());
                        each.setSkuApprovalStatusDesc(((UccSkuManagementListQryBO)mapList.get(each.getSkuId())).getApprovalStatusDesc());
                    }
                    ReplacePriceInfoBO replacePriceInfoBO = new ReplacePriceInfoBO();
                    replacePriceInfoBO.setCommodityTypeId(each.getCommodityTypeId());
                    replacePriceInfoBO.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each.getAgreementPrice())));
                    replacePriceInfoBO.setSkuSource(each.getSkuSource());
                    replacePriceInfoBO.setSupplierShopId(each.getSupplierShopId());
                    replacePriceInfoBO.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)each.getSalePrice())));
                    replacePriceInfoBO.setSkuId(each.getSkuId());
                    replacePriceInfoBO.setCommodityId(each.getCommodityId());
                    replacePriceInfoBO.setVendorId(each.getVendorId());
                    replacePriceInfoBOList.add(replacePriceInfoBO);
                }
                uccMallReplacementPriceReqBo.setIsprofess(reqBO.getIsprofess());
                uccMallReplacementPriceReqBo.setCompanyId(reqBO.getCompanyId());
                uccMallReplacementPriceReqBo.setReplacePriceInfo(replacePriceInfoBOList);
                UccMallReplacementPriceRspBo uccMallReplacementPriceRspBo = this.uccMallReplacementPriceAbilityService.replacePrice(uccMallReplacementPriceReqBo);
                if ("0000".equals(uccMallReplacementPriceRspBo.getRespCode())) {
                    if (!CollectionUtils.isEmpty((Collection)uccMallReplacementPriceRspBo.getRows())) {
                        Map<Long, Long> replacePriceMap = uccMallReplacementPriceRspBo.getRows().stream().collect(Collectors.toMap(ReplacePriceInfoBO::getSkuId, ReplacePriceInfoBO::getSalePrice));
                        for (DycEstoreSkuListQryBO each : rspBO.getRows()) {
                            if (!replacePriceMap.containsKey(each.getSkuId())) continue;
                            each.setSalePrice(MoneyUtils.haoToYuan((Long)replacePriceMap.get(each.getSkuId())));
                        }
                    }
                } else {
                    log.error("\u4ef7\u683c\u66ff\u6362\u5f02\u5e38\uff1a" + uccMallReplacementPriceRspBo.getRespDesc());
                }
            }
        } else {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        return rspBO;
    }

    private void setReqSkuStatus(DycUccEstoreSkuListQryAbilityReqBO reqBO, UccEstoreSkuListQryAbilityReqBO abilityReqBO) {
        if (null != reqBO.getTabId()) {
            switch (reqBO.getTabId()) {
                case 0: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_DRAFT, SkuStatusConstants.SKU_STATUS_EDIT_AUDITING, SkuStatusConstants.SKU_STATUS_EDIT_AUDIT_REJECT));
                    break;
                }
                case 1: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_WAIT_SHELF, SkuStatusConstants.SKU_STATUS_PUT_ON_AUDITING, SkuStatusConstants.SKU_STATUS_PUT_ON_AUDIT_REJECT));
                    break;
                }
                case 2: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_ON_SHELF, SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDIT_REJECT));
                    break;
                }
                case 3: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_ECCOM_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_FORCE_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_WARING_DOWN_SHELF, SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDITING, SkuStatusConstants.SKU_STATUS_RE_PUT_ON_AUDIT_REJECT));
                    break;
                }
                case 4: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_FREEZE, SkuStatusConstants.SKU_STATUS_PUT_OFF_AUDITING));
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_WAIT_ON_GOVERN));
                    break;
                }
                case 7: {
                    abilityReqBO.setSkuStatus(Arrays.asList(SkuStatusConstants.SKU_STATUS_TO_REL));
                    break;
                }
            }
        }
    }

    private void setReqAuth(String strReq, UccEstoreSkuListQryAbilityReqBO abilityReqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = (AuthUserRoleDataPowerQryReqBo)JSONObject.parseObject((String)strReq, AuthUserRoleDataPowerQryReqBo.class);
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        } else {
            abilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
            abilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
            abilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
            abilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
            abilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
            abilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
        }
    }
}

