/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.commodity.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.mall.ability.api.UccMallSpuOrderListQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.mall.commodity.api.DycUccMallCompareSkuPriceService;
import com.tydic.dyc.mall.commodity.bo.DycUccMallCheckSkuPriceBo;
import com.tydic.dyc.mall.commodity.bo.DycUccMallCompareSkuPriceReqBo;
import com.tydic.dyc.mall.commodity.bo.DycUccMallCompareSkuPriceRspBo;
import com.tydic.dyc.mall.commodity.bo.DycUccMallSkuOrderBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"APP_GROUP_DEV/3.0.0/com.tydic.dyc.mall.commodity.api.DycUccMallCompareSkuPriceService"})
public class DycUccMallCompareSkuPriceServiceImpl
implements DycUccMallCompareSkuPriceService {
    @Autowired
    private UccMallSpuOrderListQueryAbilityService uccMallSpuOrderListQueryAbilityService;
    private static final BigDecimal TEN_THOUSAND = new BigDecimal(10000);

    @PostMapping(value={"compareSkuPrice"})
    public DycUccMallCompareSkuPriceRspBo compareSkuPrice(@RequestBody DycUccMallCompareSkuPriceReqBo reqBo) {
        UccMallSpuOrderListQueryAbilityReqBO uccMallSpuOrderListQueryAbilityReqBO = (UccMallSpuOrderListQueryAbilityReqBO)JUtil.js((Object)reqBo, UccMallSpuOrderListQueryAbilityReqBO.class);
        UccMallSpuOrderListQueryAbilityRspBO uccMallSpuOrderListQueryAbilityRspBO = this.uccMallSpuOrderListQueryAbilityService.querySpuOrderListInfo(uccMallSpuOrderListQueryAbilityReqBO);
        if ("0000".equals(uccMallSpuOrderListQueryAbilityRspBO.getRespCode())) {
            int skuCount = 0;
            for (UccMallSpuOrderListQueryBO item : uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList()) {
                skuCount += item.getOrderSkuList().size();
            }
            if (reqBo.getSkuOrderList().size() == skuCount) {
                DycUccMallCompareSkuPriceRspBo rspBo = new DycUccMallCompareSkuPriceRspBo();
                reqBo.getSkuOrderList().forEach(bo -> bo.setSkuIdAndCount(bo.getSkuId() + "_" + bo.getNum()));
                Map<String, List<DycUccMallSkuOrderBO>> inputCommodityInfosMap = reqBo.getSkuOrderList().stream().collect(Collectors.groupingBy(DycUccMallSkuOrderBO::getSkuIdAndCount));
                ArrayList uccSkuInfoList = new ArrayList();
                for (UccMallSpuOrderListQueryBO uccSpuInfo : uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList()) {
                    uccSkuInfoList.addAll(uccSpuInfo.getOrderSkuList());
                }
                Map<String, List<UccMallSkuDetailInfoBO>> rspSkuMap = uccSkuInfoList.stream().collect(Collectors.groupingBy(UccMallSkuDetailInfoBO::getKey));
                ArrayList<DycUccMallCheckSkuPriceBo> dycUccMallCheckSkuPriceBos = new ArrayList<DycUccMallCheckSkuPriceBo>();
                for (Map.Entry<String, List<UccMallSkuDetailInfoBO>> entry : rspSkuMap.entrySet()) {
                    List<DycUccMallSkuOrderBO> reqSkuBOs = inputCommodityInfosMap.get(entry.getKey());
                    for (int i = 0; i < entry.getValue().size(); ++i) {
                        if (entry.getValue().get(i).getSalePrice().equals(this.BigDecimal2Long(reqSkuBOs.get(i).getSalePrice()))) continue;
                        DycUccMallCheckSkuPriceBo dycUccMallCheckSkuPriceBo = new DycUccMallCheckSkuPriceBo();
                        dycUccMallCheckSkuPriceBo.setSkuId(entry.getValue().get(i).getSkuId());
                        dycUccMallCheckSkuPriceBo.setNewPrice(Convert.toBigDecimal((Object)entry.getValue().get(i).getSalePrice()).divide(TEN_THOUSAND, 2, RoundingMode.HALF_DOWN));
                        dycUccMallCheckSkuPriceBo.setOldPrice(reqSkuBOs.get(i).getSalePrice());
                        dycUccMallCheckSkuPriceBos.add(dycUccMallCheckSkuPriceBo);
                    }
                }
                rspBo.setDycUccMallCheckSkuPriceBos(dycUccMallCheckSkuPriceBos);
                return rspBo;
            }
            throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5546\u57ce\u5546\u54c1\u6570\u636e\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5546\u57ce\u5546\u54c1\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff1a" + uccMallSpuOrderListQueryAbilityRspBO.getRespDesc());
    }

    private Long BigDecimal2Long(BigDecimal money) {
        try {
            return MoneyUtils.BigDecimal2Long((BigDecimal)money);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff1aBigDecimal\u8f6c\u5316\u4e3aLong\u5f02\u5e38");
        }
    }
}

