/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.selfrun.ability.constant;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static final String EXCEL_XLS = ".xls";
    private static final String EXCEL_XLSX = ".xlsx";

    public static void getExcelDate(String path, List<List<String>> data, Integer readLine, Integer sheetAt) {
        int count = 1;
        try {
            URL url = new URL(path);
            File file = new File(url.getFile());
            InputStream inputStream = url.openStream();
            ExcelUtils.checkExcelVaild(path);
            Workbook workbook = ExcelUtils.getWorkbok(path, inputStream);
            Sheet sheet = workbook.getSheetAt(sheetAt.intValue());
            for (Row row : sheet) {
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) == null || "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count < readLine) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                data.add(c);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u7b2c" + count + "\u6570\u636e\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private static void checkExcelVaild(String filePath) throws Exception {
        if (filePath == null) {
            return;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Workbook getWorkbok(String filePath, InputStream inputStream) throws IOException {
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        if (!EXCEL_XLS.equals(extString) && !EXCEL_XLSX.equals(extString)) {
            throw new IOException("\u6587\u4ef6\u4e0d\u662fExcel");
        }
        HSSFWorkbook wb = null;
        if (EXCEL_XLS.equals(extString)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (EXCEL_XLSX.equals(extString)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }

    public static void main(String[] args) {
        int num = 0;
        try {
            for (int i = 0; i < 3; ++i) {
                ++num;
                i = 1 / 0;
            }
        }
        catch (Exception e) {
            System.out.println(num);
        }
    }
}

