/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.domainservice;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryRspBo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.AuthGetOrgPowerRoleListService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetOrgPowerRoleListReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthGetOrgPowerRoleListRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.domainservice.AuthGetOrgPowerRoleListService"})
public class AuthGetOrgPowerRoleListServiceImpl
implements AuthGetOrgPowerRoleListService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getOrgPowerRoleList"})
    public AuthGetOrgPowerRoleListRspBo getOrgPowerRoleList(@RequestBody AuthGetOrgPowerRoleListReqBo reqBo) {
        AuthGetOrgPowerRoleListRspBo rspBo = AuthRu.success(AuthGetOrgPowerRoleListRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoQryBo operUserReqBo = new SysUserInfoQryBo();
        operUserReqBo.setUserId(reqBo.getUserId());
        SysUserInfoDo operInfoDo = this.iSysUserInfoModel.getUserInfoDetails(operUserReqBo);
        if (operInfoDo == null || operInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7528\u6237\u4fe1\u606f");
        }
        SysOrgInfoQryBo targetReqBo = new SysOrgInfoQryBo();
        targetReqBo.setOrgId(reqBo.getTargetOrgId());
        SysOrgInfoDo targetOrgDo = this.iSysOrgInfoModel.getOrgInfoDetails(targetReqBo);
        if (targetOrgDo == null || targetOrgDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u5206\u914d\u76ee\u6807\u7528\u6237\u4fe1\u606f");
        }
        rspBo.setHasRoleList(this.getOrgRoleList(targetOrgDo));
        if ("auth:system:manage".equals(operInfoDo.getAuthorityType())) {
            SysRoleInfoQryBo roleQryBo = new SysRoleInfoQryBo();
            roleQryBo.setTenantId(targetOrgDo.getTenantId());
            roleQryBo.setIsSystemManager("1");
            roleQryBo.setPageSize(-1);
            SysRoleInfoQryRspBo powerRoleList = this.iSysRoleInfoModel.getRolePageList(roleQryBo);
            List<AuthRoleInfoBo> roleBoList = AuthRu.jsl(powerRoleList.getRows(), AuthRoleInfoBo.class);
            for (AuthRoleInfoBo infoBo : roleBoList) {
                infoBo.setOrgExtend(Integer.valueOf(0));
                infoBo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ONLY_USE);
            }
            rspBo.setAllRoleList(roleBoList);
        } else {
            SysUserInfoQryBo userInfoQryBo = new SysUserInfoQryBo();
            userInfoQryBo.setUserId(reqBo.getUserId());
            userInfoQryBo.setDisAgFLagList(reqBo.getDisAgFLagList());
            SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getRoleInfoListByUser(userInfoQryBo);
            List<SysRoleInfoDo> powerRoleList = AuthRu.jsl(userInfoDo.getUserRoleList(), SysRoleInfoDo.class);
            SysOrgInfoQryBo orgRoleInfo = new SysOrgInfoQryBo();
            orgRoleInfo.setOrgTreePath(operInfoDo.getOrgTreePath());
            orgRoleInfo.setDisAgFLagList(reqBo.getDisAgFLagList());
            orgRoleInfo.setPageSize(-1);
            SysOrgInfoDo orgInfoDo = this.iSysOrgInfoModel.getRoleInfoListByOrg(orgRoleInfo);
            List<SysRoleInfoDo> orgRoleList = AuthRu.jsl(orgInfoDo.getOrgRoleList(), SysRoleInfoDo.class);
            Map<Long, List<SysRoleInfoDo>> powerRoleMap = powerRoleList.stream().collect(Collectors.groupingBy(SysRoleInfoDo::getRoleId));
            Map<Long, List<SysRoleInfoDo>> orgRoleMap = orgRoleList.stream().collect(Collectors.groupingBy(SysRoleInfoDo::getRoleId));
            HashMap<Long, List<SysRoleInfoDo>> allRoleMap = new HashMap<Long, List<SysRoleInfoDo>>();
            allRoleMap.putAll(powerRoleMap);
            allRoleMap.putAll(orgRoleMap);
            ArrayList rspRoleList = new ArrayList();
            allRoleMap.keySet().forEach(key -> {
                SysRoleInfoDo rspDataBO = new SysRoleInfoDo();
                rspRoleList.add(rspDataBO);
            });
            rspBo.setAllRoleList(AuthRu.jsl(rspRoleList, AuthRoleInfoBo.class));
        }
        return rspBo;
    }

    private void validateArg(AuthGetOrgPowerRoleListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetOrgPowerRoleListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<AuthRoleInfoBo> getOrgRoleList(SysOrgInfoDo targetOrgDo) {
        SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
        orgQryBo.setOrgTreePath(targetOrgDo.getOrgTreePath());
        orgQryBo.setDisAgFLagList(Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY));
        SysOrgInfoDo orgInfoDo = this.iSysOrgInfoModel.getRoleInfoListByOrg(orgQryBo);
        return AuthRu.jsl(orgInfoDo.getOrgRoleList(), AuthRoleInfoBo.class);
    }
}

