/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.qrybo.SysOrgInfoQryRspBo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.role.AuthRoleMenuDataPowerQryListService;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuDataPowerReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleMenuDataPowerRsqBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthRoleMenuDataPowerQryListService"})
public class AuthRoleMenuDataPowerQryListServiceImpl
implements AuthRoleMenuDataPowerQryListService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"getRoleMenuDataPower"})
    public AuthRoleMenuDataPowerRsqBo getRoleMenuDataPower(@RequestBody AuthRoleMenuDataPowerReqBo reqBo) {
        AuthRoleMenuDataPowerRsqBo rspBo = AuthRu.success(AuthRoleMenuDataPowerRsqBo.class);
        this.validateArg(reqBo);
        SysRoleInfoQryBo infoDo = new SysRoleInfoQryBo();
        infoDo.setOrgId(reqBo.getOrgId());
        if (ObjectUtil.isNotEmpty((Object)reqBo.getRoleId())) {
            infoDo.setRoleId(reqBo.getRoleId());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getMenuId())) {
            infoDo.setMenuId(reqBo.getMenuId());
        }
        SysOrgInfoQryRspBo roleInfoDo = this.iSysRoleInfoModel.getRoleMenuDataList(infoDo);
        List<AuthOrgInfoBo> authOrgInfoBoList = AuthRu.jsl(roleInfoDo.getRows(), AuthOrgInfoBo.class);
        rspBo.setAuthOrgInfoBoList(authOrgInfoBoList);
        return rspBo;
    }

    private void validateArg(AuthRoleMenuDataPowerReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthRoleMenuDataPowerReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

