/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.organization.AuthDealOrgRoleService;
import com.tydic.dyc.authority.service.organization.bo.AuthDealOrgRoleReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthDealOrgRoleRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.organization.AuthDealOrgRoleService"})
public class AuthDealOrgRoleServiceImpl
implements AuthDealOrgRoleService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"dealOrgRole"})
    public AuthDealOrgRoleRspBo dealOrgRole(@RequestBody AuthDealOrgRoleReqBo reqBo) {
        AuthDealOrgRoleRspBo rspBo = AuthRu.success(AuthDealOrgRoleRspBo.class);
        this.validateArg(reqBo);
        this.getManageLevel(reqBo);
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        SysOrgInfoQryBo qryBo = new SysOrgInfoQryBo();
        List<SysAuthDistributeSubDo> addSubDo = AuthRu.jsl(reqBo.getAuthDistributeList(), SysAuthDistributeSubDo.class);
        qryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo detailDo = this.iSysOrgInfoModel.getOrgInfoDetails(qryBo);
        if (detailDo == null || detailDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        reqDo.setOrgTreePath(detailDo.getOrgTreePath());
        qryBo.setOrgTreePath(detailDo.getOrgTreePath());
        qryBo.setDisAgFLagList(Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY));
        SysOrgInfoDo userRoleDo = this.iSysOrgInfoModel.getRoleInfoListByOrg(qryBo);
        List<SysRoleInfoSubDo> oldRoleList = userRoleDo.getOrgRoleList();
        ArrayList<SysAuthDistributeSubDo> eqaulsSubDo = new ArrayList<SysAuthDistributeSubDo>();
        ArrayList<SysRoleInfoSubDo> eqaulsRoleList = new ArrayList<SysRoleInfoSubDo>();
        block0: for (SysRoleInfoSubDo oldSubDo : oldRoleList) {
            for (SysAuthDistributeSubDo reqDistributeSubDo : addSubDo) {
                if (!oldSubDo.getRoleId().equals(reqDistributeSubDo.getRoleId()) || !oldSubDo.getDisFlag().equals(reqDistributeSubDo.getDisFlag())) continue;
                eqaulsSubDo.add(reqDistributeSubDo);
                eqaulsRoleList.add(oldSubDo);
                continue block0;
            }
        }
        oldRoleList.removeAll(eqaulsRoleList);
        addSubDo.removeAll(eqaulsSubDo);
        this.deleteUserRole(reqDo, oldRoleList);
        this.addUserRole(reqDo, addSubDo, reqBo);
        return rspBo;
    }

    private void addUserRole(SysOrgInfoDo reqDo, List<SysAuthDistributeSubDo> addRoleList, AuthDealOrgRoleReqBo reqBo) {
        SysOrgInfoDo addReqBo = new SysOrgInfoDo();
        for (SysAuthDistributeSubDo subDo : addRoleList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setOrgTreePath(reqDo.getOrgTreePath());
            subDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
            subDo.setManageLevel(reqBo.getManagerLevelIn());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.ORG);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
            if (null != subDo.getOrgExtend()) continue;
            subDo.setOrgExtend(0);
        }
        addReqBo.setAuthDistributeList(addRoleList);
        this.iSysOrgInfoModel.addOrgRoleList(addReqBo);
    }

    private void deleteUserRole(SysOrgInfoDo reqDo, List<SysRoleInfoSubDo> deleteRoleList) {
        SysOrgInfoDo addReqBo = new SysOrgInfoDo();
        ArrayList<SysAuthDistributeSubDo> delRoleList = new ArrayList<SysAuthDistributeSubDo>();
        for (SysRoleInfoSubDo roleSubDo : deleteRoleList) {
            SysAuthDistributeSubDo subDo = new SysAuthDistributeSubDo();
            subDo.setRoleId(roleSubDo.getRoleId());
            subDo.setOrgTreePath(reqDo.getOrgTreePath());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
            delRoleList.add(subDo);
        }
        addReqBo.setAuthDistributeList(delRoleList);
        this.iSysOrgInfoModel.updateOrgRoleList(addReqBo);
    }

    private void validateArg(AuthDealOrgRoleReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }

    private void getManageLevel(AuthDealOrgRoleReqBo reqBo) {
        if (reqBo.getManagerLevelIn() == null && reqBo.getOrgIdIn() != null) {
            SysOrgInfoQryBo orgInfoQryBo = new SysOrgInfoQryBo();
            orgInfoQryBo.setOrgId(reqBo.getOrgIdIn());
            SysOrgInfoDo orgInfoDetails = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
            reqBo.setManagerLevelIn(orgInfoDetails.getManageLevel());
        }
    }
}

