/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.tydic.dyc.authority.model.common.sub.SysAuthRoleMenuDataOrgSubDo;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.sub.SysMenuSubDo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuDataAuthSubDo;
import com.tydic.dyc.authority.service.role.AuthRoleChildMenuListQryService;
import com.tydic.dyc.authority.service.role.bo.AuthRoleChildMenuBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleChildMenuListQryReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleChildMenuListQryRspBo;
import com.tydic.dyc.authority.service.role.bo.DataAuthBo;
import com.tydic.dyc.authority.service.role.bo.FuncAuthBo;
import com.tydic.dyc.authority.service.role.bo.OtherOrgBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.role.AuthRoleChildMenuListQryService"})
public class AuthRoleChildMenuListQryServiceImpl
implements AuthRoleChildMenuListQryService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private ISysMenuModel iSysMenuModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getRoleChildMenuList"})
    public AuthRoleChildMenuListQryRspBo getRoleChildMenuList(@RequestBody AuthRoleChildMenuListQryReqBo reqBo) {
        AuthRoleChildMenuListQryRspBo rspBo = new AuthRoleChildMenuListQryRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.valiData(reqBo);
        SysMenuQryBo menuQryBo = new SysMenuQryBo();
        menuQryBo.setParentId(reqBo.getMenuId());
        List menuList = this.iSysMenuModel.getMenuList(menuQryBo).getRows();
        if (CollectionUtils.isEmpty((Collection)menuList)) {
            rspBo.setRespDesc("\u83dc\u5355\u67e5\u8be2\u4e3a\u7a7a");
            return rspBo;
        }
        SysRoleInfoQryBo roleInfoQryBo = new SysRoleInfoQryBo();
        roleInfoQryBo.setRoleId(reqBo.getRoleId());
        SysRoleInfoDo roleMenuRelList = this.iSysRoleInfoModel.getRoleMenuRelListByRoleId(roleInfoQryBo);
        Map<Long, SysMenuSubDo> roleMenuMap = roleMenuRelList.getMenuList().stream().collect(Collectors.toMap(SysMenuSubDo::getMenuId, e -> e, (e1, e2) -> e2));
        ArrayList<AuthRoleChildMenuBo> roles = new ArrayList<AuthRoleChildMenuBo>();
        for (SysMenuDo menuDo : menuList) {
            AuthRoleChildMenuBo childMenuBo = new AuthRoleChildMenuBo();
            childMenuBo.setMenuId(menuDo.getMenuId());
            childMenuBo.setMenuName(menuDo.getMenuName());
            childMenuBo.setRemark(menuDo.getRemark());
            if (roleMenuMap.containsKey(menuDo.getMenuId())) {
                childMenuBo.setHasSel(Boolean.valueOf(true));
            } else {
                childMenuBo.setHasSel(Boolean.valueOf(false));
            }
            this.queryFunc(reqBo, menuDo, childMenuBo);
            if (childMenuBo.getHasSel().booleanValue()) {
                SysRoleInfoQryBo dataRoleInfoQryBo = new SysRoleInfoQryBo();
                dataRoleInfoQryBo.setRoleIds(Collections.singletonList(reqBo.getRoleId()));
                dataRoleInfoQryBo.setMenuId(menuDo.getMenuId());
                List roleMenuDataAuthList = this.iSysRoleInfoModel.getRoleMenuDataAuthList(dataRoleInfoQryBo).getRows();
                if (CollectionUtils.isEmpty((Collection)roleMenuDataAuthList)) {
                    roles.add(childMenuBo);
                    continue;
                }
                ArrayList<DataAuthBo> dataAuthBos = new ArrayList<DataAuthBo>();
                this.queryDataAuth(reqBo, menuDo, roleMenuDataAuthList, dataAuthBos);
                childMenuBo.setDataAuthList(dataAuthBos);
            }
            roles.add(childMenuBo);
        }
        rspBo.setRows(roles);
        return rspBo;
    }

    private void queryDataAuth(AuthRoleChildMenuListQryReqBo reqBo, SysMenuDo menuDo, List<SysRoleMenuDataAuthSubDo> roleMenuDataAuthList, List<DataAuthBo> dataAuthBos) {
        DataAuthBo dataAuthBo = new DataAuthBo();
        for (SysRoleMenuDataAuthSubDo authSubDo : roleMenuDataAuthList) {
            if ("0".equals(authSubDo.getDataAuthItem())) {
                dataAuthBo.setOrgHasSel(Boolean.valueOf(true));
                dataAuthBo.setOrgSelValue(authSubDo.getDataAuthItemSub());
                continue;
            }
            dataAuthBo.setOtherOrgHasSel(Boolean.valueOf("1".equals(authSubDo.getDataAuthItem())));
            SysRoleInfoQryBo dataOrgQryBo = new SysRoleInfoQryBo();
            dataOrgQryBo.setMenuId(menuDo.getMenuId());
            dataOrgQryBo.setRoleId(reqBo.getRoleId());
            dataOrgQryBo.setAuthIds(Collections.singletonList(authSubDo.getDataAuthId()));
            SysRoleInfoDo authRoleMenuDataOrgList = this.iSysRoleInfoModel.getAuthRoleMenuDataOrgList(dataOrgQryBo);
            if (CollectionUtils.isEmpty(authRoleMenuDataOrgList.getAuthRoleMenuDataOrgList())) continue;
            ArrayList<Long> orgRelIds = new ArrayList<Long>();
            ArrayList<OtherOrgBo> otherOrgBos = new ArrayList<OtherOrgBo>();
            HashMap<Long, Boolean> orgLastLevelMap = new HashMap<Long, Boolean>();
            HashMap<Long, Boolean> orgHasChoosedMap = new HashMap<Long, Boolean>();
            ArrayList<Long> returnOrgIds = new ArrayList<Long>();
            for (SysAuthRoleMenuDataOrgSubDo dataOrgSubDo : authRoleMenuDataOrgList.getAuthRoleMenuDataOrgList()) {
                String[] split;
                orgRelIds.add(dataOrgSubDo.getOrgId());
                if (StringUtils.isEmpty((Object)dataOrgSubDo.getOrgTreePath()) || (split = dataOrgSubDo.getOrgTreePath().split("-")).length < 2) continue;
                Long orgId = Long.parseLong(split[1]);
                if (!returnOrgIds.contains(orgId)) {
                    returnOrgIds.add(orgId);
                }
                if (orgId.equals(dataOrgSubDo.getOrgId())) {
                    orgHasChoosedMap.put(orgId, true);
                }
                if (split.length == 2) {
                    if (orgLastLevelMap.containsKey(orgId)) continue;
                    orgLastLevelMap.put(orgId, false);
                    continue;
                }
                orgLastLevelMap.put(orgId, true);
            }
            dataAuthBo.setOtherOrgIds(orgRelIds);
            if (CollectionUtils.isEmpty(returnOrgIds)) continue;
            SysOrgInfoDo returnOrgQryDo = new SysOrgInfoDo();
            returnOrgQryDo.setOrgIds(returnOrgIds);
            List returnOrgList = this.iSysOrgInfoModel.getList(returnOrgQryDo).getRows();
            if (CollectionUtils.isEmpty((Collection)returnOrgList)) continue;
            for (SysOrgInfoDo infoDo : returnOrgList) {
                OtherOrgBo otherOrgBo = new OtherOrgBo();
                otherOrgBo.setOrgId(infoDo.getOrgId());
                otherOrgBo.setOrgName(infoDo.getOrgName());
                otherOrgBo.setHasChild((Boolean)orgLastLevelMap.get(infoDo.getOrgId()));
                otherOrgBo.setHasSel(Boolean.valueOf(orgHasChoosedMap.containsKey(infoDo.getOrgId())));
                otherOrgBos.add(otherOrgBo);
            }
            dataAuthBo.setOtherOrgList(otherOrgBos);
        }
        dataAuthBos.add(dataAuthBo);
    }

    private void queryFunc(AuthRoleChildMenuListQryReqBo reqBo, SysMenuDo menuDo, AuthRoleChildMenuBo childMenuBo) {
        if (childMenuBo.getHasSel().booleanValue()) {
            SysMenuQryBo roleMenuQryBo = new SysMenuQryBo();
            roleMenuQryBo.setMenuId(menuDo.getMenuId());
            roleMenuQryBo.setRoleId(reqBo.getRoleId());
            List roleMenuBtnList = this.iSysMenuModel.getRoleMenuBtnList(roleMenuQryBo).getRows();
            childMenuBo.setFuncAuthList(AuthRu.jsl(roleMenuBtnList, FuncAuthBo.class));
        }
    }

    private void valiData(AuthRoleChildMenuListQryReqBo reqBo) {
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u83dc\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

