/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoListRspBo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.qrybo.SysCustUserQryBo;
import com.tydic.dyc.authority.model.user.sub.SysCustUserSubListRspDo;
import com.tydic.dyc.authority.service.user.AuthGetUserListByRoleService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserListByRoleReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserListByRoleRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthRoleUserInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthGetUserListByRoleService"})
public class AuthGetUserListByRoleServiceImpl
implements AuthGetUserListByRoleService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    @PostMapping(value={"getUserListByRole"})
    public AuthGetUserListByRoleRspBo getUserListByRole(@RequestBody AuthGetUserListByRoleReqBo reqBo) {
        ArrayList<AuthRoleUserInfoBo> allHasUserList = new ArrayList<AuthRoleUserInfoBo>();
        AuthGetUserListByRoleRspBo rspBo = AuthRu.success(AuthGetUserListByRoleRspBo.class);
        this.validateArg(reqBo);
        SysCustUserQryBo qryBo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysCustUserQryBo.class));
        SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(reqBo.getRoleId());
        orgQryBo.setRoleIds(list);
        orgQryBo.setDisAgFLag(1);
        SysOrgInfoListRspBo orgListByRole = this.iSysOrgInfoModel.getOrgListByRole(orgQryBo);
        if (orgListByRole.getRows().size() > 0) {
            for (SysOrgInfoDo orgInfoDo : orgListByRole.getRows()) {
                SysCustUserQryBo userQryBo = new SysCustUserQryBo();
                userQryBo.setRoleId(null);
                userQryBo.setOrgTreePath(orgInfoDo.getOrgTreePath());
                userQryBo.setMgOrgIdsIn(reqBo.getMgOrgIdsIn());
                SysCustUserSubListRspDo UserList = this.iSysUserInfoModel.getCustUserList(userQryBo);
                allHasUserList.addAll(AuthRu.jsl(UserList.getRows(), AuthRoleUserInfoBo.class));
            }
        }
        qryBo.setRoleId(null);
        qryBo.setOrgTreePath(reqBo.getOrgTreePath());
        SysCustUserSubListRspDo allUserList = this.iSysUserInfoModel.getCustUserList(qryBo);
        qryBo.setRoleId(reqBo.getRoleId());
        qryBo.setOrgTreePath(reqBo.getOrgTreePath());
        SysCustUserSubListRspDo aloneHasUserList = this.iSysUserInfoModel.getCustUserList(qryBo);
        allHasUserList.addAll(AuthRu.jsl(aloneHasUserList.getRows(), AuthRoleUserInfoBo.class));
        rspBo.setAllUserList(AuthRu.jsl(allUserList.getRows(), AuthRoleUserInfoBo.class));
        rspBo.setHasUserList(AuthRu.jsl(allHasUserList, AuthRoleUserInfoBo.class));
        return rspBo;
    }

    private void validateArg(AuthGetUserListByRoleReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetUserListByRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

