/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.application;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.application.ISysApplicationModel;
import com.tydic.dyc.authority.model.application.SysApplicationDo;
import com.tydic.dyc.authority.model.application.qrybo.SysApplicationQryBo;
import com.tydic.dyc.authority.service.application.AuthGetApplicationDetailService;
import com.tydic.dyc.authority.service.application.bo.AuthApplicationInfoBo;
import com.tydic.dyc.authority.service.application.bo.AuthGetApplicationDetailReqBo;
import com.tydic.dyc.authority.service.application.bo.AuthGetApplicationDetailRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthGetApplicationDetailService.class)
public class AuthGetApplicationDetailServiceImpl
implements AuthGetApplicationDetailService {
    @Autowired
    private ISysApplicationModel iSysApplicationModel;

    public AuthGetApplicationDetailRspBo getApplicationDetail(AuthGetApplicationDetailReqBo reqBo) {
        AuthGetApplicationDetailRspBo rspBo = AuthRu.success(AuthGetApplicationDetailRspBo.class);
        this.validateArg(reqBo);
        SysApplicationQryBo qryBo = new SysApplicationQryBo();
        qryBo.setApplicationId(reqBo.getApplicationId());
        SysApplicationDo rspDo = this.iSysApplicationModel.getApplicationInfoDetails(qryBo);
        AuthApplicationInfoBo applicationInfoBo = AuthRu.js(rspDo, AuthApplicationInfoBo.class);
        rspBo.setApplicationInfoBo(applicationInfoBo);
        return rspBo;
    }

    private void validateArg(AuthGetApplicationDetailReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateApplicationReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplicationId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applicationId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

