/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.application;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.application.ISysApplicationModel;
import com.tydic.dyc.authority.model.application.SysApplicationDo;
import com.tydic.dyc.authority.model.application.qrybo.SysApplicationQryBo;
import com.tydic.dyc.authority.service.application.AuthGetApplicationListService;
import com.tydic.dyc.authority.service.application.bo.AuthApplicationInfoBo;
import com.tydic.dyc.authority.service.application.bo.AuthGetApplicationListReqBo;
import com.tydic.dyc.authority.service.application.bo.AuthGetApplicationListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthGetApplicationListService.class)
public class AuthGetApplicationListServiceImpl
implements AuthGetApplicationListService {
    @Autowired
    private ISysApplicationModel iSysApplicationModel;

    public AuthGetApplicationListRspBo getApplicationList(AuthGetApplicationListReqBo reqBo) {
        AuthGetApplicationListRspBo rspBo = AuthRu.success(AuthGetApplicationListRspBo.class);
        this.validateArg(reqBo);
        SysApplicationQryBo qryBo = AuthRu.js(reqBo, SysApplicationQryBo.class);
        BasePageRspBo<SysApplicationDo> rspDo = this.iSysApplicationModel.getApplicationPageList(qryBo);
        rspBo = AuthRu.js(rspDo, AuthGetApplicationListRspBo.class);
        List<AuthApplicationInfoBo> rows = AuthRu.jsl(rspDo, AuthApplicationInfoBo.class);
        rspBo.setRows(rows);
        return rspBo;
    }

    private void validateArg(AuthGetApplicationListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateApplicationReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplicationId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applicationId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

