/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.application;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.application.ISysApplicationModel;
import com.tydic.dyc.authority.model.application.SysApplicationDo;
import com.tydic.dyc.authority.model.application.qrybo.SysApplicationQryBo;
import com.tydic.dyc.authority.service.application.AuthModifyApplicationService;
import com.tydic.dyc.authority.service.application.bo.AuthApplicationInfoBo;
import com.tydic.dyc.authority.service.application.bo.AuthModifyApplicationReqBo;
import com.tydic.dyc.authority.service.application.bo.AuthModifyApplicationRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthModifyApplicationService.class)
public class AuthModifyApplicationServiceImpl
implements AuthModifyApplicationService {
    @Autowired
    private ISysApplicationModel iSysApplicationModel;

    public AuthModifyApplicationRspBo modifyApplication(AuthModifyApplicationReqBo reqBo) {
        AuthModifyApplicationRspBo rspBo = AuthRu.success(AuthModifyApplicationRspBo.class);
        this.validateArg(reqBo);
        SysApplicationDo reqDo = this.buildDoByBO(reqBo);
        SysApplicationQryBo qryBo = new SysApplicationQryBo();
        qryBo.setApplicationId(reqBo.getApplicationId());
        SysApplicationDo detailDo = this.iSysApplicationModel.getApplicationInfoDetails(qryBo);
        if (detailDo == null || detailDo.getApplicationId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u5e94\u7528\u4fe1\u606f");
        }
        qryBo.setApplicationId(reqBo.getApplicationId());
        SysApplicationDo rspDo = this.iSysApplicationModel.modifyApplicationInfo(reqDo, qryBo);
        AuthApplicationInfoBo applicationInfoBo = AuthRu.js(rspDo, AuthApplicationInfoBo.class);
        rspBo.setAuthApplicationInfoBo(applicationInfoBo);
        return rspBo;
    }

    private SysApplicationDo buildDoByBO(AuthModifyApplicationReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysApplicationDo reqDo = AuthRu.js(reqBo, SysApplicationDo.class);
        return reqDo;
    }

    private void validateArg(AuthModifyApplicationReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateApplicationReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplicationId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[applicationId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

