/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.menu;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.menu.ISysMenuModel;
import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.service.menu.AuthModifyMenuService;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.authority.service.menu.bo.AuthModifyMenuReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthModifyMenuRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthModifyMenuService.class)
public class AuthModifyMenuServiceImpl
implements AuthModifyMenuService {
    @Autowired
    private ISysMenuModel iSysMenuModel;

    public AuthModifyMenuRspBo modifyMenu(AuthModifyMenuReqBo reqBo) {
        AuthModifyMenuRspBo rspBo = AuthRu.success(AuthModifyMenuRspBo.class);
        this.validateArg(reqBo);
        SysMenuDo reqDo = this.buildDoByBO(reqBo);
        SysMenuQryBo qryBo = new SysMenuQryBo();
        qryBo.setMenuId(reqBo.getMenuId());
        SysMenuDo detailDo = this.iSysMenuModel.getMenuInfoDetails(qryBo);
        if (detailDo == null || detailDo.getMenuId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u83dc\u5355\u4fe1\u606f");
        }
        qryBo.setMenuId(reqBo.getMenuId());
        SysMenuDo rspDo = this.iSysMenuModel.modifyMenuInfo(reqDo, qryBo);
        AuthMenuInfoBo menuInfoBo = AuthRu.js(rspDo, AuthMenuInfoBo.class);
        rspBo.setMenuInfoBo(menuInfoBo);
        return rspBo;
    }

    private SysMenuDo buildDoByBO(AuthModifyMenuReqBo reqBo) {
        reqBo.setUpdateTime(new Date());
        SysMenuDo reqDo = AuthRu.js(reqBo, SysMenuDo.class);
        return reqDo;
    }

    private void validateArg(AuthModifyMenuReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateMenuReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getMenuId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[MenuId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

