/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.organization.AuthDealOrgRoleService;
import com.tydic.dyc.authority.service.organization.bo.AuthDealOrgRoleReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthDealOrgRoleRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthDealOrgRoleService.class)
public class AuthDealOrgRoleServiceImpl
implements AuthDealOrgRoleService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    public AuthDealOrgRoleRspBo dealOrgRole(AuthDealOrgRoleReqBo reqBo) {
        AuthDealOrgRoleRspBo rspBo = AuthRu.success(AuthDealOrgRoleRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        SysOrgInfoQryBo qryBo = new SysOrgInfoQryBo();
        qryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo detailDo = this.iSysOrgInfoModel.getOrgInfoDetails(qryBo);
        if (detailDo == null || detailDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        SysOrgInfoDo userRoleDo = this.iSysOrgInfoModel.getRoleInfoListByOrg(reqDo);
        List<SysRoleInfoSubDo> oldRoleList = userRoleDo.getOrgRoleList();
        List<SysAuthDistributeSubDo> addSubDo = reqDo.getAuthDistributeList();
        ArrayList<SysAuthDistributeSubDo> eqaulsSubDo = new ArrayList<SysAuthDistributeSubDo>();
        ArrayList<SysRoleInfoSubDo> eqaulsRoleList = new ArrayList<SysRoleInfoSubDo>();
        block0: for (SysRoleInfoSubDo oldSubDo : oldRoleList) {
            for (SysAuthDistributeSubDo reqDistributeSubDo : addSubDo) {
                if (!oldSubDo.getRoleId().equals(reqDistributeSubDo.getRoleId()) || !oldSubDo.getDisFlag().equals(reqDistributeSubDo.getDisFlag())) continue;
                eqaulsSubDo.add(reqDistributeSubDo);
                eqaulsRoleList.add(oldSubDo);
                continue block0;
            }
        }
        oldRoleList.removeAll(eqaulsRoleList);
        addSubDo.removeAll(eqaulsSubDo);
        this.deleteUserRole(reqDo, oldRoleList);
        this.addUserRole(reqDo, addSubDo);
        return rspBo;
    }

    private void addUserRole(SysOrgInfoDo reqDo, List<SysAuthDistributeSubDo> addRoleList) {
        SysOrgInfoDo addReqBo = new SysOrgInfoDo();
        for (SysAuthDistributeSubDo subDo : addRoleList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setOrgTreePath(reqDo.getOrgTreePath());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.ORG);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(addRoleList);
        this.iSysOrgInfoModel.addOrgRoleList(addReqBo);
    }

    private void deleteUserRole(SysOrgInfoDo reqDo, List<SysRoleInfoSubDo> deleteRoleList) {
        SysOrgInfoDo addReqBo = new SysOrgInfoDo();
        ArrayList<SysAuthDistributeSubDo> delRoleList = new ArrayList<SysAuthDistributeSubDo>();
        for (SysRoleInfoSubDo roleSubDo : deleteRoleList) {
            SysAuthDistributeSubDo subDo = new SysAuthDistributeSubDo();
            subDo.setRoleId(roleSubDo.getRoleId());
            subDo.setOrgTreePath(reqDo.getOrgTreePath());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
            delRoleList.add(subDo);
        }
        addReqBo.setAuthDistributeList(delRoleList);
        this.iSysOrgInfoModel.updateOrgRoleList(addReqBo);
    }

    private void validateArg(AuthDealOrgRoleReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u65b0\u589e\u5217\u8868\u548c\u5220\u9664\u5217\u8868]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

