/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.service.organization.AuthEnableOrgInfoService;
import com.tydic.dyc.authority.service.organization.bo.AuthEnableOrgInfoReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthEnableOrgInfoRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthEnableOrgInfoServiceImpl
implements AuthEnableOrgInfoService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;

    public AuthEnableOrgInfoRspBo enableOrgInfo(AuthEnableOrgInfoReqBo reqBo) {
        AuthEnableOrgInfoRspBo rspBo = AuthRu.success(AuthEnableOrgInfoRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoDo reqDo = this.buildDoByBO(reqBo);
        SysOrgInfoQryBo orgQryBo = new SysOrgInfoQryBo();
        orgQryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo orgInfoDo = this.iSysOrgInfoModel.getOrgInfoDetails(orgQryBo);
        if (orgInfoDo == null || orgInfoDo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        if ("0".equals(orgInfoDo.getOrgStatus())) {
            return rspBo;
        }
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.modifyOrgInfo(reqDo, orgQryBo);
        AuthOrgInfoBo DoToBo = AuthRu.js(rspDo, AuthOrgInfoBo.class);
        rspBo.setOrgInfoBo(DoToBo);
        return rspBo;
    }

    private SysOrgInfoDo buildDoByBO(AuthEnableOrgInfoReqBo reqBo) {
        reqBo.setUpdateTime(reqBo.getUpdateTime());
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        reqDo.setDelFlag("1");
        return reqDo;
    }

    private void validateArg(AuthEnableOrgInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateOrgInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u7236\u673a\u6784Id parentId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

