/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.orgtype;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.orgtype.ISysOrgTypeModel;
import com.tydic.dyc.authority.model.orgtype.SysOrgTypeDo;
import com.tydic.dyc.authority.model.orgtype.qrybo.SysOrgTypeQryBo;
import com.tydic.dyc.authority.service.orgtype.AuthDeleteOrgTypeService;
import com.tydic.dyc.authority.service.orgtype.bo.AuthDeleteOrgTypeReqBo;
import com.tydic.dyc.authority.service.orgtype.bo.AuthDeleteOrgTypeRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthDeleteOrgTypeService.class)
public class AuthDeleteOrgTypeServiceImpl
implements AuthDeleteOrgTypeService {
    @Autowired
    private ISysOrgTypeModel iSysOrgTypeModel;

    public AuthDeleteOrgTypeRspBo deleteOrgType(AuthDeleteOrgTypeReqBo reqBo) {
        AuthDeleteOrgTypeRspBo rspBo = AuthRu.success(AuthDeleteOrgTypeRspBo.class);
        this.validateArg(reqBo);
        SysOrgTypeDo reqDo = this.buildDoByBO(reqBo);
        SysOrgTypeQryBo qryBo = new SysOrgTypeQryBo();
        qryBo.setOrgTypeId(reqBo.getOrgTypeId());
        BasePageRspBo<SysOrgTypeDo> rspDetailDo = this.iSysOrgTypeModel.getOrgTypePageList(qryBo);
        if (rspDetailDo == null || CollectionUtils.isEmpty((Collection)rspDetailDo.getRows())) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u7c7b\u578b\u4fe1\u606f");
        }
        SysOrgTypeQryBo orgQryBo = new SysOrgTypeQryBo();
        orgQryBo.setOrgTypeId(reqBo.getOrgTypeId());
        SysOrgTypeDo rspDo = this.iSysOrgTypeModel.modifyOrgTypeInfo(reqDo, orgQryBo);
        return rspBo;
    }

    private SysOrgTypeDo buildDoByBO(AuthDeleteOrgTypeReqBo reqBo) {
        SysOrgTypeDo reqDo = AuthRu.js(reqBo, SysOrgTypeDo.class);
        reqDo.setDelFlag("1");
        return reqDo;
    }

    private void validateArg(AuthDeleteOrgTypeReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDeleteOrgTypeReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgTypeId() != null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgTypeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

