/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.service.role.AuthCreateRoleInfoService;
import com.tydic.dyc.authority.service.role.bo.AuthCreateRoleInfoReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthCreateRoleInfoRspBo;
import com.tydic.dyc.authority.service.role.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthCreateRoleInfoService.class)
public class AuthCreateRoleInfoServiceImpl
implements AuthCreateRoleInfoService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    public AuthCreateRoleInfoRspBo createRoleInfo(AuthCreateRoleInfoReqBo reqBo) {
        AuthCreateRoleInfoRspBo rspBo = AuthRu.success(AuthCreateRoleInfoRspBo.class);
        this.validateArg(reqBo);
        SysRoleInfoDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setRoleId(IdUtil.nextId());
        SysRoleInfoDo rspDo = this.iSysRoleInfoModel.createRoleInfo(reqDo);
        AuthRoleInfoBo DoToBo = AuthRu.js(rspDo, AuthRoleInfoBo.class);
        rspBo.setRoleInfoBo(DoToBo);
        return rspBo;
    }

    private SysRoleInfoDo buildDoByBO(AuthCreateRoleInfoReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        return reqDo;
    }

    private void validateArg(AuthCreateRoleInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

