/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.role;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.role.AuthDealRoleOrgListService;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleOrgListReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDealRoleOrgListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="authority_CENTER_DEV", serviceInterface=AuthDealRoleOrgListService.class)
public class AuthDealRoleOrgListServiceImpl
implements AuthDealRoleOrgListService {
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    public AuthDealRoleOrgListRspBo dealRoleOrgList(AuthDealRoleOrgListReqBo reqBo) {
        AuthDealRoleOrgListRspBo rspBo = AuthRu.success(AuthDealRoleOrgListRspBo.class);
        this.validateArg(reqBo);
        SysRoleInfoQryBo qryListBo = new SysRoleInfoQryBo();
        qryListBo.setRoleId(reqBo.getRoleId());
        qryListBo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.ORG);
        SysRoleInfoDo oldRoleDo = this.iSysRoleInfoModel.getAuthDistributeList(qryListBo);
        List<SysAuthDistributeSubDo> oldDoList = oldRoleDo.getAuthDistributeList();
        SysRoleInfoDo reqDo = AuthRu.js(reqBo, SysRoleInfoDo.class);
        List<SysAuthDistributeSubDo> newDoList = reqDo.getAuthDistributeList();
        ArrayList<SysAuthDistributeSubDo> eqaulsOld = new ArrayList<SysAuthDistributeSubDo>();
        ArrayList<SysAuthDistributeSubDo> eqaulsNew = new ArrayList<SysAuthDistributeSubDo>();
        block0: for (SysAuthDistributeSubDo oldDo : oldDoList) {
            for (SysAuthDistributeSubDo newDo : newDoList) {
                if (!oldDo.getOrgTreePath().equals(newDo.getOrgTreePath()) || !oldDo.getDisFlag().equals(newDo.getDisFlag())) continue;
                eqaulsNew.add(newDo);
                eqaulsOld.add(oldDo);
                continue block0;
            }
        }
        oldDoList.removeAll(eqaulsOld);
        newDoList.removeAll(eqaulsNew);
        this.deleteRolePower(reqDo, oldDoList);
        this.addRolePower(reqDo, newDoList);
        return rspBo;
    }

    private void addRolePower(SysRoleInfoDo reqDo, List<SysAuthDistributeSubDo> newDoList) {
        SysRoleInfoDo addReqBo = new SysRoleInfoDo();
        for (SysAuthDistributeSubDo subDo : newDoList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.ORG);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(newDoList);
        this.iSysRoleInfoModel.addAuthDistribute(addReqBo);
    }

    private void deleteRolePower(SysRoleInfoDo reqDo, List<SysAuthDistributeSubDo> oldDoList) {
        SysRoleInfoDo deleteDo = new SysRoleInfoDo();
        for (SysAuthDistributeSubDo subDo : oldDoList) {
            subDo.setRoleId(reqDo.getRoleId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        deleteDo.setAuthDistributeList(oldDoList);
        this.iSysRoleInfoModel.updateAuthDistribute(deleteDo);
    }

    private void validateArg(AuthDealRoleOrgListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthDealOrgRoleReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u65b0\u589e\u5217\u8868\u548c\u5220\u9664\u5217\u8868]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            for (AuthDistributeBo bo : reqBo.getAuthDistributeList()) {
                if (bo.getOrgTreePath() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[OrgId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

